/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.monitoring.v3.QueryServiceClient;
import com.google.cloud.monitoring.v3.stub.GrpcQueryServiceStub;
import com.google.cloud.monitoring.v3.stub.QueryServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.monitoring.v3.QueryTimeSeriesRequest;
import com.google.monitoring.v3.QueryTimeSeriesResponse;
import com.google.monitoring.v3.TimeSeriesData;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class QueryServiceStubSettings
extends StubSettings<QueryServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/monitoring").add((Object)"https://www.googleapis.com/auth/monitoring.read").build();
    private final PagedCallSettings<QueryTimeSeriesRequest, QueryTimeSeriesResponse, QueryServiceClient.QueryTimeSeriesPagedResponse> queryTimeSeriesSettings;
    private static final PagedListDescriptor<QueryTimeSeriesRequest, QueryTimeSeriesResponse, TimeSeriesData> QUERY_TIME_SERIES_PAGE_STR_DESC = new PagedListDescriptor<QueryTimeSeriesRequest, QueryTimeSeriesResponse, TimeSeriesData>(){

        public String emptyToken() {
            return "";
        }

        public QueryTimeSeriesRequest injectToken(QueryTimeSeriesRequest payload, String token) {
            return QueryTimeSeriesRequest.newBuilder((QueryTimeSeriesRequest)payload).setPageToken(token).build();
        }

        public QueryTimeSeriesRequest injectPageSize(QueryTimeSeriesRequest payload, int pageSize) {
            return QueryTimeSeriesRequest.newBuilder((QueryTimeSeriesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(QueryTimeSeriesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(QueryTimeSeriesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TimeSeriesData> extractResources(QueryTimeSeriesResponse payload) {
            return payload.getTimeSeriesDataList() == null ? ImmutableList.of() : payload.getTimeSeriesDataList();
        }
    };
    private static final PagedListResponseFactory<QueryTimeSeriesRequest, QueryTimeSeriesResponse, QueryServiceClient.QueryTimeSeriesPagedResponse> QUERY_TIME_SERIES_PAGE_STR_FACT = new PagedListResponseFactory<QueryTimeSeriesRequest, QueryTimeSeriesResponse, QueryServiceClient.QueryTimeSeriesPagedResponse>(){

        public ApiFuture<QueryServiceClient.QueryTimeSeriesPagedResponse> getFuturePagedResponse(UnaryCallable<QueryTimeSeriesRequest, QueryTimeSeriesResponse> callable, QueryTimeSeriesRequest request, ApiCallContext context, ApiFuture<QueryTimeSeriesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)QUERY_TIME_SERIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return QueryServiceClient.QueryTimeSeriesPagedResponse.createAsync((PageContext<QueryTimeSeriesRequest, QueryTimeSeriesResponse, TimeSeriesData>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<QueryTimeSeriesRequest, QueryTimeSeriesResponse, QueryServiceClient.QueryTimeSeriesPagedResponse> queryTimeSeriesSettings() {
        return this.queryTimeSeriesSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public QueryServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcQueryServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "monitoring.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "monitoring.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return QueryServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(QueryServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected QueryServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.queryTimeSeriesSettings = settingsBuilder.queryTimeSeriesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<QueryServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<QueryTimeSeriesRequest, QueryTimeSeriesResponse, QueryServiceClient.QueryTimeSeriesPagedResponse> queryTimeSeriesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.queryTimeSeriesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)QUERY_TIME_SERIES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.queryTimeSeriesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(QueryServiceStubSettings settings) {
            super((StubSettings)settings);
            this.queryTimeSeriesSettings = settings.queryTimeSeriesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.queryTimeSeriesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(QueryServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)QueryServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)QueryServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(QueryServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(QueryServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.queryTimeSeriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<QueryTimeSeriesRequest, QueryTimeSeriesResponse, QueryServiceClient.QueryTimeSeriesPagedResponse> queryTimeSeriesSettings() {
            return this.queryTimeSeriesSettings;
        }

        public QueryServiceStubSettings build() throws IOException {
            return new QueryServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

