/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3;

import com.google.api.MetricDescriptor;
import com.google.api.MonitoredResourceDescriptor;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.monitoring.v3.MetricServiceSettings;
import com.google.cloud.monitoring.v3.stub.MetricServiceStub;
import com.google.cloud.monitoring.v3.stub.MetricServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.monitoring.v3.CreateMetricDescriptorRequest;
import com.google.monitoring.v3.CreateTimeSeriesRequest;
import com.google.monitoring.v3.DeleteMetricDescriptorRequest;
import com.google.monitoring.v3.GetMetricDescriptorRequest;
import com.google.monitoring.v3.GetMonitoredResourceDescriptorRequest;
import com.google.monitoring.v3.ListMetricDescriptorsRequest;
import com.google.monitoring.v3.ListMetricDescriptorsResponse;
import com.google.monitoring.v3.ListMonitoredResourceDescriptorsRequest;
import com.google.monitoring.v3.ListMonitoredResourceDescriptorsResponse;
import com.google.monitoring.v3.ListTimeSeriesRequest;
import com.google.monitoring.v3.ListTimeSeriesResponse;
import com.google.monitoring.v3.MetricDescriptorName;
import com.google.monitoring.v3.MonitoredResourceDescriptorName;
import com.google.monitoring.v3.OrganizationName;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.TimeInterval;
import com.google.monitoring.v3.TimeSeries;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class MetricServiceClient
implements BackgroundResource {
    private final MetricServiceSettings settings;
    private final MetricServiceStub stub;

    public static final MetricServiceClient create() throws IOException {
        return MetricServiceClient.create(MetricServiceSettings.newBuilder().build());
    }

    public static final MetricServiceClient create(MetricServiceSettings settings) throws IOException {
        return new MetricServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final MetricServiceClient create(MetricServiceStub stub) {
        return new MetricServiceClient(stub);
    }

    protected MetricServiceClient(MetricServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((MetricServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected MetricServiceClient(MetricServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final MetricServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public MetricServiceStub getStub() {
        return this.stub;
    }

    public final ListMonitoredResourceDescriptorsPagedResponse listMonitoredResourceDescriptors(ResourceName name) {
        ListMonitoredResourceDescriptorsRequest request = ListMonitoredResourceDescriptorsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listMonitoredResourceDescriptors(request);
    }

    public final ListMonitoredResourceDescriptorsPagedResponse listMonitoredResourceDescriptors(OrganizationName name) {
        ListMonitoredResourceDescriptorsRequest request = ListMonitoredResourceDescriptorsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listMonitoredResourceDescriptors(request);
    }

    public final ListMonitoredResourceDescriptorsPagedResponse listMonitoredResourceDescriptors(ProjectName name) {
        ListMonitoredResourceDescriptorsRequest request = ListMonitoredResourceDescriptorsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listMonitoredResourceDescriptors(request);
    }

    public final ListMonitoredResourceDescriptorsPagedResponse listMonitoredResourceDescriptors(String name) {
        ListMonitoredResourceDescriptorsRequest request = ListMonitoredResourceDescriptorsRequest.newBuilder().setName(name).build();
        return this.listMonitoredResourceDescriptors(request);
    }

    public final ListMonitoredResourceDescriptorsPagedResponse listMonitoredResourceDescriptors(ListMonitoredResourceDescriptorsRequest request) {
        return (ListMonitoredResourceDescriptorsPagedResponse)((Object)this.listMonitoredResourceDescriptorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsPagedCallable() {
        return this.stub.listMonitoredResourceDescriptorsPagedCallable();
    }

    public final UnaryCallable<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse> listMonitoredResourceDescriptorsCallable() {
        return this.stub.listMonitoredResourceDescriptorsCallable();
    }

    public final MonitoredResourceDescriptor getMonitoredResourceDescriptor(MonitoredResourceDescriptorName name) {
        GetMonitoredResourceDescriptorRequest request = GetMonitoredResourceDescriptorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMonitoredResourceDescriptor(request);
    }

    public final MonitoredResourceDescriptor getMonitoredResourceDescriptor(String name) {
        GetMonitoredResourceDescriptorRequest request = GetMonitoredResourceDescriptorRequest.newBuilder().setName(name).build();
        return this.getMonitoredResourceDescriptor(request);
    }

    public final MonitoredResourceDescriptor getMonitoredResourceDescriptor(GetMonitoredResourceDescriptorRequest request) {
        return (MonitoredResourceDescriptor)this.getMonitoredResourceDescriptorCallable().call((Object)request);
    }

    public final UnaryCallable<GetMonitoredResourceDescriptorRequest, MonitoredResourceDescriptor> getMonitoredResourceDescriptorCallable() {
        return this.stub.getMonitoredResourceDescriptorCallable();
    }

    public final ListMetricDescriptorsPagedResponse listMetricDescriptors(ResourceName name) {
        ListMetricDescriptorsRequest request = ListMetricDescriptorsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listMetricDescriptors(request);
    }

    public final ListMetricDescriptorsPagedResponse listMetricDescriptors(OrganizationName name) {
        ListMetricDescriptorsRequest request = ListMetricDescriptorsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listMetricDescriptors(request);
    }

    public final ListMetricDescriptorsPagedResponse listMetricDescriptors(ProjectName name) {
        ListMetricDescriptorsRequest request = ListMetricDescriptorsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listMetricDescriptors(request);
    }

    public final ListMetricDescriptorsPagedResponse listMetricDescriptors(String name) {
        ListMetricDescriptorsRequest request = ListMetricDescriptorsRequest.newBuilder().setName(name).build();
        return this.listMetricDescriptors(request);
    }

    public final ListMetricDescriptorsPagedResponse listMetricDescriptors(ListMetricDescriptorsRequest request) {
        return (ListMetricDescriptorsPagedResponse)((Object)this.listMetricDescriptorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMetricDescriptorsRequest, ListMetricDescriptorsPagedResponse> listMetricDescriptorsPagedCallable() {
        return this.stub.listMetricDescriptorsPagedCallable();
    }

    public final UnaryCallable<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse> listMetricDescriptorsCallable() {
        return this.stub.listMetricDescriptorsCallable();
    }

    public final MetricDescriptor getMetricDescriptor(MetricDescriptorName name) {
        GetMetricDescriptorRequest request = GetMetricDescriptorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMetricDescriptor(request);
    }

    public final MetricDescriptor getMetricDescriptor(String name) {
        GetMetricDescriptorRequest request = GetMetricDescriptorRequest.newBuilder().setName(name).build();
        return this.getMetricDescriptor(request);
    }

    public final MetricDescriptor getMetricDescriptor(GetMetricDescriptorRequest request) {
        return (MetricDescriptor)this.getMetricDescriptorCallable().call((Object)request);
    }

    public final UnaryCallable<GetMetricDescriptorRequest, MetricDescriptor> getMetricDescriptorCallable() {
        return this.stub.getMetricDescriptorCallable();
    }

    public final MetricDescriptor createMetricDescriptor(ResourceName name, MetricDescriptor metricDescriptor) {
        CreateMetricDescriptorRequest request = CreateMetricDescriptorRequest.newBuilder().setName(name == null ? null : name.toString()).setMetricDescriptor(metricDescriptor).build();
        return this.createMetricDescriptor(request);
    }

    public final MetricDescriptor createMetricDescriptor(OrganizationName name, MetricDescriptor metricDescriptor) {
        CreateMetricDescriptorRequest request = CreateMetricDescriptorRequest.newBuilder().setName(name == null ? null : name.toString()).setMetricDescriptor(metricDescriptor).build();
        return this.createMetricDescriptor(request);
    }

    public final MetricDescriptor createMetricDescriptor(ProjectName name, MetricDescriptor metricDescriptor) {
        CreateMetricDescriptorRequest request = CreateMetricDescriptorRequest.newBuilder().setName(name == null ? null : name.toString()).setMetricDescriptor(metricDescriptor).build();
        return this.createMetricDescriptor(request);
    }

    public final MetricDescriptor createMetricDescriptor(String name, MetricDescriptor metricDescriptor) {
        CreateMetricDescriptorRequest request = CreateMetricDescriptorRequest.newBuilder().setName(name).setMetricDescriptor(metricDescriptor).build();
        return this.createMetricDescriptor(request);
    }

    public final MetricDescriptor createMetricDescriptor(CreateMetricDescriptorRequest request) {
        return (MetricDescriptor)this.createMetricDescriptorCallable().call((Object)request);
    }

    public final UnaryCallable<CreateMetricDescriptorRequest, MetricDescriptor> createMetricDescriptorCallable() {
        return this.stub.createMetricDescriptorCallable();
    }

    public final void deleteMetricDescriptor(MetricDescriptorName name) {
        DeleteMetricDescriptorRequest request = DeleteMetricDescriptorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteMetricDescriptor(request);
    }

    public final void deleteMetricDescriptor(String name) {
        DeleteMetricDescriptorRequest request = DeleteMetricDescriptorRequest.newBuilder().setName(name).build();
        this.deleteMetricDescriptor(request);
    }

    public final void deleteMetricDescriptor(DeleteMetricDescriptorRequest request) {
        this.deleteMetricDescriptorCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteMetricDescriptorRequest, Empty> deleteMetricDescriptorCallable() {
        return this.stub.deleteMetricDescriptorCallable();
    }

    public final ListTimeSeriesPagedResponse listTimeSeries(ResourceName name, String filter, TimeInterval interval, ListTimeSeriesRequest.TimeSeriesView view) {
        ListTimeSeriesRequest request = ListTimeSeriesRequest.newBuilder().setName(name == null ? null : name.toString()).setFilter(filter).setInterval(interval).setView(view).build();
        return this.listTimeSeries(request);
    }

    public final ListTimeSeriesPagedResponse listTimeSeries(OrganizationName name, String filter, TimeInterval interval, ListTimeSeriesRequest.TimeSeriesView view) {
        ListTimeSeriesRequest request = ListTimeSeriesRequest.newBuilder().setName(name == null ? null : name.toString()).setFilter(filter).setInterval(interval).setView(view).build();
        return this.listTimeSeries(request);
    }

    public final ListTimeSeriesPagedResponse listTimeSeries(ProjectName name, String filter, TimeInterval interval, ListTimeSeriesRequest.TimeSeriesView view) {
        ListTimeSeriesRequest request = ListTimeSeriesRequest.newBuilder().setName(name == null ? null : name.toString()).setFilter(filter).setInterval(interval).setView(view).build();
        return this.listTimeSeries(request);
    }

    public final ListTimeSeriesPagedResponse listTimeSeries(String name, String filter, TimeInterval interval, ListTimeSeriesRequest.TimeSeriesView view) {
        ListTimeSeriesRequest request = ListTimeSeriesRequest.newBuilder().setName(name).setFilter(filter).setInterval(interval).setView(view).build();
        return this.listTimeSeries(request);
    }

    public final ListTimeSeriesPagedResponse listTimeSeries(ListTimeSeriesRequest request) {
        return (ListTimeSeriesPagedResponse)((Object)this.listTimeSeriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTimeSeriesRequest, ListTimeSeriesPagedResponse> listTimeSeriesPagedCallable() {
        return this.stub.listTimeSeriesPagedCallable();
    }

    public final UnaryCallable<ListTimeSeriesRequest, ListTimeSeriesResponse> listTimeSeriesCallable() {
        return this.stub.listTimeSeriesCallable();
    }

    public final void createTimeSeries(ProjectName name, List<TimeSeries> timeSeries) {
        CreateTimeSeriesRequest request = CreateTimeSeriesRequest.newBuilder().setName(name == null ? null : name.toString()).addAllTimeSeries(timeSeries).build();
        this.createTimeSeries(request);
    }

    public final void createTimeSeries(String name, List<TimeSeries> timeSeries) {
        CreateTimeSeriesRequest request = CreateTimeSeriesRequest.newBuilder().setName(name).addAllTimeSeries(timeSeries).build();
        this.createTimeSeries(request);
    }

    public final void createTimeSeries(CreateTimeSeriesRequest request) {
        this.createTimeSeriesCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTimeSeriesRequest, Empty> createTimeSeriesCallable() {
        return this.stub.createTimeSeriesCallable();
    }

    public final void createServiceTimeSeries(ProjectName name, List<TimeSeries> timeSeries) {
        CreateTimeSeriesRequest request = CreateTimeSeriesRequest.newBuilder().setName(name == null ? null : name.toString()).addAllTimeSeries(timeSeries).build();
        this.createServiceTimeSeries(request);
    }

    public final void createServiceTimeSeries(String name, List<TimeSeries> timeSeries) {
        CreateTimeSeriesRequest request = CreateTimeSeriesRequest.newBuilder().setName(name).addAllTimeSeries(timeSeries).build();
        this.createServiceTimeSeries(request);
    }

    public final void createServiceTimeSeries(CreateTimeSeriesRequest request) {
        this.createServiceTimeSeriesCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTimeSeriesRequest, Empty> createServiceTimeSeriesCallable() {
        return this.stub.createServiceTimeSeriesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTimeSeriesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTimeSeriesRequest, ListTimeSeriesResponse, TimeSeries, ListTimeSeriesPage, ListTimeSeriesFixedSizeCollection> {
        private ListTimeSeriesFixedSizeCollection(List<ListTimeSeriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTimeSeriesFixedSizeCollection createEmptyCollection() {
            return new ListTimeSeriesFixedSizeCollection(null, 0);
        }

        protected ListTimeSeriesFixedSizeCollection createCollection(List<ListTimeSeriesPage> pages, int collectionSize) {
            return new ListTimeSeriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTimeSeriesPage
    extends AbstractPage<ListTimeSeriesRequest, ListTimeSeriesResponse, TimeSeries, ListTimeSeriesPage> {
        private ListTimeSeriesPage(PageContext<ListTimeSeriesRequest, ListTimeSeriesResponse, TimeSeries> context, ListTimeSeriesResponse response) {
            super(context, (Object)response);
        }

        private static ListTimeSeriesPage createEmptyPage() {
            return new ListTimeSeriesPage(null, null);
        }

        protected ListTimeSeriesPage createPage(PageContext<ListTimeSeriesRequest, ListTimeSeriesResponse, TimeSeries> context, ListTimeSeriesResponse response) {
            return new ListTimeSeriesPage(context, response);
        }

        public ApiFuture<ListTimeSeriesPage> createPageAsync(PageContext<ListTimeSeriesRequest, ListTimeSeriesResponse, TimeSeries> context, ApiFuture<ListTimeSeriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTimeSeriesPagedResponse
    extends AbstractPagedListResponse<ListTimeSeriesRequest, ListTimeSeriesResponse, TimeSeries, ListTimeSeriesPage, ListTimeSeriesFixedSizeCollection> {
        public static ApiFuture<ListTimeSeriesPagedResponse> createAsync(PageContext<ListTimeSeriesRequest, ListTimeSeriesResponse, TimeSeries> context, ApiFuture<ListTimeSeriesResponse> futureResponse) {
            ApiFuture<ListTimeSeriesPage> futurePage = ListTimeSeriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTimeSeriesPagedResponse((ListTimeSeriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTimeSeriesPagedResponse(ListTimeSeriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTimeSeriesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMetricDescriptorsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse, MetricDescriptor, ListMetricDescriptorsPage, ListMetricDescriptorsFixedSizeCollection> {
        private ListMetricDescriptorsFixedSizeCollection(List<ListMetricDescriptorsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMetricDescriptorsFixedSizeCollection createEmptyCollection() {
            return new ListMetricDescriptorsFixedSizeCollection(null, 0);
        }

        protected ListMetricDescriptorsFixedSizeCollection createCollection(List<ListMetricDescriptorsPage> pages, int collectionSize) {
            return new ListMetricDescriptorsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMetricDescriptorsPage
    extends AbstractPage<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse, MetricDescriptor, ListMetricDescriptorsPage> {
        private ListMetricDescriptorsPage(PageContext<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse, MetricDescriptor> context, ListMetricDescriptorsResponse response) {
            super(context, (Object)response);
        }

        private static ListMetricDescriptorsPage createEmptyPage() {
            return new ListMetricDescriptorsPage(null, null);
        }

        protected ListMetricDescriptorsPage createPage(PageContext<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse, MetricDescriptor> context, ListMetricDescriptorsResponse response) {
            return new ListMetricDescriptorsPage(context, response);
        }

        public ApiFuture<ListMetricDescriptorsPage> createPageAsync(PageContext<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse, MetricDescriptor> context, ApiFuture<ListMetricDescriptorsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMetricDescriptorsPagedResponse
    extends AbstractPagedListResponse<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse, MetricDescriptor, ListMetricDescriptorsPage, ListMetricDescriptorsFixedSizeCollection> {
        public static ApiFuture<ListMetricDescriptorsPagedResponse> createAsync(PageContext<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse, MetricDescriptor> context, ApiFuture<ListMetricDescriptorsResponse> futureResponse) {
            ApiFuture<ListMetricDescriptorsPage> futurePage = ListMetricDescriptorsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMetricDescriptorsPagedResponse((ListMetricDescriptorsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMetricDescriptorsPagedResponse(ListMetricDescriptorsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMetricDescriptorsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMonitoredResourceDescriptorsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor, ListMonitoredResourceDescriptorsPage, ListMonitoredResourceDescriptorsFixedSizeCollection> {
        private ListMonitoredResourceDescriptorsFixedSizeCollection(List<ListMonitoredResourceDescriptorsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMonitoredResourceDescriptorsFixedSizeCollection createEmptyCollection() {
            return new ListMonitoredResourceDescriptorsFixedSizeCollection(null, 0);
        }

        protected ListMonitoredResourceDescriptorsFixedSizeCollection createCollection(List<ListMonitoredResourceDescriptorsPage> pages, int collectionSize) {
            return new ListMonitoredResourceDescriptorsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMonitoredResourceDescriptorsPage
    extends AbstractPage<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor, ListMonitoredResourceDescriptorsPage> {
        private ListMonitoredResourceDescriptorsPage(PageContext<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor> context, ListMonitoredResourceDescriptorsResponse response) {
            super(context, (Object)response);
        }

        private static ListMonitoredResourceDescriptorsPage createEmptyPage() {
            return new ListMonitoredResourceDescriptorsPage(null, null);
        }

        protected ListMonitoredResourceDescriptorsPage createPage(PageContext<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor> context, ListMonitoredResourceDescriptorsResponse response) {
            return new ListMonitoredResourceDescriptorsPage(context, response);
        }

        public ApiFuture<ListMonitoredResourceDescriptorsPage> createPageAsync(PageContext<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor> context, ApiFuture<ListMonitoredResourceDescriptorsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMonitoredResourceDescriptorsPagedResponse
    extends AbstractPagedListResponse<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor, ListMonitoredResourceDescriptorsPage, ListMonitoredResourceDescriptorsFixedSizeCollection> {
        public static ApiFuture<ListMonitoredResourceDescriptorsPagedResponse> createAsync(PageContext<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor> context, ApiFuture<ListMonitoredResourceDescriptorsResponse> futureResponse) {
            ApiFuture<ListMonitoredResourceDescriptorsPage> futurePage = ListMonitoredResourceDescriptorsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMonitoredResourceDescriptorsPagedResponse((ListMonitoredResourceDescriptorsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMonitoredResourceDescriptorsPagedResponse(ListMonitoredResourceDescriptorsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMonitoredResourceDescriptorsFixedSizeCollection.createEmptyCollection());
        }
    }
}

