/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.monitoring.v3.ServiceMonitoringServiceSettings;
import com.google.cloud.monitoring.v3.stub.ServiceMonitoringServiceStub;
import com.google.cloud.monitoring.v3.stub.ServiceMonitoringServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.monitoring.v3.CreateServiceLevelObjectiveRequest;
import com.google.monitoring.v3.CreateServiceRequest;
import com.google.monitoring.v3.DeleteServiceLevelObjectiveRequest;
import com.google.monitoring.v3.DeleteServiceRequest;
import com.google.monitoring.v3.GetServiceLevelObjectiveRequest;
import com.google.monitoring.v3.GetServiceRequest;
import com.google.monitoring.v3.ListServiceLevelObjectivesRequest;
import com.google.monitoring.v3.ListServiceLevelObjectivesResponse;
import com.google.monitoring.v3.ListServicesRequest;
import com.google.monitoring.v3.ListServicesResponse;
import com.google.monitoring.v3.OrganizationName;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.Service;
import com.google.monitoring.v3.ServiceLevelObjective;
import com.google.monitoring.v3.ServiceLevelObjectiveName;
import com.google.monitoring.v3.ServiceName;
import com.google.monitoring.v3.UpdateServiceLevelObjectiveRequest;
import com.google.monitoring.v3.UpdateServiceRequest;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ServiceMonitoringServiceClient
implements BackgroundResource {
    private final ServiceMonitoringServiceSettings settings;
    private final ServiceMonitoringServiceStub stub;

    public static final ServiceMonitoringServiceClient create() throws IOException {
        return ServiceMonitoringServiceClient.create(ServiceMonitoringServiceSettings.newBuilder().build());
    }

    public static final ServiceMonitoringServiceClient create(ServiceMonitoringServiceSettings settings) throws IOException {
        return new ServiceMonitoringServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ServiceMonitoringServiceClient create(ServiceMonitoringServiceStub stub) {
        return new ServiceMonitoringServiceClient(stub);
    }

    protected ServiceMonitoringServiceClient(ServiceMonitoringServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ServiceMonitoringServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ServiceMonitoringServiceClient(ServiceMonitoringServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ServiceMonitoringServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ServiceMonitoringServiceStub getStub() {
        return this.stub;
    }

    public final Service createService(ResourceName parent, Service service) {
        CreateServiceRequest request = CreateServiceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setService(service).build();
        return this.createService(request);
    }

    public final Service createService(OrganizationName parent, Service service) {
        CreateServiceRequest request = CreateServiceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setService(service).build();
        return this.createService(request);
    }

    public final Service createService(ProjectName parent, Service service) {
        CreateServiceRequest request = CreateServiceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setService(service).build();
        return this.createService(request);
    }

    public final Service createService(String parent, Service service) {
        CreateServiceRequest request = CreateServiceRequest.newBuilder().setParent(parent).setService(service).build();
        return this.createService(request);
    }

    public final Service createService(CreateServiceRequest request) {
        return (Service)this.createServiceCallable().call((Object)request);
    }

    public final UnaryCallable<CreateServiceRequest, Service> createServiceCallable() {
        return this.stub.createServiceCallable();
    }

    public final Service getService(ServiceName name) {
        GetServiceRequest request = GetServiceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getService(request);
    }

    public final Service getService(String name) {
        GetServiceRequest request = GetServiceRequest.newBuilder().setName(name).build();
        return this.getService(request);
    }

    public final Service getService(GetServiceRequest request) {
        return (Service)this.getServiceCallable().call((Object)request);
    }

    public final UnaryCallable<GetServiceRequest, Service> getServiceCallable() {
        return this.stub.getServiceCallable();
    }

    public final ListServicesPagedResponse listServices(ResourceName parent) {
        ListServicesRequest request = ListServicesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listServices(request);
    }

    public final ListServicesPagedResponse listServices(OrganizationName parent) {
        ListServicesRequest request = ListServicesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listServices(request);
    }

    public final ListServicesPagedResponse listServices(ProjectName parent) {
        ListServicesRequest request = ListServicesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listServices(request);
    }

    public final ListServicesPagedResponse listServices(String parent) {
        ListServicesRequest request = ListServicesRequest.newBuilder().setParent(parent).build();
        return this.listServices(request);
    }

    public final ListServicesPagedResponse listServices(ListServicesRequest request) {
        return (ListServicesPagedResponse)((Object)this.listServicesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListServicesRequest, ListServicesPagedResponse> listServicesPagedCallable() {
        return this.stub.listServicesPagedCallable();
    }

    public final UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable() {
        return this.stub.listServicesCallable();
    }

    public final Service updateService(Service service) {
        UpdateServiceRequest request = UpdateServiceRequest.newBuilder().setService(service).build();
        return this.updateService(request);
    }

    public final Service updateService(UpdateServiceRequest request) {
        return (Service)this.updateServiceCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateServiceRequest, Service> updateServiceCallable() {
        return this.stub.updateServiceCallable();
    }

    public final void deleteService(ServiceName name) {
        DeleteServiceRequest request = DeleteServiceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteService(request);
    }

    public final void deleteService(String name) {
        DeleteServiceRequest request = DeleteServiceRequest.newBuilder().setName(name).build();
        this.deleteService(request);
    }

    public final void deleteService(DeleteServiceRequest request) {
        this.deleteServiceCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteServiceRequest, Empty> deleteServiceCallable() {
        return this.stub.deleteServiceCallable();
    }

    public final ServiceLevelObjective createServiceLevelObjective(ServiceName parent, ServiceLevelObjective serviceLevelObjective) {
        CreateServiceLevelObjectiveRequest request = CreateServiceLevelObjectiveRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setServiceLevelObjective(serviceLevelObjective).build();
        return this.createServiceLevelObjective(request);
    }

    public final ServiceLevelObjective createServiceLevelObjective(String parent, ServiceLevelObjective serviceLevelObjective) {
        CreateServiceLevelObjectiveRequest request = CreateServiceLevelObjectiveRequest.newBuilder().setParent(parent).setServiceLevelObjective(serviceLevelObjective).build();
        return this.createServiceLevelObjective(request);
    }

    public final ServiceLevelObjective createServiceLevelObjective(CreateServiceLevelObjectiveRequest request) {
        return (ServiceLevelObjective)this.createServiceLevelObjectiveCallable().call((Object)request);
    }

    public final UnaryCallable<CreateServiceLevelObjectiveRequest, ServiceLevelObjective> createServiceLevelObjectiveCallable() {
        return this.stub.createServiceLevelObjectiveCallable();
    }

    public final ServiceLevelObjective getServiceLevelObjective(ServiceLevelObjectiveName name) {
        GetServiceLevelObjectiveRequest request = GetServiceLevelObjectiveRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getServiceLevelObjective(request);
    }

    public final ServiceLevelObjective getServiceLevelObjective(String name) {
        GetServiceLevelObjectiveRequest request = GetServiceLevelObjectiveRequest.newBuilder().setName(name).build();
        return this.getServiceLevelObjective(request);
    }

    public final ServiceLevelObjective getServiceLevelObjective(GetServiceLevelObjectiveRequest request) {
        return (ServiceLevelObjective)this.getServiceLevelObjectiveCallable().call((Object)request);
    }

    public final UnaryCallable<GetServiceLevelObjectiveRequest, ServiceLevelObjective> getServiceLevelObjectiveCallable() {
        return this.stub.getServiceLevelObjectiveCallable();
    }

    public final ListServiceLevelObjectivesPagedResponse listServiceLevelObjectives(ServiceName parent) {
        ListServiceLevelObjectivesRequest request = ListServiceLevelObjectivesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listServiceLevelObjectives(request);
    }

    public final ListServiceLevelObjectivesPagedResponse listServiceLevelObjectives(String parent) {
        ListServiceLevelObjectivesRequest request = ListServiceLevelObjectivesRequest.newBuilder().setParent(parent).build();
        return this.listServiceLevelObjectives(request);
    }

    public final ListServiceLevelObjectivesPagedResponse listServiceLevelObjectives(ListServiceLevelObjectivesRequest request) {
        return (ListServiceLevelObjectivesPagedResponse)((Object)this.listServiceLevelObjectivesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesPagedResponse> listServiceLevelObjectivesPagedCallable() {
        return this.stub.listServiceLevelObjectivesPagedCallable();
    }

    public final UnaryCallable<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse> listServiceLevelObjectivesCallable() {
        return this.stub.listServiceLevelObjectivesCallable();
    }

    public final ServiceLevelObjective updateServiceLevelObjective(ServiceLevelObjective serviceLevelObjective) {
        UpdateServiceLevelObjectiveRequest request = UpdateServiceLevelObjectiveRequest.newBuilder().setServiceLevelObjective(serviceLevelObjective).build();
        return this.updateServiceLevelObjective(request);
    }

    public final ServiceLevelObjective updateServiceLevelObjective(UpdateServiceLevelObjectiveRequest request) {
        return (ServiceLevelObjective)this.updateServiceLevelObjectiveCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateServiceLevelObjectiveRequest, ServiceLevelObjective> updateServiceLevelObjectiveCallable() {
        return this.stub.updateServiceLevelObjectiveCallable();
    }

    public final void deleteServiceLevelObjective(ServiceLevelObjectiveName name) {
        DeleteServiceLevelObjectiveRequest request = DeleteServiceLevelObjectiveRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteServiceLevelObjective(request);
    }

    public final void deleteServiceLevelObjective(String name) {
        DeleteServiceLevelObjectiveRequest request = DeleteServiceLevelObjectiveRequest.newBuilder().setName(name).build();
        this.deleteServiceLevelObjective(request);
    }

    public final void deleteServiceLevelObjective(DeleteServiceLevelObjectiveRequest request) {
        this.deleteServiceLevelObjectiveCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteServiceLevelObjectiveRequest, Empty> deleteServiceLevelObjectiveCallable() {
        return this.stub.deleteServiceLevelObjectiveCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListServiceLevelObjectivesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse, ServiceLevelObjective, ListServiceLevelObjectivesPage, ListServiceLevelObjectivesFixedSizeCollection> {
        private ListServiceLevelObjectivesFixedSizeCollection(List<ListServiceLevelObjectivesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListServiceLevelObjectivesFixedSizeCollection createEmptyCollection() {
            return new ListServiceLevelObjectivesFixedSizeCollection(null, 0);
        }

        protected ListServiceLevelObjectivesFixedSizeCollection createCollection(List<ListServiceLevelObjectivesPage> pages, int collectionSize) {
            return new ListServiceLevelObjectivesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListServiceLevelObjectivesPage
    extends AbstractPage<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse, ServiceLevelObjective, ListServiceLevelObjectivesPage> {
        private ListServiceLevelObjectivesPage(PageContext<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse, ServiceLevelObjective> context, ListServiceLevelObjectivesResponse response) {
            super(context, (Object)response);
        }

        private static ListServiceLevelObjectivesPage createEmptyPage() {
            return new ListServiceLevelObjectivesPage(null, null);
        }

        protected ListServiceLevelObjectivesPage createPage(PageContext<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse, ServiceLevelObjective> context, ListServiceLevelObjectivesResponse response) {
            return new ListServiceLevelObjectivesPage(context, response);
        }

        public ApiFuture<ListServiceLevelObjectivesPage> createPageAsync(PageContext<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse, ServiceLevelObjective> context, ApiFuture<ListServiceLevelObjectivesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListServiceLevelObjectivesPagedResponse
    extends AbstractPagedListResponse<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse, ServiceLevelObjective, ListServiceLevelObjectivesPage, ListServiceLevelObjectivesFixedSizeCollection> {
        public static ApiFuture<ListServiceLevelObjectivesPagedResponse> createAsync(PageContext<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse, ServiceLevelObjective> context, ApiFuture<ListServiceLevelObjectivesResponse> futureResponse) {
            ApiFuture<ListServiceLevelObjectivesPage> futurePage = ListServiceLevelObjectivesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListServiceLevelObjectivesPagedResponse((ListServiceLevelObjectivesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListServiceLevelObjectivesPagedResponse(ListServiceLevelObjectivesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListServiceLevelObjectivesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListServicesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListServicesRequest, ListServicesResponse, Service, ListServicesPage, ListServicesFixedSizeCollection> {
        private ListServicesFixedSizeCollection(List<ListServicesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListServicesFixedSizeCollection createEmptyCollection() {
            return new ListServicesFixedSizeCollection(null, 0);
        }

        protected ListServicesFixedSizeCollection createCollection(List<ListServicesPage> pages, int collectionSize) {
            return new ListServicesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListServicesPage
    extends AbstractPage<ListServicesRequest, ListServicesResponse, Service, ListServicesPage> {
        private ListServicesPage(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ListServicesResponse response) {
            super(context, (Object)response);
        }

        private static ListServicesPage createEmptyPage() {
            return new ListServicesPage(null, null);
        }

        protected ListServicesPage createPage(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ListServicesResponse response) {
            return new ListServicesPage(context, response);
        }

        public ApiFuture<ListServicesPage> createPageAsync(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ApiFuture<ListServicesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListServicesPagedResponse
    extends AbstractPagedListResponse<ListServicesRequest, ListServicesResponse, Service, ListServicesPage, ListServicesFixedSizeCollection> {
        public static ApiFuture<ListServicesPagedResponse> createAsync(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ApiFuture<ListServicesResponse> futureResponse) {
            ApiFuture<ListServicesPage> futurePage = ListServicesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListServicesPagedResponse((ListServicesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListServicesPagedResponse(ListServicesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListServicesFixedSizeCollection.createEmptyCollection());
        }
    }
}

