/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3;

import com.google.api.MonitoredResource;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.monitoring.v3.GroupServiceClient;
import com.google.cloud.monitoring.v3.GroupServiceSettings;
import com.google.cloud.monitoring.v3.MockGroupService;
import com.google.common.collect.Lists;
import com.google.monitoring.v3.CreateGroupRequest;
import com.google.monitoring.v3.DeleteGroupRequest;
import com.google.monitoring.v3.FolderName;
import com.google.monitoring.v3.GetGroupRequest;
import com.google.monitoring.v3.Group;
import com.google.monitoring.v3.GroupName;
import com.google.monitoring.v3.ListGroupMembersRequest;
import com.google.monitoring.v3.ListGroupMembersResponse;
import com.google.monitoring.v3.ListGroupsRequest;
import com.google.monitoring.v3.ListGroupsResponse;
import com.google.monitoring.v3.OrganizationName;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.UpdateGroupRequest;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Empty;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class GroupServiceClientTest {
    private static MockGroupService mockGroupService;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private GroupServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockGroupService = new MockGroupService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockGroupService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        GroupServiceSettings settings = ((GroupServiceSettings.Builder)((GroupServiceSettings.Builder)GroupServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = GroupServiceClient.create((GroupServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listGroupsTest() throws Exception {
        Group responsesElement = Group.newBuilder().build();
        ListGroupsResponse expectedResponse = ListGroupsResponse.newBuilder().setNextPageToken("").addAllGroup(Arrays.asList(responsesElement)).build();
        mockGroupService.addResponse((AbstractMessage)expectedResponse);
        FolderName name = FolderName.of((String)"[FOLDER]");
        GroupServiceClient.ListGroupsPagedResponse pagedListResponse = this.client.listGroups((ResourceName)name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGroupList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockGroupService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListGroupsRequest actualRequest = (ListGroupsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listGroupsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGroupService.addException((Exception)exception);
        try {
            FolderName name = FolderName.of((String)"[FOLDER]");
            this.client.listGroups((ResourceName)name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listGroupsTest2() throws Exception {
        Group responsesElement = Group.newBuilder().build();
        ListGroupsResponse expectedResponse = ListGroupsResponse.newBuilder().setNextPageToken("").addAllGroup(Arrays.asList(responsesElement)).build();
        mockGroupService.addResponse((AbstractMessage)expectedResponse);
        OrganizationName name = OrganizationName.of((String)"[ORGANIZATION]");
        GroupServiceClient.ListGroupsPagedResponse pagedListResponse = this.client.listGroups(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGroupList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockGroupService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListGroupsRequest actualRequest = (ListGroupsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listGroupsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGroupService.addException((Exception)exception);
        try {
            OrganizationName name = OrganizationName.of((String)"[ORGANIZATION]");
            this.client.listGroups(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listGroupsTest3() throws Exception {
        Group responsesElement = Group.newBuilder().build();
        ListGroupsResponse expectedResponse = ListGroupsResponse.newBuilder().setNextPageToken("").addAllGroup(Arrays.asList(responsesElement)).build();
        mockGroupService.addResponse((AbstractMessage)expectedResponse);
        ProjectName name = ProjectName.of((String)"[PROJECT]");
        GroupServiceClient.ListGroupsPagedResponse pagedListResponse = this.client.listGroups(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGroupList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockGroupService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListGroupsRequest actualRequest = (ListGroupsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listGroupsExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGroupService.addException((Exception)exception);
        try {
            ProjectName name = ProjectName.of((String)"[PROJECT]");
            this.client.listGroups(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listGroupsTest4() throws Exception {
        Group responsesElement = Group.newBuilder().build();
        ListGroupsResponse expectedResponse = ListGroupsResponse.newBuilder().setNextPageToken("").addAllGroup(Arrays.asList(responsesElement)).build();
        mockGroupService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        GroupServiceClient.ListGroupsPagedResponse pagedListResponse = this.client.listGroups(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGroupList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockGroupService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListGroupsRequest actualRequest = (ListGroupsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listGroupsExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGroupService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.listGroups(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getGroupTest() throws Exception {
        Group expectedResponse = Group.newBuilder().setName(GroupName.ofProjectGroupName((String)"[PROJECT]", (String)"[GROUP]").toString()).setDisplayName("displayName1714148973").setParentName("parentName-244870571").setFilter("filter-1274492040").setIsCluster(true).build();
        mockGroupService.addResponse((AbstractMessage)expectedResponse);
        GroupName name = GroupName.ofProjectGroupName((String)"[PROJECT]", (String)"[GROUP]");
        Group actualResponse = this.client.getGroup(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGroupService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetGroupRequest actualRequest = (GetGroupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getGroupExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGroupService.addException((Exception)exception);
        try {
            GroupName name = GroupName.ofProjectGroupName((String)"[PROJECT]", (String)"[GROUP]");
            this.client.getGroup(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getGroupTest2() throws Exception {
        Group expectedResponse = Group.newBuilder().setName(GroupName.ofProjectGroupName((String)"[PROJECT]", (String)"[GROUP]").toString()).setDisplayName("displayName1714148973").setParentName("parentName-244870571").setFilter("filter-1274492040").setIsCluster(true).build();
        mockGroupService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Group actualResponse = this.client.getGroup(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGroupService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetGroupRequest actualRequest = (GetGroupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getGroupExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGroupService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getGroup(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createGroupTest() throws Exception {
        Group expectedResponse = Group.newBuilder().setName(GroupName.ofProjectGroupName((String)"[PROJECT]", (String)"[GROUP]").toString()).setDisplayName("displayName1714148973").setParentName("parentName-244870571").setFilter("filter-1274492040").setIsCluster(true).build();
        mockGroupService.addResponse((AbstractMessage)expectedResponse);
        FolderName name = FolderName.of((String)"[FOLDER]");
        Group group = Group.newBuilder().build();
        Group actualResponse = this.client.createGroup((ResourceName)name, group);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGroupService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateGroupRequest actualRequest = (CreateGroupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)group, (Object)actualRequest.getGroup());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createGroupExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGroupService.addException((Exception)exception);
        try {
            FolderName name = FolderName.of((String)"[FOLDER]");
            Group group = Group.newBuilder().build();
            this.client.createGroup((ResourceName)name, group);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createGroupTest2() throws Exception {
        Group expectedResponse = Group.newBuilder().setName(GroupName.ofProjectGroupName((String)"[PROJECT]", (String)"[GROUP]").toString()).setDisplayName("displayName1714148973").setParentName("parentName-244870571").setFilter("filter-1274492040").setIsCluster(true).build();
        mockGroupService.addResponse((AbstractMessage)expectedResponse);
        OrganizationName name = OrganizationName.of((String)"[ORGANIZATION]");
        Group group = Group.newBuilder().build();
        Group actualResponse = this.client.createGroup(name, group);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGroupService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateGroupRequest actualRequest = (CreateGroupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)group, (Object)actualRequest.getGroup());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createGroupExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGroupService.addException((Exception)exception);
        try {
            OrganizationName name = OrganizationName.of((String)"[ORGANIZATION]");
            Group group = Group.newBuilder().build();
            this.client.createGroup(name, group);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createGroupTest3() throws Exception {
        Group expectedResponse = Group.newBuilder().setName(GroupName.ofProjectGroupName((String)"[PROJECT]", (String)"[GROUP]").toString()).setDisplayName("displayName1714148973").setParentName("parentName-244870571").setFilter("filter-1274492040").setIsCluster(true).build();
        mockGroupService.addResponse((AbstractMessage)expectedResponse);
        ProjectName name = ProjectName.of((String)"[PROJECT]");
        Group group = Group.newBuilder().build();
        Group actualResponse = this.client.createGroup(name, group);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGroupService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateGroupRequest actualRequest = (CreateGroupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)group, (Object)actualRequest.getGroup());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createGroupExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGroupService.addException((Exception)exception);
        try {
            ProjectName name = ProjectName.of((String)"[PROJECT]");
            Group group = Group.newBuilder().build();
            this.client.createGroup(name, group);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createGroupTest4() throws Exception {
        Group expectedResponse = Group.newBuilder().setName(GroupName.ofProjectGroupName((String)"[PROJECT]", (String)"[GROUP]").toString()).setDisplayName("displayName1714148973").setParentName("parentName-244870571").setFilter("filter-1274492040").setIsCluster(true).build();
        mockGroupService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Group group = Group.newBuilder().build();
        Group actualResponse = this.client.createGroup(name, group);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGroupService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateGroupRequest actualRequest = (CreateGroupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)group, (Object)actualRequest.getGroup());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createGroupExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGroupService.addException((Exception)exception);
        try {
            String name = "name3373707";
            Group group = Group.newBuilder().build();
            this.client.createGroup(name, group);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateGroupTest() throws Exception {
        Group expectedResponse = Group.newBuilder().setName(GroupName.ofProjectGroupName((String)"[PROJECT]", (String)"[GROUP]").toString()).setDisplayName("displayName1714148973").setParentName("parentName-244870571").setFilter("filter-1274492040").setIsCluster(true).build();
        mockGroupService.addResponse((AbstractMessage)expectedResponse);
        Group group = Group.newBuilder().build();
        Group actualResponse = this.client.updateGroup(group);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGroupService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateGroupRequest actualRequest = (UpdateGroupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)group, (Object)actualRequest.getGroup());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateGroupExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGroupService.addException((Exception)exception);
        try {
            Group group = Group.newBuilder().build();
            this.client.updateGroup(group);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteGroupTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockGroupService.addResponse((AbstractMessage)expectedResponse);
        GroupName name = GroupName.ofProjectGroupName((String)"[PROJECT]", (String)"[GROUP]");
        this.client.deleteGroup(name);
        List<AbstractMessage> actualRequests = mockGroupService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteGroupRequest actualRequest = (DeleteGroupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteGroupExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGroupService.addException((Exception)exception);
        try {
            GroupName name = GroupName.ofProjectGroupName((String)"[PROJECT]", (String)"[GROUP]");
            this.client.deleteGroup(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteGroupTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockGroupService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteGroup(name);
        List<AbstractMessage> actualRequests = mockGroupService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteGroupRequest actualRequest = (DeleteGroupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteGroupExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGroupService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteGroup(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listGroupMembersTest() throws Exception {
        MonitoredResource responsesElement = MonitoredResource.newBuilder().build();
        ListGroupMembersResponse expectedResponse = ListGroupMembersResponse.newBuilder().setNextPageToken("").addAllMembers(Arrays.asList(responsesElement)).build();
        mockGroupService.addResponse((AbstractMessage)expectedResponse);
        GroupName name = GroupName.ofProjectGroupName((String)"[PROJECT]", (String)"[GROUP]");
        GroupServiceClient.ListGroupMembersPagedResponse pagedListResponse = this.client.listGroupMembers(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMembersList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockGroupService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListGroupMembersRequest actualRequest = (ListGroupMembersRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listGroupMembersExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGroupService.addException((Exception)exception);
        try {
            GroupName name = GroupName.ofProjectGroupName((String)"[PROJECT]", (String)"[GROUP]");
            this.client.listGroupMembers(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listGroupMembersTest2() throws Exception {
        MonitoredResource responsesElement = MonitoredResource.newBuilder().build();
        ListGroupMembersResponse expectedResponse = ListGroupMembersResponse.newBuilder().setNextPageToken("").addAllMembers(Arrays.asList(responsesElement)).build();
        mockGroupService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        GroupServiceClient.ListGroupMembersPagedResponse pagedListResponse = this.client.listGroupMembers(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMembersList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockGroupService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListGroupMembersRequest actualRequest = (ListGroupMembersRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listGroupMembersExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGroupService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.listGroupMembers(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

