/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3;

import com.google.api.LaunchStage;
import com.google.api.MetricDescriptor;
import com.google.api.MonitoredResourceDescriptor;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.cloud.monitoring.v3.MetricServiceSettings;
import com.google.cloud.monitoring.v3.MockMetricService;
import com.google.common.collect.Lists;
import com.google.monitoring.v3.CreateMetricDescriptorRequest;
import com.google.monitoring.v3.CreateTimeSeriesRequest;
import com.google.monitoring.v3.DeleteMetricDescriptorRequest;
import com.google.monitoring.v3.FolderName;
import com.google.monitoring.v3.GetMetricDescriptorRequest;
import com.google.monitoring.v3.GetMonitoredResourceDescriptorRequest;
import com.google.monitoring.v3.ListMetricDescriptorsRequest;
import com.google.monitoring.v3.ListMetricDescriptorsResponse;
import com.google.monitoring.v3.ListMonitoredResourceDescriptorsRequest;
import com.google.monitoring.v3.ListMonitoredResourceDescriptorsResponse;
import com.google.monitoring.v3.ListTimeSeriesRequest;
import com.google.monitoring.v3.ListTimeSeriesResponse;
import com.google.monitoring.v3.MetricDescriptorName;
import com.google.monitoring.v3.MonitoredResourceDescriptorName;
import com.google.monitoring.v3.OrganizationName;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.TimeInterval;
import com.google.monitoring.v3.TimeSeries;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Empty;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class MetricServiceClientTest {
    private static MockMetricService mockMetricService;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private MetricServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockMetricService = new MockMetricService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockMetricService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        MetricServiceSettings settings = ((MetricServiceSettings.Builder)((MetricServiceSettings.Builder)MetricServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = MetricServiceClient.create((MetricServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listMonitoredResourceDescriptorsTest() throws Exception {
        MonitoredResourceDescriptor responsesElement = MonitoredResourceDescriptor.newBuilder().build();
        ListMonitoredResourceDescriptorsResponse expectedResponse = ListMonitoredResourceDescriptorsResponse.newBuilder().setNextPageToken("").addAllResourceDescriptors(Arrays.asList(responsesElement)).build();
        mockMetricService.addResponse((AbstractMessage)expectedResponse);
        FolderName name = FolderName.of((String)"[FOLDER]");
        MetricServiceClient.ListMonitoredResourceDescriptorsPagedResponse pagedListResponse = this.client.listMonitoredResourceDescriptors((ResourceName)name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getResourceDescriptorsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMetricService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListMonitoredResourceDescriptorsRequest actualRequest = (ListMonitoredResourceDescriptorsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listMonitoredResourceDescriptorsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetricService.addException((Exception)exception);
        try {
            FolderName name = FolderName.of((String)"[FOLDER]");
            this.client.listMonitoredResourceDescriptors((ResourceName)name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listMonitoredResourceDescriptorsTest2() throws Exception {
        MonitoredResourceDescriptor responsesElement = MonitoredResourceDescriptor.newBuilder().build();
        ListMonitoredResourceDescriptorsResponse expectedResponse = ListMonitoredResourceDescriptorsResponse.newBuilder().setNextPageToken("").addAllResourceDescriptors(Arrays.asList(responsesElement)).build();
        mockMetricService.addResponse((AbstractMessage)expectedResponse);
        OrganizationName name = OrganizationName.of((String)"[ORGANIZATION]");
        MetricServiceClient.ListMonitoredResourceDescriptorsPagedResponse pagedListResponse = this.client.listMonitoredResourceDescriptors(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getResourceDescriptorsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMetricService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListMonitoredResourceDescriptorsRequest actualRequest = (ListMonitoredResourceDescriptorsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listMonitoredResourceDescriptorsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetricService.addException((Exception)exception);
        try {
            OrganizationName name = OrganizationName.of((String)"[ORGANIZATION]");
            this.client.listMonitoredResourceDescriptors(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listMonitoredResourceDescriptorsTest3() throws Exception {
        MonitoredResourceDescriptor responsesElement = MonitoredResourceDescriptor.newBuilder().build();
        ListMonitoredResourceDescriptorsResponse expectedResponse = ListMonitoredResourceDescriptorsResponse.newBuilder().setNextPageToken("").addAllResourceDescriptors(Arrays.asList(responsesElement)).build();
        mockMetricService.addResponse((AbstractMessage)expectedResponse);
        ProjectName name = ProjectName.of((String)"[PROJECT]");
        MetricServiceClient.ListMonitoredResourceDescriptorsPagedResponse pagedListResponse = this.client.listMonitoredResourceDescriptors(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getResourceDescriptorsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMetricService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListMonitoredResourceDescriptorsRequest actualRequest = (ListMonitoredResourceDescriptorsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listMonitoredResourceDescriptorsExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetricService.addException((Exception)exception);
        try {
            ProjectName name = ProjectName.of((String)"[PROJECT]");
            this.client.listMonitoredResourceDescriptors(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listMonitoredResourceDescriptorsTest4() throws Exception {
        MonitoredResourceDescriptor responsesElement = MonitoredResourceDescriptor.newBuilder().build();
        ListMonitoredResourceDescriptorsResponse expectedResponse = ListMonitoredResourceDescriptorsResponse.newBuilder().setNextPageToken("").addAllResourceDescriptors(Arrays.asList(responsesElement)).build();
        mockMetricService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        MetricServiceClient.ListMonitoredResourceDescriptorsPagedResponse pagedListResponse = this.client.listMonitoredResourceDescriptors(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getResourceDescriptorsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMetricService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListMonitoredResourceDescriptorsRequest actualRequest = (ListMonitoredResourceDescriptorsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listMonitoredResourceDescriptorsExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetricService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.listMonitoredResourceDescriptors(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getMonitoredResourceDescriptorTest() throws Exception {
        MonitoredResourceDescriptor expectedResponse = MonitoredResourceDescriptor.newBuilder().setName("name3373707").setType("type3575610").setDisplayName("displayName1714148973").setDescription("description-1724546052").addAllLabels(new ArrayList()).setLaunchStage(LaunchStage.forNumber((int)0)).build();
        mockMetricService.addResponse((AbstractMessage)expectedResponse);
        MonitoredResourceDescriptorName name = MonitoredResourceDescriptorName.ofProjectMonitoredResourceDescriptorName((String)"[PROJECT]", (String)"[MONITORED_RESOURCE_DESCRIPTOR]");
        MonitoredResourceDescriptor actualResponse = this.client.getMonitoredResourceDescriptor(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetricService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetMonitoredResourceDescriptorRequest actualRequest = (GetMonitoredResourceDescriptorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getMonitoredResourceDescriptorExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetricService.addException((Exception)exception);
        try {
            MonitoredResourceDescriptorName name = MonitoredResourceDescriptorName.ofProjectMonitoredResourceDescriptorName((String)"[PROJECT]", (String)"[MONITORED_RESOURCE_DESCRIPTOR]");
            this.client.getMonitoredResourceDescriptor(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getMonitoredResourceDescriptorTest2() throws Exception {
        MonitoredResourceDescriptor expectedResponse = MonitoredResourceDescriptor.newBuilder().setName("name3373707").setType("type3575610").setDisplayName("displayName1714148973").setDescription("description-1724546052").addAllLabels(new ArrayList()).setLaunchStage(LaunchStage.forNumber((int)0)).build();
        mockMetricService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        MonitoredResourceDescriptor actualResponse = this.client.getMonitoredResourceDescriptor(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetricService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetMonitoredResourceDescriptorRequest actualRequest = (GetMonitoredResourceDescriptorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getMonitoredResourceDescriptorExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetricService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getMonitoredResourceDescriptor(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listMetricDescriptorsTest() throws Exception {
        MetricDescriptor responsesElement = MetricDescriptor.newBuilder().build();
        ListMetricDescriptorsResponse expectedResponse = ListMetricDescriptorsResponse.newBuilder().setNextPageToken("").addAllMetricDescriptors(Arrays.asList(responsesElement)).build();
        mockMetricService.addResponse((AbstractMessage)expectedResponse);
        FolderName name = FolderName.of((String)"[FOLDER]");
        MetricServiceClient.ListMetricDescriptorsPagedResponse pagedListResponse = this.client.listMetricDescriptors((ResourceName)name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMetricDescriptorsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMetricService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListMetricDescriptorsRequest actualRequest = (ListMetricDescriptorsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listMetricDescriptorsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetricService.addException((Exception)exception);
        try {
            FolderName name = FolderName.of((String)"[FOLDER]");
            this.client.listMetricDescriptors((ResourceName)name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listMetricDescriptorsTest2() throws Exception {
        MetricDescriptor responsesElement = MetricDescriptor.newBuilder().build();
        ListMetricDescriptorsResponse expectedResponse = ListMetricDescriptorsResponse.newBuilder().setNextPageToken("").addAllMetricDescriptors(Arrays.asList(responsesElement)).build();
        mockMetricService.addResponse((AbstractMessage)expectedResponse);
        OrganizationName name = OrganizationName.of((String)"[ORGANIZATION]");
        MetricServiceClient.ListMetricDescriptorsPagedResponse pagedListResponse = this.client.listMetricDescriptors(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMetricDescriptorsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMetricService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListMetricDescriptorsRequest actualRequest = (ListMetricDescriptorsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listMetricDescriptorsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetricService.addException((Exception)exception);
        try {
            OrganizationName name = OrganizationName.of((String)"[ORGANIZATION]");
            this.client.listMetricDescriptors(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listMetricDescriptorsTest3() throws Exception {
        MetricDescriptor responsesElement = MetricDescriptor.newBuilder().build();
        ListMetricDescriptorsResponse expectedResponse = ListMetricDescriptorsResponse.newBuilder().setNextPageToken("").addAllMetricDescriptors(Arrays.asList(responsesElement)).build();
        mockMetricService.addResponse((AbstractMessage)expectedResponse);
        ProjectName name = ProjectName.of((String)"[PROJECT]");
        MetricServiceClient.ListMetricDescriptorsPagedResponse pagedListResponse = this.client.listMetricDescriptors(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMetricDescriptorsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMetricService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListMetricDescriptorsRequest actualRequest = (ListMetricDescriptorsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listMetricDescriptorsExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetricService.addException((Exception)exception);
        try {
            ProjectName name = ProjectName.of((String)"[PROJECT]");
            this.client.listMetricDescriptors(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listMetricDescriptorsTest4() throws Exception {
        MetricDescriptor responsesElement = MetricDescriptor.newBuilder().build();
        ListMetricDescriptorsResponse expectedResponse = ListMetricDescriptorsResponse.newBuilder().setNextPageToken("").addAllMetricDescriptors(Arrays.asList(responsesElement)).build();
        mockMetricService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        MetricServiceClient.ListMetricDescriptorsPagedResponse pagedListResponse = this.client.listMetricDescriptors(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMetricDescriptorsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMetricService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListMetricDescriptorsRequest actualRequest = (ListMetricDescriptorsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listMetricDescriptorsExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetricService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.listMetricDescriptors(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getMetricDescriptorTest() throws Exception {
        MetricDescriptor expectedResponse = MetricDescriptor.newBuilder().setName("name3373707").setType("type3575610").addAllLabels(new ArrayList()).setUnit("unit3594628").setDescription("description-1724546052").setDisplayName("displayName1714148973").setMetadata(MetricDescriptor.MetricDescriptorMetadata.newBuilder().build()).setLaunchStage(LaunchStage.forNumber((int)0)).addAllMonitoredResourceTypes(new ArrayList()).build();
        mockMetricService.addResponse((AbstractMessage)expectedResponse);
        MetricDescriptorName name = MetricDescriptorName.ofProjectMetricDescriptorName((String)"[PROJECT]", (String)"[METRIC_DESCRIPTOR]");
        MetricDescriptor actualResponse = this.client.getMetricDescriptor(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetricService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetMetricDescriptorRequest actualRequest = (GetMetricDescriptorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getMetricDescriptorExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetricService.addException((Exception)exception);
        try {
            MetricDescriptorName name = MetricDescriptorName.ofProjectMetricDescriptorName((String)"[PROJECT]", (String)"[METRIC_DESCRIPTOR]");
            this.client.getMetricDescriptor(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getMetricDescriptorTest2() throws Exception {
        MetricDescriptor expectedResponse = MetricDescriptor.newBuilder().setName("name3373707").setType("type3575610").addAllLabels(new ArrayList()).setUnit("unit3594628").setDescription("description-1724546052").setDisplayName("displayName1714148973").setMetadata(MetricDescriptor.MetricDescriptorMetadata.newBuilder().build()).setLaunchStage(LaunchStage.forNumber((int)0)).addAllMonitoredResourceTypes(new ArrayList()).build();
        mockMetricService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        MetricDescriptor actualResponse = this.client.getMetricDescriptor(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetricService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetMetricDescriptorRequest actualRequest = (GetMetricDescriptorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getMetricDescriptorExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetricService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getMetricDescriptor(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createMetricDescriptorTest() throws Exception {
        MetricDescriptor expectedResponse = MetricDescriptor.newBuilder().setName("name3373707").setType("type3575610").addAllLabels(new ArrayList()).setUnit("unit3594628").setDescription("description-1724546052").setDisplayName("displayName1714148973").setMetadata(MetricDescriptor.MetricDescriptorMetadata.newBuilder().build()).setLaunchStage(LaunchStage.forNumber((int)0)).addAllMonitoredResourceTypes(new ArrayList()).build();
        mockMetricService.addResponse((AbstractMessage)expectedResponse);
        FolderName name = FolderName.of((String)"[FOLDER]");
        MetricDescriptor metricDescriptor = MetricDescriptor.newBuilder().build();
        MetricDescriptor actualResponse = this.client.createMetricDescriptor((ResourceName)name, metricDescriptor);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetricService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateMetricDescriptorRequest actualRequest = (CreateMetricDescriptorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)metricDescriptor, (Object)actualRequest.getMetricDescriptor());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createMetricDescriptorExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetricService.addException((Exception)exception);
        try {
            FolderName name = FolderName.of((String)"[FOLDER]");
            MetricDescriptor metricDescriptor = MetricDescriptor.newBuilder().build();
            this.client.createMetricDescriptor((ResourceName)name, metricDescriptor);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createMetricDescriptorTest2() throws Exception {
        MetricDescriptor expectedResponse = MetricDescriptor.newBuilder().setName("name3373707").setType("type3575610").addAllLabels(new ArrayList()).setUnit("unit3594628").setDescription("description-1724546052").setDisplayName("displayName1714148973").setMetadata(MetricDescriptor.MetricDescriptorMetadata.newBuilder().build()).setLaunchStage(LaunchStage.forNumber((int)0)).addAllMonitoredResourceTypes(new ArrayList()).build();
        mockMetricService.addResponse((AbstractMessage)expectedResponse);
        OrganizationName name = OrganizationName.of((String)"[ORGANIZATION]");
        MetricDescriptor metricDescriptor = MetricDescriptor.newBuilder().build();
        MetricDescriptor actualResponse = this.client.createMetricDescriptor(name, metricDescriptor);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetricService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateMetricDescriptorRequest actualRequest = (CreateMetricDescriptorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)metricDescriptor, (Object)actualRequest.getMetricDescriptor());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createMetricDescriptorExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetricService.addException((Exception)exception);
        try {
            OrganizationName name = OrganizationName.of((String)"[ORGANIZATION]");
            MetricDescriptor metricDescriptor = MetricDescriptor.newBuilder().build();
            this.client.createMetricDescriptor(name, metricDescriptor);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createMetricDescriptorTest3() throws Exception {
        MetricDescriptor expectedResponse = MetricDescriptor.newBuilder().setName("name3373707").setType("type3575610").addAllLabels(new ArrayList()).setUnit("unit3594628").setDescription("description-1724546052").setDisplayName("displayName1714148973").setMetadata(MetricDescriptor.MetricDescriptorMetadata.newBuilder().build()).setLaunchStage(LaunchStage.forNumber((int)0)).addAllMonitoredResourceTypes(new ArrayList()).build();
        mockMetricService.addResponse((AbstractMessage)expectedResponse);
        ProjectName name = ProjectName.of((String)"[PROJECT]");
        MetricDescriptor metricDescriptor = MetricDescriptor.newBuilder().build();
        MetricDescriptor actualResponse = this.client.createMetricDescriptor(name, metricDescriptor);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetricService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateMetricDescriptorRequest actualRequest = (CreateMetricDescriptorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)metricDescriptor, (Object)actualRequest.getMetricDescriptor());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createMetricDescriptorExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetricService.addException((Exception)exception);
        try {
            ProjectName name = ProjectName.of((String)"[PROJECT]");
            MetricDescriptor metricDescriptor = MetricDescriptor.newBuilder().build();
            this.client.createMetricDescriptor(name, metricDescriptor);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createMetricDescriptorTest4() throws Exception {
        MetricDescriptor expectedResponse = MetricDescriptor.newBuilder().setName("name3373707").setType("type3575610").addAllLabels(new ArrayList()).setUnit("unit3594628").setDescription("description-1724546052").setDisplayName("displayName1714148973").setMetadata(MetricDescriptor.MetricDescriptorMetadata.newBuilder().build()).setLaunchStage(LaunchStage.forNumber((int)0)).addAllMonitoredResourceTypes(new ArrayList()).build();
        mockMetricService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        MetricDescriptor metricDescriptor = MetricDescriptor.newBuilder().build();
        MetricDescriptor actualResponse = this.client.createMetricDescriptor(name, metricDescriptor);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetricService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateMetricDescriptorRequest actualRequest = (CreateMetricDescriptorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)metricDescriptor, (Object)actualRequest.getMetricDescriptor());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createMetricDescriptorExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetricService.addException((Exception)exception);
        try {
            String name = "name3373707";
            MetricDescriptor metricDescriptor = MetricDescriptor.newBuilder().build();
            this.client.createMetricDescriptor(name, metricDescriptor);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteMetricDescriptorTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockMetricService.addResponse((AbstractMessage)expectedResponse);
        MetricDescriptorName name = MetricDescriptorName.ofProjectMetricDescriptorName((String)"[PROJECT]", (String)"[METRIC_DESCRIPTOR]");
        this.client.deleteMetricDescriptor(name);
        List<AbstractMessage> actualRequests = mockMetricService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteMetricDescriptorRequest actualRequest = (DeleteMetricDescriptorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteMetricDescriptorExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetricService.addException((Exception)exception);
        try {
            MetricDescriptorName name = MetricDescriptorName.ofProjectMetricDescriptorName((String)"[PROJECT]", (String)"[METRIC_DESCRIPTOR]");
            this.client.deleteMetricDescriptor(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteMetricDescriptorTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockMetricService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteMetricDescriptor(name);
        List<AbstractMessage> actualRequests = mockMetricService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteMetricDescriptorRequest actualRequest = (DeleteMetricDescriptorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteMetricDescriptorExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetricService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteMetricDescriptor(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTimeSeriesTest() throws Exception {
        TimeSeries responsesElement = TimeSeries.newBuilder().build();
        ListTimeSeriesResponse expectedResponse = ListTimeSeriesResponse.newBuilder().setNextPageToken("").addAllTimeSeries(Arrays.asList(responsesElement)).build();
        mockMetricService.addResponse((AbstractMessage)expectedResponse);
        FolderName name = FolderName.of((String)"[FOLDER]");
        String filter = "filter-1274492040";
        TimeInterval interval = TimeInterval.newBuilder().build();
        ListTimeSeriesRequest.TimeSeriesView view = ListTimeSeriesRequest.TimeSeriesView.forNumber((int)0);
        MetricServiceClient.ListTimeSeriesPagedResponse pagedListResponse = this.client.listTimeSeries((ResourceName)name, filter, interval, view);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getTimeSeriesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMetricService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListTimeSeriesRequest actualRequest = (ListTimeSeriesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)filter, (Object)actualRequest.getFilter());
        Assert.assertEquals((Object)interval, (Object)actualRequest.getInterval());
        Assert.assertEquals((Object)view, (Object)actualRequest.getView());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listTimeSeriesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetricService.addException((Exception)exception);
        try {
            FolderName name = FolderName.of((String)"[FOLDER]");
            String filter = "filter-1274492040";
            TimeInterval interval = TimeInterval.newBuilder().build();
            ListTimeSeriesRequest.TimeSeriesView view = ListTimeSeriesRequest.TimeSeriesView.forNumber((int)0);
            this.client.listTimeSeries((ResourceName)name, filter, interval, view);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTimeSeriesTest2() throws Exception {
        TimeSeries responsesElement = TimeSeries.newBuilder().build();
        ListTimeSeriesResponse expectedResponse = ListTimeSeriesResponse.newBuilder().setNextPageToken("").addAllTimeSeries(Arrays.asList(responsesElement)).build();
        mockMetricService.addResponse((AbstractMessage)expectedResponse);
        OrganizationName name = OrganizationName.of((String)"[ORGANIZATION]");
        String filter = "filter-1274492040";
        TimeInterval interval = TimeInterval.newBuilder().build();
        ListTimeSeriesRequest.TimeSeriesView view = ListTimeSeriesRequest.TimeSeriesView.forNumber((int)0);
        MetricServiceClient.ListTimeSeriesPagedResponse pagedListResponse = this.client.listTimeSeries(name, filter, interval, view);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getTimeSeriesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMetricService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListTimeSeriesRequest actualRequest = (ListTimeSeriesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)filter, (Object)actualRequest.getFilter());
        Assert.assertEquals((Object)interval, (Object)actualRequest.getInterval());
        Assert.assertEquals((Object)view, (Object)actualRequest.getView());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listTimeSeriesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetricService.addException((Exception)exception);
        try {
            OrganizationName name = OrganizationName.of((String)"[ORGANIZATION]");
            String filter = "filter-1274492040";
            TimeInterval interval = TimeInterval.newBuilder().build();
            ListTimeSeriesRequest.TimeSeriesView view = ListTimeSeriesRequest.TimeSeriesView.forNumber((int)0);
            this.client.listTimeSeries(name, filter, interval, view);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTimeSeriesTest3() throws Exception {
        TimeSeries responsesElement = TimeSeries.newBuilder().build();
        ListTimeSeriesResponse expectedResponse = ListTimeSeriesResponse.newBuilder().setNextPageToken("").addAllTimeSeries(Arrays.asList(responsesElement)).build();
        mockMetricService.addResponse((AbstractMessage)expectedResponse);
        ProjectName name = ProjectName.of((String)"[PROJECT]");
        String filter = "filter-1274492040";
        TimeInterval interval = TimeInterval.newBuilder().build();
        ListTimeSeriesRequest.TimeSeriesView view = ListTimeSeriesRequest.TimeSeriesView.forNumber((int)0);
        MetricServiceClient.ListTimeSeriesPagedResponse pagedListResponse = this.client.listTimeSeries(name, filter, interval, view);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getTimeSeriesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMetricService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListTimeSeriesRequest actualRequest = (ListTimeSeriesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)filter, (Object)actualRequest.getFilter());
        Assert.assertEquals((Object)interval, (Object)actualRequest.getInterval());
        Assert.assertEquals((Object)view, (Object)actualRequest.getView());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listTimeSeriesExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetricService.addException((Exception)exception);
        try {
            ProjectName name = ProjectName.of((String)"[PROJECT]");
            String filter = "filter-1274492040";
            TimeInterval interval = TimeInterval.newBuilder().build();
            ListTimeSeriesRequest.TimeSeriesView view = ListTimeSeriesRequest.TimeSeriesView.forNumber((int)0);
            this.client.listTimeSeries(name, filter, interval, view);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTimeSeriesTest4() throws Exception {
        TimeSeries responsesElement = TimeSeries.newBuilder().build();
        ListTimeSeriesResponse expectedResponse = ListTimeSeriesResponse.newBuilder().setNextPageToken("").addAllTimeSeries(Arrays.asList(responsesElement)).build();
        mockMetricService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        String filter = "filter-1274492040";
        TimeInterval interval = TimeInterval.newBuilder().build();
        ListTimeSeriesRequest.TimeSeriesView view = ListTimeSeriesRequest.TimeSeriesView.forNumber((int)0);
        MetricServiceClient.ListTimeSeriesPagedResponse pagedListResponse = this.client.listTimeSeries(name, filter, interval, view);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getTimeSeriesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMetricService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListTimeSeriesRequest actualRequest = (ListTimeSeriesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)filter, (Object)actualRequest.getFilter());
        Assert.assertEquals((Object)interval, (Object)actualRequest.getInterval());
        Assert.assertEquals((Object)view, (Object)actualRequest.getView());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listTimeSeriesExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetricService.addException((Exception)exception);
        try {
            String name = "name3373707";
            String filter = "filter-1274492040";
            TimeInterval interval = TimeInterval.newBuilder().build();
            ListTimeSeriesRequest.TimeSeriesView view = ListTimeSeriesRequest.TimeSeriesView.forNumber((int)0);
            this.client.listTimeSeries(name, filter, interval, view);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createTimeSeriesTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockMetricService.addResponse((AbstractMessage)expectedResponse);
        ProjectName name = ProjectName.of((String)"[PROJECT]");
        ArrayList timeSeries = new ArrayList();
        this.client.createTimeSeries(name, timeSeries);
        List<AbstractMessage> actualRequests = mockMetricService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateTimeSeriesRequest actualRequest = (CreateTimeSeriesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals(timeSeries, (Object)actualRequest.getTimeSeriesList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createTimeSeriesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetricService.addException((Exception)exception);
        try {
            ProjectName name = ProjectName.of((String)"[PROJECT]");
            ArrayList timeSeries = new ArrayList();
            this.client.createTimeSeries(name, timeSeries);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createTimeSeriesTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockMetricService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        ArrayList timeSeries = new ArrayList();
        this.client.createTimeSeries(name, timeSeries);
        List<AbstractMessage> actualRequests = mockMetricService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateTimeSeriesRequest actualRequest = (CreateTimeSeriesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals(timeSeries, (Object)actualRequest.getTimeSeriesList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createTimeSeriesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetricService.addException((Exception)exception);
        try {
            String name = "name3373707";
            ArrayList timeSeries = new ArrayList();
            this.client.createTimeSeries(name, timeSeries);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createServiceTimeSeriesTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockMetricService.addResponse((AbstractMessage)expectedResponse);
        ProjectName name = ProjectName.of((String)"[PROJECT]");
        ArrayList timeSeries = new ArrayList();
        this.client.createServiceTimeSeries(name, timeSeries);
        List<AbstractMessage> actualRequests = mockMetricService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateTimeSeriesRequest actualRequest = (CreateTimeSeriesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals(timeSeries, (Object)actualRequest.getTimeSeriesList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createServiceTimeSeriesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetricService.addException((Exception)exception);
        try {
            ProjectName name = ProjectName.of((String)"[PROJECT]");
            ArrayList timeSeries = new ArrayList();
            this.client.createServiceTimeSeries(name, timeSeries);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createServiceTimeSeriesTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockMetricService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        ArrayList timeSeries = new ArrayList();
        this.client.createServiceTimeSeries(name, timeSeries);
        List<AbstractMessage> actualRequests = mockMetricService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateTimeSeriesRequest actualRequest = (CreateTimeSeriesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals(timeSeries, (Object)actualRequest.getTimeSeriesList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createServiceTimeSeriesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetricService.addException((Exception)exception);
        try {
            String name = "name3373707";
            ArrayList timeSeries = new ArrayList();
            this.client.createServiceTimeSeries(name, timeSeries);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

