/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.monitoring.v3.MockQueryService;
import com.google.cloud.monitoring.v3.QueryServiceClient;
import com.google.cloud.monitoring.v3.QueryServiceSettings;
import com.google.common.collect.Lists;
import com.google.monitoring.v3.QueryTimeSeriesRequest;
import com.google.monitoring.v3.QueryTimeSeriesResponse;
import com.google.monitoring.v3.TimeSeriesData;
import com.google.protobuf.AbstractMessage;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class QueryServiceClientTest {
    private static MockQueryService mockQueryService;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private QueryServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockQueryService = new MockQueryService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockQueryService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        QueryServiceSettings settings = ((QueryServiceSettings.Builder)((QueryServiceSettings.Builder)QueryServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = QueryServiceClient.create((QueryServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void queryTimeSeriesTest() throws Exception {
        TimeSeriesData responsesElement = TimeSeriesData.newBuilder().build();
        QueryTimeSeriesResponse expectedResponse = QueryTimeSeriesResponse.newBuilder().setNextPageToken("").addAllTimeSeriesData(Arrays.asList(responsesElement)).build();
        mockQueryService.addResponse((AbstractMessage)expectedResponse);
        QueryTimeSeriesRequest request = QueryTimeSeriesRequest.newBuilder().setName("name3373707").setQuery("query107944136").setPageSize(883849137).setPageToken("pageToken873572522").build();
        QueryServiceClient.QueryTimeSeriesPagedResponse pagedListResponse = this.client.queryTimeSeries(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getTimeSeriesDataList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockQueryService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        QueryTimeSeriesRequest actualRequest = (QueryTimeSeriesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getQuery(), (Object)actualRequest.getQuery());
        Assert.assertEquals((long)request.getPageSize(), (long)actualRequest.getPageSize());
        Assert.assertEquals((Object)request.getPageToken(), (Object)actualRequest.getPageToken());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void queryTimeSeriesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockQueryService.addException((Exception)exception);
        try {
            QueryTimeSeriesRequest request = QueryTimeSeriesRequest.newBuilder().setName("name3373707").setQuery("query107944136").setPageSize(883849137).setPageToken("pageToken873572522").build();
            this.client.queryTimeSeries(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

