/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.monitoring.v3.MockSnoozeService;
import com.google.cloud.monitoring.v3.SnoozeServiceClient;
import com.google.cloud.monitoring.v3.SnoozeServiceSettings;
import com.google.common.collect.Lists;
import com.google.monitoring.v3.CreateSnoozeRequest;
import com.google.monitoring.v3.GetSnoozeRequest;
import com.google.monitoring.v3.ListSnoozesRequest;
import com.google.monitoring.v3.ListSnoozesResponse;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.Snooze;
import com.google.monitoring.v3.SnoozeName;
import com.google.monitoring.v3.TimeInterval;
import com.google.monitoring.v3.UpdateSnoozeRequest;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.FieldMask;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SnoozeServiceClientTest {
    private static MockServiceHelper mockServiceHelper;
    private static MockSnoozeService mockSnoozeService;
    private LocalChannelProvider channelProvider;
    private SnoozeServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockSnoozeService = new MockSnoozeService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockSnoozeService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        SnoozeServiceSettings settings = ((SnoozeServiceSettings.Builder)((SnoozeServiceSettings.Builder)SnoozeServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = SnoozeServiceClient.create((SnoozeServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createSnoozeTest() throws Exception {
        Snooze expectedResponse = Snooze.newBuilder().setName(SnoozeName.of((String)"[PROJECT]", (String)"[SNOOZE]").toString()).setCriteria(Snooze.Criteria.newBuilder().build()).setInterval(TimeInterval.newBuilder().build()).setDisplayName("displayName1714148973").build();
        mockSnoozeService.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        Snooze snooze = Snooze.newBuilder().build();
        Snooze actualResponse = this.client.createSnooze(parent, snooze);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSnoozeService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSnoozeRequest actualRequest = (CreateSnoozeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)snooze, (Object)actualRequest.getSnooze());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSnoozeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSnoozeService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            Snooze snooze = Snooze.newBuilder().build();
            this.client.createSnooze(parent, snooze);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSnoozeTest2() throws Exception {
        Snooze expectedResponse = Snooze.newBuilder().setName(SnoozeName.of((String)"[PROJECT]", (String)"[SNOOZE]").toString()).setCriteria(Snooze.Criteria.newBuilder().build()).setInterval(TimeInterval.newBuilder().build()).setDisplayName("displayName1714148973").build();
        mockSnoozeService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Snooze snooze = Snooze.newBuilder().build();
        Snooze actualResponse = this.client.createSnooze(parent, snooze);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSnoozeService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSnoozeRequest actualRequest = (CreateSnoozeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)snooze, (Object)actualRequest.getSnooze());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSnoozeExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSnoozeService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Snooze snooze = Snooze.newBuilder().build();
            this.client.createSnooze(parent, snooze);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSnoozesTest() throws Exception {
        Snooze responsesElement = Snooze.newBuilder().build();
        ListSnoozesResponse expectedResponse = ListSnoozesResponse.newBuilder().setNextPageToken("").addAllSnoozes(Arrays.asList(responsesElement)).build();
        mockSnoozeService.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        SnoozeServiceClient.ListSnoozesPagedResponse pagedListResponse = this.client.listSnoozes(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSnoozesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSnoozeService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSnoozesRequest actualRequest = (ListSnoozesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSnoozesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSnoozeService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            this.client.listSnoozes(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSnoozesTest2() throws Exception {
        Snooze responsesElement = Snooze.newBuilder().build();
        ListSnoozesResponse expectedResponse = ListSnoozesResponse.newBuilder().setNextPageToken("").addAllSnoozes(Arrays.asList(responsesElement)).build();
        mockSnoozeService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        SnoozeServiceClient.ListSnoozesPagedResponse pagedListResponse = this.client.listSnoozes(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSnoozesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSnoozeService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSnoozesRequest actualRequest = (ListSnoozesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSnoozesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSnoozeService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listSnoozes(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSnoozeTest() throws Exception {
        Snooze expectedResponse = Snooze.newBuilder().setName(SnoozeName.of((String)"[PROJECT]", (String)"[SNOOZE]").toString()).setCriteria(Snooze.Criteria.newBuilder().build()).setInterval(TimeInterval.newBuilder().build()).setDisplayName("displayName1714148973").build();
        mockSnoozeService.addResponse((AbstractMessage)expectedResponse);
        SnoozeName name = SnoozeName.of((String)"[PROJECT]", (String)"[SNOOZE]");
        Snooze actualResponse = this.client.getSnooze(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSnoozeService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSnoozeRequest actualRequest = (GetSnoozeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSnoozeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSnoozeService.addException((Exception)exception);
        try {
            SnoozeName name = SnoozeName.of((String)"[PROJECT]", (String)"[SNOOZE]");
            this.client.getSnooze(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSnoozeTest2() throws Exception {
        Snooze expectedResponse = Snooze.newBuilder().setName(SnoozeName.of((String)"[PROJECT]", (String)"[SNOOZE]").toString()).setCriteria(Snooze.Criteria.newBuilder().build()).setInterval(TimeInterval.newBuilder().build()).setDisplayName("displayName1714148973").build();
        mockSnoozeService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Snooze actualResponse = this.client.getSnooze(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSnoozeService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSnoozeRequest actualRequest = (GetSnoozeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSnoozeExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSnoozeService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getSnooze(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateSnoozeTest() throws Exception {
        Snooze expectedResponse = Snooze.newBuilder().setName(SnoozeName.of((String)"[PROJECT]", (String)"[SNOOZE]").toString()).setCriteria(Snooze.Criteria.newBuilder().build()).setInterval(TimeInterval.newBuilder().build()).setDisplayName("displayName1714148973").build();
        mockSnoozeService.addResponse((AbstractMessage)expectedResponse);
        Snooze snooze = Snooze.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Snooze actualResponse = this.client.updateSnooze(snooze, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSnoozeService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateSnoozeRequest actualRequest = (UpdateSnoozeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)snooze, (Object)actualRequest.getSnooze());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateSnoozeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSnoozeService.addException((Exception)exception);
        try {
            Snooze snooze = Snooze.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateSnooze(snooze, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

