package com.google.cloud.storage.contrib.nio;

import com.google.common.collect.ImmutableList;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_CloudStorageConfiguration extends CloudStorageConfiguration {

  private final String workingDirectory;

  private final boolean permitEmptyPathComponents;

  private final boolean stripPrefixSlash;

  private final boolean usePseudoDirectories;

  private final int blockSize;

  private final int maxChannelReopens;

  private final String userProject;

  private final boolean useUserProjectOnlyForRequesterPaysBuckets;

  private final ImmutableList<Integer> retryableHttpCodes;

  private final ImmutableList<Class<? extends Exception>> reopenableExceptions;

  AutoValue_CloudStorageConfiguration(
      String workingDirectory,
      boolean permitEmptyPathComponents,
      boolean stripPrefixSlash,
      boolean usePseudoDirectories,
      int blockSize,
      int maxChannelReopens,
      @Nullable String userProject,
      boolean useUserProjectOnlyForRequesterPaysBuckets,
      ImmutableList<Integer> retryableHttpCodes,
      ImmutableList<Class<? extends Exception>> reopenableExceptions) {
    if (workingDirectory == null) {
      throw new NullPointerException("Null workingDirectory");
    }
    this.workingDirectory = workingDirectory;
    this.permitEmptyPathComponents = permitEmptyPathComponents;
    this.stripPrefixSlash = stripPrefixSlash;
    this.usePseudoDirectories = usePseudoDirectories;
    this.blockSize = blockSize;
    this.maxChannelReopens = maxChannelReopens;
    this.userProject = userProject;
    this.useUserProjectOnlyForRequesterPaysBuckets = useUserProjectOnlyForRequesterPaysBuckets;
    if (retryableHttpCodes == null) {
      throw new NullPointerException("Null retryableHttpCodes");
    }
    this.retryableHttpCodes = retryableHttpCodes;
    if (reopenableExceptions == null) {
      throw new NullPointerException("Null reopenableExceptions");
    }
    this.reopenableExceptions = reopenableExceptions;
  }

  @Override
  public String workingDirectory() {
    return workingDirectory;
  }

  @Override
  public boolean permitEmptyPathComponents() {
    return permitEmptyPathComponents;
  }

  @Override
  public boolean stripPrefixSlash() {
    return stripPrefixSlash;
  }

  @Override
  public boolean usePseudoDirectories() {
    return usePseudoDirectories;
  }

  @Override
  public int blockSize() {
    return blockSize;
  }

  @Override
  public int maxChannelReopens() {
    return maxChannelReopens;
  }

  @Nullable
  @Override
  public String userProject() {
    return userProject;
  }

  @Override
  public boolean useUserProjectOnlyForRequesterPaysBuckets() {
    return useUserProjectOnlyForRequesterPaysBuckets;
  }

  @Override
  public ImmutableList<Integer> retryableHttpCodes() {
    return retryableHttpCodes;
  }

  @Override
  public ImmutableList<Class<? extends Exception>> reopenableExceptions() {
    return reopenableExceptions;
  }

  @Override
  public String toString() {
    return "CloudStorageConfiguration{"
         + "workingDirectory=" + workingDirectory + ", "
         + "permitEmptyPathComponents=" + permitEmptyPathComponents + ", "
         + "stripPrefixSlash=" + stripPrefixSlash + ", "
         + "usePseudoDirectories=" + usePseudoDirectories + ", "
         + "blockSize=" + blockSize + ", "
         + "maxChannelReopens=" + maxChannelReopens + ", "
         + "userProject=" + userProject + ", "
         + "useUserProjectOnlyForRequesterPaysBuckets=" + useUserProjectOnlyForRequesterPaysBuckets + ", "
         + "retryableHttpCodes=" + retryableHttpCodes + ", "
         + "reopenableExceptions=" + reopenableExceptions
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CloudStorageConfiguration) {
      CloudStorageConfiguration that = (CloudStorageConfiguration) o;
      return this.workingDirectory.equals(that.workingDirectory())
          && this.permitEmptyPathComponents == that.permitEmptyPathComponents()
          && this.stripPrefixSlash == that.stripPrefixSlash()
          && this.usePseudoDirectories == that.usePseudoDirectories()
          && this.blockSize == that.blockSize()
          && this.maxChannelReopens == that.maxChannelReopens()
          && (this.userProject == null ? that.userProject() == null : this.userProject.equals(that.userProject()))
          && this.useUserProjectOnlyForRequesterPaysBuckets == that.useUserProjectOnlyForRequesterPaysBuckets()
          && this.retryableHttpCodes.equals(that.retryableHttpCodes())
          && this.reopenableExceptions.equals(that.reopenableExceptions());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= workingDirectory.hashCode();
    h$ *= 1000003;
    h$ ^= permitEmptyPathComponents ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= stripPrefixSlash ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= usePseudoDirectories ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= blockSize;
    h$ *= 1000003;
    h$ ^= maxChannelReopens;
    h$ *= 1000003;
    h$ ^= (userProject == null) ? 0 : userProject.hashCode();
    h$ *= 1000003;
    h$ ^= useUserProjectOnlyForRequesterPaysBuckets ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= retryableHttpCodes.hashCode();
    h$ *= 1000003;
    h$ ^= reopenableExceptions.hashCode();
    return h$;
  }

}
