/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio.testing;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.client.util.DateTime;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.ServiceAccount;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.Tuple;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.spi.v1.StorageRpc;
import com.google.cloud.storage.testing.StorageRpcTestBase;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class FakeStorageRpc
extends StorageRpcTestBase {
    private static final SimpleDateFormat RFC_3339_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
    private static final int OK = 200;
    private static final int PARTIAL_CONTENT = 206;
    private static final int NOT_FOUND = 404;
    private static final byte[] EMPTY_BYTES = new byte[0];
    Map<String, StorageObject> metadata = new ConcurrentHashMap<String, StorageObject>();
    Map<String, byte[]> contents = new ConcurrentHashMap<String, byte[]>();
    Map<String, byte[]> futureContents = new ConcurrentHashMap<String, byte[]>();
    private final boolean throwIfOption;
    private static final String KEY_PATTERN_DEFINITION = "^.*?/b/(.*?)/o/(.*?)(?:[?].*|$)";
    private static final Pattern KEY_PATTERN = Pattern.compile("^.*?/b/(.*?)/o/(.*?)(?:[?].*|$)");

    public FakeStorageRpc(boolean throwIfOption) {
        this.throwIfOption = throwIfOption;
    }

    void reset() {
        this.metadata = new ConcurrentHashMap<String, StorageObject>();
        this.contents = new ConcurrentHashMap<String, byte[]>();
    }

    public StorageObject create(StorageObject object, InputStream content, Map<StorageRpc.Option, ?> options) throws StorageException {
        this.potentiallyThrow(options);
        String key = this.fullname(object);
        object.setUpdated(FakeStorageRpc.now());
        this.metadata.put(key, object);
        try {
            this.contents.put(key, ByteStreams.toByteArray((InputStream)content));
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        return object;
    }

    public Tuple<String, Iterable<StorageObject>> list(String bucket, Map<StorageRpc.Option, ?> options) throws StorageException {
        String delimiter = null;
        String preprefix = "";
        String pageToken = null;
        long maxResults = Long.MAX_VALUE;
        block8: for (Map.Entry<StorageRpc.Option, ?> e : options.entrySet()) {
            switch (e.getKey()) {
                case PAGE_TOKEN: {
                    pageToken = (String)e.getValue();
                    continue block8;
                }
                case PREFIX: {
                    preprefix = (String)e.getValue();
                    if (!preprefix.startsWith("/")) continue block8;
                    preprefix = preprefix.substring(1);
                    continue block8;
                }
                case DELIMITER: {
                    delimiter = (String)e.getValue();
                    continue block8;
                }
                case FIELDS: {
                    continue block8;
                }
                case MAX_RESULTS: {
                    maxResults = (Long)e.getValue();
                    continue block8;
                }
                case USER_PROJECT: {
                    continue block8;
                }
            }
            throw new UnsupportedOperationException("Unknown option: " + e.getKey());
        }
        String prefix = preprefix;
        ArrayList<Object> values = new ArrayList<Object>();
        ConcurrentHashMap<String, StorageObject> folders = new ConcurrentHashMap<String, StorageObject>();
        for (StorageObject so : this.metadata.values()) {
            if (!so.getBucket().equals(bucket) || !so.getName().startsWith(prefix) || FakeStorageRpc.processedAsFolder(so, delimiter, prefix, folders)) continue;
            so.setSize(this.size(so));
            values.add(so);
        }
        values.addAll(folders.values());
        if ((long)values.size() > maxResults) {
            ArrayList newValues = new ArrayList();
            int i = 0;
            while ((long)i < maxResults) {
                newValues.add(values.get(i));
                ++i;
            }
            values = newValues;
        }
        return Tuple.of((Object)pageToken, values);
    }

    public Bucket get(Bucket bucket, Map<StorageRpc.Option, ?> options) throws StorageException {
        this.potentiallyThrow(options);
        return null;
    }

    public StorageObject get(StorageObject object, Map<StorageRpc.Option, ?> options) throws StorageException {
        if (this.throwIfOption && !options.isEmpty() && options.size() > 1 && options.keySet().toArray()[0] != Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.ID})) {
            throw new UnsupportedOperationException();
        }
        String key = this.fullname(object);
        if (this.metadata.containsKey(key)) {
            StorageObject ret = this.metadata.get(key);
            ret.setSize(this.size(ret));
            ret.setId(key);
            return ret;
        }
        return null;
    }

    public Bucket patch(Bucket bucket, Map<StorageRpc.Option, ?> options) throws StorageException {
        this.potentiallyThrow(options);
        return null;
    }

    public StorageObject patch(StorageObject storageObject, Map<StorageRpc.Option, ?> options) throws StorageException {
        this.potentiallyThrow(options);
        return null;
    }

    public boolean delete(Bucket bucket, Map<StorageRpc.Option, ?> options) throws StorageException {
        return false;
    }

    public boolean delete(StorageObject object, Map<StorageRpc.Option, ?> options) throws StorageException {
        String key = this.fullname(object);
        this.contents.remove(key);
        return null != this.metadata.remove(key);
    }

    public StorageObject compose(Iterable<StorageObject> sources, StorageObject target, Map<StorageRpc.Option, ?> targetOptions) throws StorageException {
        return null;
    }

    public byte[] load(StorageObject storageObject, Map<StorageRpc.Option, ?> options) throws StorageException {
        String key = this.fullname(storageObject);
        if (!this.contents.containsKey(key)) {
            throw new StorageException(404, "File not found: " + key);
        }
        return this.contents.get(key);
    }

    public Tuple<String, byte[]> read(StorageObject from, Map<StorageRpc.Option, ?> options, long zposition, int zbytes) throws StorageException {
        byte[] full;
        Long generationMatch = null;
        for (StorageRpc.Option op : options.keySet()) {
            if (op.equals((Object)StorageRpc.Option.IF_GENERATION_MATCH)) {
                generationMatch = (Long)options.get(op);
                continue;
            }
            throw new UnsupportedOperationException("Unknown option: " + op);
        }
        String key = this.fullname(from);
        if (!this.contents.containsKey(key)) {
            throw new StorageException(404, "File not found: " + key);
        }
        this.checkGeneration(key, generationMatch);
        long position = zposition;
        int bytes = zbytes;
        if (position < 0L) {
            position = 0L;
        }
        if ((int)position + bytes > (full = this.contents.get(key)).length) {
            bytes = full.length - (int)position;
        }
        if (bytes <= 0) {
            return Tuple.of((Object)"etag-goes-here", (Object)new byte[0]);
        }
        byte[] ret = new byte[bytes];
        System.arraycopy(full, (int)position, ret, 0, bytes);
        return Tuple.of((Object)"etag-goes-here", (Object)ret);
    }

    public long read(StorageObject from, Map<StorageRpc.Option, ?> options, long position, OutputStream outputStream) {
        byte[] full;
        int bytes;
        Long generationMatch = null;
        for (StorageRpc.Option op : options.keySet()) {
            if (op.equals((Object)StorageRpc.Option.IF_GENERATION_MATCH)) {
                generationMatch = (Long)options.get(op);
                continue;
            }
            throw new UnsupportedOperationException("Unknown option: " + op);
        }
        String key = this.fullname(from);
        if (!this.contents.containsKey(key)) {
            throw new StorageException(404, "File not found: " + key);
        }
        this.checkGeneration(key, generationMatch);
        if (position < 0L) {
            position = 0L;
        }
        if ((bytes = (int)((long)(full = this.contents.get(key)).length - position)) <= 0) {
            return 0L;
        }
        try {
            outputStream.write(full, (int)position, bytes);
        }
        catch (IOException e) {
            throw new StorageException(500, "Failed to write to file", (Throwable)e);
        }
        return bytes;
    }

    public String open(StorageObject object, Map<StorageRpc.Option, ?> options) throws StorageException {
        String key = this.fullname(object);
        Long generationMatch = null;
        for (StorageRpc.Option option : options.keySet()) {
            if (option != StorageRpc.Option.IF_GENERATION_MATCH) continue;
            generationMatch = (Long)options.get(option);
        }
        this.checkGeneration(key, generationMatch);
        this.metadata.put(key, object);
        return this.fullname(object);
    }

    public String open(String signedURL) {
        return null;
    }

    public void write(String uploadId, byte[] toWrite, int toWriteOffset, long destOffset, int length, boolean last) throws StorageException {
        this.writeWithResponse(uploadId, toWrite, toWriteOffset, destOffset, length, last);
    }

    public StorageObject writeWithResponse(String uploadId, byte[] toWrite, int toWriteOffset, long destOffset, int length, boolean last) {
        byte[] bytes;
        if (this.futureContents.containsKey(uploadId)) {
            bytes = this.futureContents.get(uploadId);
            if ((long)bytes.length < (long)length + destOffset) {
                byte[] newBytes = new byte[(int)((long)length + destOffset)];
                System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
                bytes = newBytes;
            }
        } else {
            bytes = new byte[(int)((long)length + destOffset)];
        }
        System.arraycopy(toWrite, toWriteOffset, bytes, (int)destOffset, length);
        StorageObject storageObject = null;
        if (last) {
            this.contents.put(uploadId, bytes);
            this.futureContents.remove(uploadId);
            if (this.metadata.containsKey(uploadId)) {
                storageObject = this.metadata.get(uploadId);
                storageObject.setUpdated(FakeStorageRpc.now());
                Long generation = storageObject.getGeneration();
                if (null == generation) {
                    generation = 0L;
                }
                generation = generation + 1L;
                storageObject.setGeneration(generation);
                this.metadata.put(uploadId, storageObject);
            }
        } else {
            this.futureContents.put(uploadId, bytes);
        }
        return storageObject;
    }

    public StorageRpc.RewriteResponse openRewrite(StorageRpc.RewriteRequest rewriteRequest) throws StorageException {
        Long storedGeneration;
        String sourceKey = this.fullname(rewriteRequest.source);
        if (!this.contents.containsKey(sourceKey)) {
            throw new StorageException(404, "File not found: " + sourceKey);
        }
        Long generationMatch = null;
        for (StorageRpc.Option option : rewriteRequest.targetOptions.keySet()) {
            if (option != StorageRpc.Option.IF_GENERATION_MATCH) continue;
            generationMatch = (Long)rewriteRequest.targetOptions.get(option);
        }
        String destKey = this.fullname(rewriteRequest.target);
        long generation = 1L;
        if (this.metadata.containsKey(destKey) && null != (storedGeneration = this.metadata.get(destKey).getGeneration())) {
            generation = storedGeneration + 1L;
        }
        this.checkGeneration(destKey, generationMatch);
        byte[] data = this.contents.get(sourceKey);
        rewriteRequest.target.setGeneration(Long.valueOf(generation));
        rewriteRequest.target.setSize(BigInteger.valueOf(data.length));
        rewriteRequest.target.setUpdated(this.metadata.get(sourceKey).getUpdated());
        this.metadata.put(destKey, rewriteRequest.target);
        this.contents.put(destKey, Arrays.copyOf(data, data.length));
        return new StorageRpc.RewriteResponse(rewriteRequest, rewriteRequest.target, (long)data.length, true, "rewriteToken goes here", (long)data.length);
    }

    private static DateTime now() {
        return DateTime.parseRfc3339((String)RFC_3339_FORMATTER.format(new Date()));
    }

    private String fullname(StorageObject so) {
        return FakeStorageRpc.fullname(so.getBucket(), so.getName());
    }

    private BigInteger size(StorageObject so) {
        String key = this.fullname(so);
        if (this.contents.containsKey(key)) {
            return BigInteger.valueOf(this.contents.get(key).length);
        }
        return null;
    }

    private void potentiallyThrow(Map<StorageRpc.Option, ?> options) throws UnsupportedOperationException {
        if (this.throwIfOption && !options.isEmpty()) {
            throw new UnsupportedOperationException();
        }
    }

    private void checkGeneration(String key, Long generationMatch) {
        Long generation;
        if (null == generationMatch) {
            return;
        }
        if (generationMatch == 0L && this.metadata.containsKey(key)) {
            throw new StorageException((IOException)new FileAlreadyExistsException(key));
        }
        if (generationMatch != 0L && !generationMatch.equals(generation = this.metadata.get(key).getGeneration())) {
            throw new StorageException(404, "Generation mismatch. Requested " + generationMatch + " but got " + generation);
        }
    }

    private static boolean processedAsFolder(StorageObject so, String delimiter, String prefix, Map<String, StorageObject> folders) {
        if (delimiter == null) {
            return false;
        }
        int nextSlash = so.getName().indexOf(delimiter, prefix.length());
        if (nextSlash < 0) {
            return false;
        }
        String folderName = so.getName().substring(0, nextSlash + 1);
        if (folders.containsKey(folderName)) {
            return true;
        }
        StorageObject fakeFolder = new StorageObject();
        fakeFolder.setName(folderName);
        fakeFolder.setBucket(so.getBucket());
        fakeFolder.setGeneration(so.getGeneration());
        fakeFolder.set("isDirectory", (Object)true);
        fakeFolder.setSize(BigInteger.ZERO);
        folders.put(folderName, fakeFolder);
        return true;
    }

    public ServiceAccount getServiceAccount(String projectId) {
        return null;
    }

    public Storage getStorage() {
        FakeStorageRpcHttpTransport transport = new FakeStorageRpcHttpTransport();
        HttpRequestInitializer httpRequestInitializer = request -> {};
        return new Storage((HttpTransport)transport, (JsonFactory)new GsonFactory(), httpRequestInitializer);
    }

    private static String fullname(String bucket, String object) {
        return String.format("%s/%s", bucket, object);
    }

    MyMockLowLevelHttpRequest create(String url) {
        Matcher m = KEY_PATTERN.matcher(url);
        Preconditions.checkArgument((boolean)m.matches(), (String)"Provided url '%s' does not match expected pattern '%s'", (Object)url, (Object)KEY_PATTERN_DEFINITION);
        String bucket = m.group(1);
        String object = m.group(2);
        String decode = FakeStorageRpc.urlDecode(object);
        String key = FakeStorageRpc.fullname(bucket, decode);
        return new MyMockLowLevelHttpRequest(url, key);
    }

    private static String urlDecode(String object) {
        try {
            return URLDecoder.decode(object, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private class FakeStorageRpcHttpTransport
    extends HttpTransport {
        private FakeStorageRpcHttpTransport() {
        }

        public boolean supportsMethod(String method) {
            return "GET".equals(method);
        }

        public LowLevelHttpRequest buildRequest(String method, String url) {
            return FakeStorageRpc.this.create(url);
        }
    }

    private class MyMockLowLevelHttpRequest
    extends MockLowLevelHttpRequest {
        private final String key;

        private MyMockLowLevelHttpRequest(String url, String key) {
            super(url);
            this.key = key;
        }

        public LowLevelHttpResponse execute() throws IOException {
            return this.getResponse();
        }

        public MockLowLevelHttpResponse getResponse() {
            MockLowLevelHttpResponse resp = new MockLowLevelHttpResponse();
            byte[] bytes = FakeStorageRpc.this.contents.get(this.key);
            if (bytes == null) {
                resp.setStatusCode(404);
            } else {
                int length = bytes.length;
                Map headers = this.getHeaders();
                List range = (List)headers.get("range");
                int begin = 0;
                int endInclusive = length - 1;
                if (range != null && !range.isEmpty()) {
                    String rangeString = ((String)range.get(0)).substring("range=".length());
                    if ("0-".equals(rangeString)) {
                        resp.setStatusCode(200);
                    } else {
                        if (rangeString.startsWith("-")) {
                            resp.setStatusCode(400);
                            return resp;
                        }
                        if (rangeString.endsWith("-")) {
                            String beginS = rangeString.substring(0, rangeString.length() - 1);
                            begin = Integer.parseInt(beginS);
                            resp.setStatusCode(206);
                        } else {
                            int i = rangeString.indexOf(45);
                            if (i == -1) {
                                resp.setStatusCode(400);
                                return resp;
                            }
                            String beginS = rangeString.substring(0, i);
                            String endInclusiveS = rangeString.substring(i + 1);
                            begin = Integer.parseInt(beginS);
                            endInclusive = Integer.parseInt(endInclusiveS);
                            resp.setStatusCode(206);
                        }
                    }
                    if (begin > length) {
                        resp.addHeader("Content-Range", String.format("bytes */%d", length));
                        resp.setContent(EMPTY_BYTES);
                        resp.setContent((InputStream)new ByteArrayInputStream(EMPTY_BYTES));
                    } else {
                        int newLength = endInclusive - begin + 1;
                        resp.addHeader("Content-Length", String.valueOf(newLength));
                        resp.addHeader("Content-Range", String.format("bytes %d-%d/%d", begin, endInclusive, length));
                        byte[] content = Arrays.copyOfRange(bytes, begin, endInclusive + 1);
                        resp.setContent(content);
                        resp.setContent((InputStream)new ByteArrayInputStream(content));
                    }
                } else {
                    resp.addHeader("Content-Length", String.valueOf(length));
                    resp.setContent(bytes);
                    resp.setContent((InputStream)new ByteArrayInputStream(bytes));
                    resp.setStatusCode(200);
                }
            }
            return resp;
        }
    }
}

