/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.api.gax.paging.Page;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.CopyWriter;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.contrib.nio.CloudStorageConfiguration;
import com.google.cloud.storage.contrib.nio.CloudStorageFileAttributeView;
import com.google.cloud.storage.contrib.nio.CloudStorageFileAttributes;
import com.google.cloud.storage.contrib.nio.CloudStorageFileSystem;
import com.google.cloud.storage.contrib.nio.CloudStorageObjectAttributes;
import com.google.cloud.storage.contrib.nio.CloudStorageObjectImmutableException;
import com.google.cloud.storage.contrib.nio.CloudStorageOption;
import com.google.cloud.storage.contrib.nio.CloudStoragePath;
import com.google.cloud.storage.contrib.nio.CloudStoragePseudoDirectoryAttributes;
import com.google.cloud.storage.contrib.nio.CloudStoragePseudoDirectoryException;
import com.google.cloud.storage.contrib.nio.CloudStorageReadChannel;
import com.google.cloud.storage.contrib.nio.CloudStorageReadFileChannel;
import com.google.cloud.storage.contrib.nio.CloudStorageRetryHandler;
import com.google.cloud.storage.contrib.nio.CloudStorageUtil;
import com.google.cloud.storage.contrib.nio.CloudStorageWriteChannel;
import com.google.cloud.storage.contrib.nio.CloudStorageWriteFileChannel;
import com.google.cloud.storage.contrib.nio.OptionAcl;
import com.google.cloud.storage.contrib.nio.OptionAllowTrailingSlash;
import com.google.cloud.storage.contrib.nio.OptionBlockSize;
import com.google.cloud.storage.contrib.nio.OptionCacheControl;
import com.google.cloud.storage.contrib.nio.OptionContentDisposition;
import com.google.cloud.storage.contrib.nio.OptionContentEncoding;
import com.google.cloud.storage.contrib.nio.OptionMaxChannelReopens;
import com.google.cloud.storage.contrib.nio.OptionMimeType;
import com.google.cloud.storage.contrib.nio.OptionUserMetadata;
import com.google.cloud.storage.contrib.nio.StorageOptionsUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.AbstractIterator;
import com.google.common.net.UrlEscapers;
import com.google.common.primitives.Ints;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Singleton;

@Singleton
@ThreadSafe
public final class CloudStorageFileSystemProvider
extends FileSystemProvider {
    private Storage storage;
    private final StorageOptions storageOptions;
    @Nullable
    private final String userProject;
    private static StorageOptions futureStorageOptions = StorageOptionsUtil.getDefaultInstance();

    @VisibleForTesting
    public static void setStorageOptions(@Nullable StorageOptions newStorageOptions) {
        futureStorageOptions = newStorageOptions;
    }

    public static void setDefaultCloudStorageConfiguration(@Nullable CloudStorageConfiguration newDefault) {
        CloudStorageFileSystem.setDefaultCloudStorageConfiguration(newDefault);
    }

    public CloudStorageFileSystemProvider() {
        this(CloudStorageFileSystem.getDefaultCloudStorageConfiguration().userProject(), futureStorageOptions);
    }

    CloudStorageFileSystemProvider(@Nullable String userProject) {
        this(userProject, futureStorageOptions);
    }

    CloudStorageFileSystemProvider(@Nullable String userProject, @Nullable StorageOptions gcsStorageOptions) {
        this.storageOptions = gcsStorageOptions != null ? StorageOptionsUtil.mergeOptionsWithUserAgent(gcsStorageOptions) : StorageOptionsUtil.getDefaultInstance();
        this.userProject = userProject;
    }

    private void initStorage() {
        if (this.storage == null) {
            this.doInitStorage();
        }
    }

    @Override
    public String getScheme() {
        return "gs";
    }

    @Override
    public CloudStorageFileSystem getFileSystem(URI uri) {
        this.initStorage();
        return this.newFileSystem(uri, Collections.emptyMap());
    }

    @Override
    public CloudStorageFileSystem newFileSystem(URI uri, Map<String, ?> env) {
        Preconditions.checkArgument((boolean)uri.getScheme().equalsIgnoreCase("gs"), (String)"Cloud Storage URIs must have '%s' scheme: %s", (Object)"gs", (Object)uri);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uri.getAuthority()) ? 1 : 0) != 0, (String)"%s:// URIs must have a host: %s", (Object)"gs", (Object)uri);
        Preconditions.checkArgument((uri.getPort() == -1 && Strings.isNullOrEmpty((String)uri.getQuery()) && Strings.isNullOrEmpty((String)uri.getFragment()) && Strings.isNullOrEmpty((String)uri.getUserInfo()) ? 1 : 0) != 0, (String)"GCS FileSystem URIs mustn't have: port, userinfo, query, or fragment: %s", (Object)uri);
        CloudStorageUtil.checkBucket(uri.getAuthority());
        this.initStorage();
        return new CloudStorageFileSystem(this, uri.getAuthority(), CloudStorageConfiguration.fromMap(CloudStorageFileSystem.getDefaultCloudStorageConfiguration(), env));
    }

    @Override
    public CloudStoragePath getPath(URI uri) {
        this.initStorage();
        return CloudStoragePath.getPath(this.getFileSystem(CloudStorageUtil.stripPathFromUri(uri)), uri.getPath(), new String[0]);
    }

    public CloudStoragePath getPath(String uriInStringForm) {
        String escaped = UrlEscapers.urlFragmentEscaper().escape(uriInStringForm);
        return this.getPath(URI.create(escaped));
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        Preconditions.checkNotNull((Object)path);
        this.initStorage();
        CloudStorageUtil.checkNotNullArray(attrs);
        if (options.contains(StandardOpenOption.WRITE)) {
            return this.newWriteChannel(path, options);
        }
        return this.newReadChannel(path, options);
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        Preconditions.checkNotNull((Object)path);
        this.initStorage();
        CloudStorageUtil.checkNotNullArray(attrs);
        if (options.contains(StandardOpenOption.CREATE_NEW)) {
            Files.createFile(path, attrs);
        } else if (options.contains(StandardOpenOption.CREATE) && !Files.exists(path, new LinkOption[0])) {
            Files.createFile(path, attrs);
        }
        if (options.contains(StandardOpenOption.WRITE) || options.contains(StandardOpenOption.CREATE) || options.contains(StandardOpenOption.CREATE_NEW) || options.contains(StandardOpenOption.TRUNCATE_EXISTING)) {
            return new CloudStorageWriteFileChannel(this.newWriteChannel(path, options));
        }
        return new CloudStorageReadFileChannel(this.newReadChannel(path, options));
    }

    private SeekableByteChannel newReadChannel(Path path, Set<? extends OpenOption> options) throws IOException {
        this.initStorage();
        int maxChannelReopens = CloudStorageUtil.getMaxChannelReopensFromPath(path);
        ArrayList<Storage.BlobSourceOption> blobSourceOptions = new ArrayList<Storage.BlobSourceOption>();
        block5: for (OpenOption openOption : options) {
            if (openOption instanceof StandardOpenOption) {
                switch ((StandardOpenOption)openOption) {
                    case READ: {
                        continue block5;
                    }
                    case SPARSE: 
                    case TRUNCATE_EXISTING: {
                        continue block5;
                    }
                    case WRITE: {
                        throw new IllegalArgumentException("READ+WRITE not supported yet");
                    }
                }
                throw new UnsupportedOperationException(openOption.toString());
            }
            if (openOption instanceof OptionMaxChannelReopens) {
                maxChannelReopens = ((OptionMaxChannelReopens)openOption).maxChannelReopens();
                continue;
            }
            if (openOption instanceof Storage.BlobSourceOption) {
                blobSourceOptions.add((Storage.BlobSourceOption)openOption);
                continue;
            }
            throw new UnsupportedOperationException(openOption.toString());
        }
        CloudStoragePath cloudPath = CloudStorageUtil.checkPath(path);
        if (cloudPath.seemsLikeADirectoryAndUsePseudoDirectories(null)) {
            throw new CloudStoragePseudoDirectoryException(cloudPath);
        }
        return CloudStorageReadChannel.create(this.storage, cloudPath.getBlobId(), 0L, maxChannelReopens, cloudPath.getFileSystem().config(), this.userProject, blobSourceOptions.toArray(new Storage.BlobSourceOption[blobSourceOptions.size()]));
    }

    private SeekableByteChannel newWriteChannel(Path path, Set<? extends OpenOption> options) throws IOException {
        this.initStorage();
        CloudStoragePath cloudPath = CloudStorageUtil.checkPath(path);
        boolean allowSlash = options.contains(OptionAllowTrailingSlash.getInstance());
        if (!allowSlash && cloudPath.seemsLikeADirectoryAndUsePseudoDirectories(null)) {
            throw new CloudStoragePseudoDirectoryException(cloudPath);
        }
        BlobId file = cloudPath.getBlobId();
        BlobInfo.Builder infoBuilder = BlobInfo.newBuilder((BlobId)file);
        ArrayList<Storage.BlobWriteOption> writeOptions = new ArrayList<Storage.BlobWriteOption>();
        ArrayList<Acl> acls = new ArrayList<Acl>();
        HashMap<String, String> metas = new HashMap<String, String>();
        block8: for (OpenOption openOption : options) {
            if (openOption instanceof OptionMimeType) {
                infoBuilder.setContentType(((OptionMimeType)openOption).mimeType());
                continue;
            }
            if (openOption instanceof OptionCacheControl) {
                infoBuilder.setCacheControl(((OptionCacheControl)openOption).cacheControl());
                continue;
            }
            if (openOption instanceof OptionContentDisposition) {
                infoBuilder.setContentDisposition(((OptionContentDisposition)openOption).contentDisposition());
                continue;
            }
            if (openOption instanceof OptionContentEncoding) {
                infoBuilder.setContentEncoding(((OptionContentEncoding)openOption).contentEncoding());
                continue;
            }
            if (openOption instanceof OptionUserMetadata) {
                OptionUserMetadata opMeta = (OptionUserMetadata)openOption;
                metas.put(opMeta.key(), opMeta.value());
                continue;
            }
            if (openOption instanceof OptionAcl) {
                acls.add(((OptionAcl)openOption).acl());
                continue;
            }
            if (openOption instanceof OptionBlockSize) continue;
            if (openOption instanceof StandardOpenOption) {
                switch ((StandardOpenOption)openOption) {
                    case TRUNCATE_EXISTING: 
                    case WRITE: 
                    case CREATE: {
                        continue block8;
                    }
                    case SPARSE: {
                        continue block8;
                    }
                    case CREATE_NEW: {
                        writeOptions.add(Storage.BlobWriteOption.doesNotExist());
                        continue block8;
                    }
                    case READ: {
                        throw new IllegalArgumentException("READ+WRITE not supported yet");
                    }
                }
                throw new UnsupportedOperationException(openOption.toString());
            }
            if (openOption instanceof CloudStorageOption) continue;
            throw new UnsupportedOperationException(openOption.toString());
        }
        if (!Strings.isNullOrEmpty((String)this.userProject)) {
            writeOptions.add(Storage.BlobWriteOption.userProject((String)this.userProject));
        }
        if (!metas.isEmpty()) {
            infoBuilder.setMetadata(metas);
        }
        if (!acls.isEmpty()) {
            infoBuilder.setAcl(acls);
        }
        try {
            return new CloudStorageWriteChannel(this.storage.writer(infoBuilder.build(), writeOptions.toArray(new Storage.BlobWriteOption[writeOptions.size()])));
        }
        catch (StorageException oops) {
            throw this.asIoException(oops, false);
        }
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        this.initStorage();
        InputStream result = super.newInputStream(path, options);
        CloudStoragePath cloudPath = CloudStorageUtil.checkPath(path);
        int blockSize = cloudPath.getFileSystem().config().blockSize();
        for (OpenOption option : options) {
            if (!(option instanceof OptionBlockSize)) continue;
            blockSize = ((OptionBlockSize)option).size();
        }
        return new BufferedInputStream(result, blockSize);
    }

    @Override
    public boolean deleteIfExists(Path path) throws IOException {
        this.initStorage();
        CloudStoragePath cloudPath = CloudStorageUtil.checkPath(path);
        if (cloudPath.seemsLikeADirectoryAndUsePseudoDirectories(this.storage)) {
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(path);){
                if (!paths.iterator().hasNext()) {
                    boolean bl = true;
                    return bl;
                }
            }
            throw new CloudStoragePseudoDirectoryException(cloudPath);
        }
        CloudStorageRetryHandler retryHandler = new CloudStorageRetryHandler(cloudPath.getFileSystem().config());
        while (true) {
            try {
                if (Strings.isNullOrEmpty((String)this.userProject)) {
                    return this.storage.delete(cloudPath.getBlobId());
                }
                return this.storage.delete(cloudPath.getBlobId(), new Storage.BlobSourceOption[]{Storage.BlobSourceOption.userProject((String)this.userProject)});
            }
            catch (StorageException exs) {
                retryHandler.handleStorageException(exs);
                continue;
            }
            break;
        }
    }

    @Override
    public void delete(Path path) throws IOException {
        this.initStorage();
        CloudStoragePath cloudPath = CloudStorageUtil.checkPath(path);
        if (!this.deleteIfExists(cloudPath)) {
            throw new NoSuchFileException(cloudPath.toString());
        }
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        this.initStorage();
        for (CopyOption option : options) {
            if (option != StandardCopyOption.ATOMIC_MOVE) continue;
            throw new AtomicMoveNotSupportedException(source.toString(), target.toString(), "Google Cloud Storage does not support atomic move operations.");
        }
        this.copy(source, target, options);
        this.delete(source);
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        this.initStorage();
        boolean wantCopyAttributes = false;
        boolean wantReplaceExisting = false;
        boolean overrideContentType = false;
        boolean overrideCacheControl = false;
        boolean overrideContentEncoding = false;
        boolean overrideContentDisposition = false;
        CloudStoragePath toPath = CloudStorageUtil.checkPath(target);
        BlobInfo.Builder tgtInfoBuilder = BlobInfo.newBuilder((BlobId)toPath.getBlobId()).setContentType("");
        int blockSize = -1;
        block8: for (CopyOption option : options) {
            if (option instanceof StandardCopyOption) {
                switch ((StandardCopyOption)option) {
                    case COPY_ATTRIBUTES: {
                        wantCopyAttributes = true;
                        continue block8;
                    }
                    case REPLACE_EXISTING: {
                        wantReplaceExisting = true;
                        continue block8;
                    }
                    default: {
                        throw new UnsupportedOperationException(option.toString());
                    }
                }
            }
            if (option instanceof CloudStorageOption) {
                if (option instanceof OptionBlockSize) {
                    blockSize = ((OptionBlockSize)option).size();
                    continue;
                }
                if (option instanceof OptionMimeType) {
                    tgtInfoBuilder.setContentType(((OptionMimeType)option).mimeType());
                    overrideContentType = true;
                    continue;
                }
                if (option instanceof OptionCacheControl) {
                    tgtInfoBuilder.setCacheControl(((OptionCacheControl)option).cacheControl());
                    overrideCacheControl = true;
                    continue;
                }
                if (option instanceof OptionContentEncoding) {
                    tgtInfoBuilder.setContentEncoding(((OptionContentEncoding)option).contentEncoding());
                    overrideContentEncoding = true;
                    continue;
                }
                if (option instanceof OptionContentDisposition) {
                    tgtInfoBuilder.setContentDisposition(((OptionContentDisposition)option).contentDisposition());
                    overrideContentDisposition = true;
                    continue;
                }
                throw new UnsupportedOperationException(option.toString());
            }
            throw new UnsupportedOperationException(option.toString());
        }
        CloudStoragePath fromPath = CloudStorageUtil.checkPath(source);
        int n = blockSize = blockSize != -1 ? blockSize : Ints.max((int[])new int[]{fromPath.getFileSystem().config().blockSize(), toPath.getFileSystem().config().blockSize()});
        if (fromPath.seemsLikeADirectory() && toPath.seemsLikeADirectory()) {
            if (fromPath.getFileSystem().config().usePseudoDirectories() && toPath.getFileSystem().config().usePseudoDirectories()) {
                return;
            }
            Preconditions.checkArgument((!fromPath.getFileSystem().config().usePseudoDirectories() && !toPath.getFileSystem().config().usePseudoDirectories() ? 1 : 0) != 0, (Object)"File systems associated with paths don't agree on pseudo-directories.");
        }
        if (fromPath.seemsLikeADirectoryAndUsePseudoDirectories(null)) {
            throw new CloudStoragePseudoDirectoryException(fromPath);
        }
        if (toPath.seemsLikeADirectoryAndUsePseudoDirectories(null)) {
            throw new CloudStoragePseudoDirectoryException(toPath);
        }
        CloudStorageRetryHandler retryHandler = new CloudStorageRetryHandler(fromPath.getFileSystem().config());
        while (true) {
            try {
                if (wantCopyAttributes) {
                    Blob blobInfo = Strings.isNullOrEmpty((String)this.userProject) ? this.storage.get(fromPath.getBlobId()) : this.storage.get(fromPath.getBlobId(), new Storage.BlobGetOption[]{Storage.BlobGetOption.userProject((String)this.userProject)});
                    if (null == blobInfo) {
                        throw new NoSuchFileException(fromPath.toString());
                    }
                    if (!overrideCacheControl) {
                        tgtInfoBuilder.setCacheControl(blobInfo.getCacheControl());
                    }
                    if (!overrideContentType) {
                        tgtInfoBuilder.setContentType(blobInfo.getContentType());
                    }
                    if (!overrideContentEncoding) {
                        tgtInfoBuilder.setContentEncoding(blobInfo.getContentEncoding());
                    }
                    if (!overrideContentDisposition) {
                        tgtInfoBuilder.setContentDisposition(blobInfo.getContentDisposition());
                    }
                    tgtInfoBuilder.setAcl(blobInfo.getAcl());
                    tgtInfoBuilder.setMetadata(blobInfo.getMetadata());
                }
                BlobInfo tgtInfo = tgtInfoBuilder.build();
                Storage.CopyRequest.Builder copyReqBuilder = Storage.CopyRequest.newBuilder().setSource(fromPath.getBlobId());
                copyReqBuilder = wantReplaceExisting ? copyReqBuilder.setTarget(tgtInfo, new Storage.BlobTargetOption[0]) : copyReqBuilder.setTarget(tgtInfo, new Storage.BlobTargetOption[]{Storage.BlobTargetOption.doesNotExist()});
                if (!Strings.isNullOrEmpty((String)fromPath.getFileSystem().config().userProject())) {
                    copyReqBuilder = copyReqBuilder.setSourceOptions(new Storage.BlobSourceOption[]{Storage.BlobSourceOption.userProject((String)fromPath.getFileSystem().config().userProject())});
                } else if (!Strings.isNullOrEmpty((String)toPath.getFileSystem().config().userProject())) {
                    copyReqBuilder = copyReqBuilder.setSourceOptions(new Storage.BlobSourceOption[]{Storage.BlobSourceOption.userProject((String)toPath.getFileSystem().config().userProject())});
                }
                CopyWriter copyWriter = this.storage.copy(copyReqBuilder.build());
                copyWriter.getResult();
                break;
            }
            catch (StorageException oops) {
                try {
                    retryHandler.handleStorageException(oops);
                }
                catch (StorageException retriesExhaustedException) {
                    throw this.asIoException(retriesExhaustedException, true);
                }
            }
        }
    }

    @Override
    public boolean isSameFile(Path path, Path path2) {
        return CloudStorageUtil.checkPath(path).equals(CloudStorageUtil.checkPath(path2));
    }

    @Override
    public boolean isHidden(Path path) {
        CloudStorageUtil.checkPath(path);
        return false;
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        this.initStorage();
        block6: for (AccessMode mode : modes) {
            switch (mode) {
                case READ: 
                case WRITE: {
                    continue block6;
                }
                default: {
                    throw new UnsupportedOperationException(mode.toString());
                }
            }
        }
        CloudStoragePath cloudPath = CloudStorageUtil.checkPath(path);
        CloudStorageRetryHandler retryHandler = new CloudStorageRetryHandler(cloudPath.getFileSystem().config());
        while (true) {
            try {
                boolean nullId;
                if (cloudPath.normalize().equals(cloudPath.getRoot())) {
                    return;
                }
                if (Strings.isNullOrEmpty((String)this.userProject)) {
                    nullId = this.storage.get(cloudPath.getBlobId(), new Storage.BlobGetOption[]{Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.ID})}) == null;
                } else {
                    boolean bl = nullId = this.storage.get(cloudPath.getBlobId(), new Storage.BlobGetOption[]{Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.ID}), Storage.BlobGetOption.userProject((String)this.userProject)}) == null;
                }
                if (nullId) {
                    if (cloudPath.seemsLikeADirectoryAndUsePseudoDirectories(this.storage)) {
                        return;
                    }
                    throw new NoSuchFileException(path.toString());
                }
            }
            catch (StorageException exs) {
                retryHandler.handleStorageException(exs);
                continue;
            }
            catch (IllegalArgumentException exs) {
                if (CloudStorageUtil.checkPath(path).seemsLikeADirectoryAndUsePseudoDirectories(this.storage)) {
                    return;
                }
                throw exs;
            }
            break;
        }
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        Preconditions.checkNotNull(type);
        CloudStorageUtil.checkNotNullArray(options);
        if (type != CloudStorageFileAttributes.class && type != BasicFileAttributes.class) {
            throw new UnsupportedOperationException(type.getSimpleName());
        }
        this.initStorage();
        CloudStoragePath cloudPath = CloudStorageUtil.checkPath(path);
        CloudStorageRetryHandler retryHandler = new CloudStorageRetryHandler(cloudPath.getFileSystem().config());
        while (true) {
            try {
                Blob blobInfo = null;
                try {
                    BlobId blobId = cloudPath.getBlobId();
                    if (!Strings.isNullOrEmpty((String)blobId.getName())) {
                        blobInfo = Strings.isNullOrEmpty((String)this.userProject) ? this.storage.get(blobId) : this.storage.get(blobId, new Storage.BlobGetOption[]{Storage.BlobGetOption.userProject((String)this.userProject)});
                    }
                }
                catch (IllegalArgumentException ex) {
                    if (cloudPath.seemsLikeADirectoryAndUsePseudoDirectories(this.storage)) {
                        CloudStoragePseudoDirectoryAttributes result = new CloudStoragePseudoDirectoryAttributes(cloudPath);
                        return (A)result;
                    }
                    throw ex;
                }
                if (null == blobInfo || blobInfo.getSize() == null) {
                    if (cloudPath.seemsLikeADirectoryAndUsePseudoDirectories(this.storage)) {
                        CloudStoragePseudoDirectoryAttributes result = new CloudStoragePseudoDirectoryAttributes(cloudPath);
                        return (A)result;
                    }
                    throw new NoSuchFileException("gs://" + cloudPath.getBlobId().getBucket() + "/" + cloudPath.getBlobId().getName());
                }
                CloudStorageObjectAttributes ret = new CloudStorageObjectAttributes((BlobInfo)blobInfo);
                if (cloudPath.seemsLikeADirectoryAndUsePseudoDirectories(null)) {
                    CloudStoragePseudoDirectoryAttributes result = new CloudStoragePseudoDirectoryAttributes(cloudPath);
                    return (A)result;
                }
                CloudStorageObjectAttributes result = ret;
                return (A)result;
            }
            catch (StorageException exs) {
                retryHandler.handleStorageException(exs);
                continue;
            }
            break;
        }
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        BasicFileAttributes fileAttributes;
        String[] split = attributes.split(":", 2);
        if (split.length != 2) {
            throw new UnsupportedOperationException();
        }
        String view = split[0];
        List<String> attributeNames = Arrays.asList(split[1].split(","));
        boolean allAttributes = attributeNames.size() == 1 && attributeNames.get(0).equals("*");
        TreeMap<String, Object> results = new TreeMap<String, Object>();
        switch (view) {
            case "gcs": {
                fileAttributes = this.readAttributes(path, CloudStorageFileAttributes.class, options);
                break;
            }
            case "posix": 
            case "basic": {
                fileAttributes = this.readAttributes(path, BasicFileAttributes.class, options);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (fileAttributes == null) {
            throw new UnsupportedOperationException();
        }
        if (allAttributes || attributeNames.contains("lastModifiedTime")) {
            results.put("lastModifiedTime", fileAttributes.lastModifiedTime());
        }
        if (allAttributes || attributeNames.contains("lastAccessTime")) {
            results.put("lastAccessTime", fileAttributes.lastAccessTime());
        }
        if (allAttributes || attributeNames.contains("creationTime")) {
            results.put("creationTime", fileAttributes.creationTime());
        }
        if (allAttributes || attributeNames.contains("isRegularFile")) {
            results.put("isRegularFile", fileAttributes.isRegularFile());
        }
        if (allAttributes || attributeNames.contains("isDirectory")) {
            results.put("isDirectory", fileAttributes.isDirectory());
        }
        if (allAttributes || attributeNames.contains("isSymbolicLink")) {
            results.put("isSymbolicLink", fileAttributes.isSymbolicLink());
        }
        if (allAttributes || attributeNames.contains("isOther")) {
            results.put("isOther", fileAttributes.isOther());
        }
        if (allAttributes || attributeNames.contains("size")) {
            results.put("size", fileAttributes.size());
        }
        if (view.equals("posix")) {
            if (allAttributes || attributeNames.contains("owner")) {
                results.put("owner", new UserPrincipal(){

                    @Override
                    public String getName() {
                        return "fakeowner";
                    }

                    @Override
                    public String toString() {
                        return "fakeowner";
                    }
                });
            }
            if (allAttributes || attributeNames.contains("group")) {
                results.put("group", new GroupPrincipal(){

                    @Override
                    public String getName() {
                        return "fakegroup";
                    }

                    @Override
                    public String toString() {
                        return "fakegroup";
                    }
                });
            }
            if (allAttributes || attributeNames.contains("permissions")) {
                if (fileAttributes.isRegularFile()) {
                    results.put("permissions", EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE));
                } else {
                    results.put("permissions", EnumSet.of(PosixFilePermission.OWNER_READ, new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_EXECUTE}));
                }
            }
        }
        if (fileAttributes instanceof CloudStorageFileAttributes) {
            CloudStorageFileAttributes cloudStorageFileAttributes = (CloudStorageFileAttributes)fileAttributes;
            if (allAttributes || attributeNames.contains("etag")) {
                results.put("etag", cloudStorageFileAttributes.etag());
            }
            if (allAttributes || attributeNames.contains("mimeType")) {
                results.put("mimeType", cloudStorageFileAttributes.mimeType());
            }
            if (allAttributes || attributeNames.contains("acl")) {
                results.put("acl", cloudStorageFileAttributes.acl());
            }
            if (allAttributes || attributeNames.contains("cacheControl")) {
                results.put("cacheControl", cloudStorageFileAttributes.cacheControl());
            }
            if (allAttributes || attributeNames.contains("contentEncoding")) {
                results.put("contentEncoding", cloudStorageFileAttributes.contentEncoding());
            }
            if (allAttributes || attributeNames.contains("contentDisposition")) {
                results.put("contentDisposition", cloudStorageFileAttributes.contentDisposition());
            }
            if (allAttributes || attributeNames.contains("userMetadata")) {
                results.put("userMetadata", cloudStorageFileAttributes.userMetadata());
            }
        }
        return results;
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        Preconditions.checkNotNull(type);
        CloudStorageUtil.checkNotNullArray(options);
        if (type != CloudStorageFileAttributeView.class && type != BasicFileAttributeView.class) {
            throw new UnsupportedOperationException(type.getSimpleName());
        }
        CloudStoragePath cloudPath = CloudStorageUtil.checkPath(path);
        CloudStorageFileAttributeView result = new CloudStorageFileAttributeView(this.storage, cloudPath);
        return (V)result;
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) {
        CloudStorageUtil.checkPath(dir);
        CloudStorageUtil.checkNotNullArray(attrs);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(final Path dir, final DirectoryStream.Filter<? super Path> filter) {
        final CloudStoragePath cloudPath = CloudStorageUtil.checkPath(dir);
        Preconditions.checkNotNull(filter);
        this.initStorage();
        CloudStorageRetryHandler retryHandler = new CloudStorageRetryHandler(cloudPath.getFileSystem().config());
        while (true) {
            try {
                String prePrefix = cloudPath.normalize().toRealPath(new LinkOption[0]).toString();
                if (!prePrefix.isEmpty() && !prePrefix.endsWith("/")) {
                    prePrefix = prePrefix + "/";
                }
                final String prefix = prePrefix;
                Page dirList = Strings.isNullOrEmpty((String)this.userProject) ? this.storage.list(cloudPath.bucket(), new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)prefix), Storage.BlobListOption.currentDirectory(), Storage.BlobListOption.fields((Storage.BlobField[])new Storage.BlobField[0])}) : this.storage.list(cloudPath.bucket(), new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)prefix), Storage.BlobListOption.currentDirectory(), Storage.BlobListOption.fields((Storage.BlobField[])new Storage.BlobField[0]), Storage.BlobListOption.userProject((String)this.userProject)});
                final Iterator blobIterator = dirList.iterateAll().iterator();
                return new DirectoryStream<Path>(){

                    @Override
                    public Iterator<Path> iterator() {
                        return new LazyPathIterator(cloudPath.getFileSystem(), prefix, blobIterator, filter, dir.isAbsolute());
                    }

                    @Override
                    public void close() throws IOException {
                    }
                };
            }
            catch (StorageException exs) {
                retryHandler.handleStorageException(exs);
                continue;
            }
            break;
        }
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) {
        throw new CloudStorageObjectImmutableException();
    }

    @Override
    public FileStore getFileStore(Path path) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object other) {
        return this == other || other instanceof CloudStorageFileSystemProvider && Objects.equals(this.storage, ((CloudStorageFileSystemProvider)other).storage);
    }

    public int hashCode() {
        return Objects.hash(this.storage);
    }

    public String toString() {
        this.initStorage();
        return MoreObjects.toStringHelper((Object)this).add("storage", (Object)this.storage).toString();
    }

    public boolean requesterPays(String bucketName) {
        this.initStorage();
        try {
            Bucket bucket = this.storage.get(bucketName, new Storage.BucketGetOption[0]);
            if (bucket == null) {
                return false;
            }
            Boolean isRP = bucket.requesterPays();
            return isRP != null && isRP != false;
        }
        catch (StorageException ex) {
            if ("userProjectMissing".equals(ex.getReason())) {
                return true;
            }
            if (ex.getCode() == 400 && ex.getMessage() != null && ex.getMessage().contains("requester pays")) {
                return true;
            }
            throw ex;
        }
    }

    public CloudStorageFileSystemProvider withNoUserProject() {
        return new CloudStorageFileSystemProvider("", this.storageOptions);
    }

    public String getProject() {
        this.initStorage();
        return ((StorageOptions)this.storage.getOptions()).getProjectId();
    }

    Page<Bucket> listBuckets(Storage.BucketListOption ... options) {
        this.initStorage();
        return this.storage.list(options);
    }

    private IOException asIoException(StorageException oops, boolean operationWasCopy) {
        if (oops.getCode() == 404) {
            return new NoSuchFileException(oops.getReason());
        }
        if (operationWasCopy && oops.getCode() == 412) {
            return new FileAlreadyExistsException(String.format("Copy failed for reason '%s'. This most likely means the destination already exists and java.nio.file.StandardCopyOption.REPLACE_EXISTING was not specified.", oops.getReason()));
        }
        Throwable cause = oops.getCause();
        try {
            if (cause instanceof FileAlreadyExistsException) {
                throw new FileAlreadyExistsException(((FileAlreadyExistsException)cause).getReason());
            }
            if (cause != null && cause instanceof IOException) {
                return (IOException)cause;
            }
        }
        catch (IOException okEx) {
            return okEx;
        }
        return new IOException(oops.getMessage(), oops);
    }

    @VisibleForTesting
    void doInitStorage() {
        this.storage = (Storage)this.storageOptions.getService();
    }

    private static class LazyPathIterator
    extends AbstractIterator<Path> {
        private final Iterator<Blob> blobIterator;
        private final DirectoryStream.Filter<? super Path> filter;
        private final CloudStorageFileSystem fileSystem;
        private final String prefix;
        private final boolean absolutePaths;

        LazyPathIterator(CloudStorageFileSystem fileSystem, String prefix, Iterator<Blob> blobIterator, DirectoryStream.Filter<? super Path> filter, boolean absolutePaths) {
            this.prefix = prefix;
            this.blobIterator = blobIterator;
            this.filter = filter;
            this.fileSystem = fileSystem;
            this.absolutePaths = absolutePaths;
        }

        protected Path computeNext() {
            while (this.blobIterator.hasNext()) {
                CloudStoragePath path = this.fileSystem.getPath(this.blobIterator.next().getName(), new String[0]);
                try {
                    if (path.toString().equals(this.prefix) || !this.filter.accept(path)) continue;
                    if (this.absolutePaths) {
                        return path.toAbsolutePath();
                    }
                    return path;
                }
                catch (IOException ex) {
                    throw new DirectoryIteratorException(ex);
                }
            }
            return (Path)this.endOfData();
        }
    }
}

