/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.contrib.nio.CloudStorageConfiguration;
import com.google.cloud.storage.contrib.nio.CloudStorageFileSystemProvider;
import com.google.cloud.storage.contrib.nio.CloudStoragePath;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class CloudStorageFileSystem
extends FileSystem {
    public static final String URI_SCHEME = "gs";
    public static final String GCS_VIEW = "gcs";
    public static final String BASIC_VIEW = "basic";
    public static final int BLOCK_SIZE_DEFAULT = 0x200000;
    public static final FileTime FILE_TIME_UNKNOWN = FileTime.fromMillis(0L);
    public static final Set<String> SUPPORTED_VIEWS = ImmutableSet.of((Object)"basic", (Object)"gcs");
    private final CloudStorageFileSystemProvider provider;
    private final String bucket;
    private final CloudStorageConfiguration config;

    @CheckReturnValue
    public static CloudStorageFileSystem forBucket(String bucket) {
        return CloudStorageFileSystem.forBucket(bucket, CloudStorageConfiguration.DEFAULT);
    }

    @CheckReturnValue
    public static CloudStorageFileSystem forBucket(String bucket, CloudStorageConfiguration config) {
        Preconditions.checkArgument((!bucket.startsWith("gs:") ? 1 : 0) != 0, (String)"Bucket name must not have schema: %s", (Object[])new Object[]{bucket});
        return new CloudStorageFileSystem(new CloudStorageFileSystemProvider(), bucket, (CloudStorageConfiguration)Preconditions.checkNotNull((Object)config));
    }

    @CheckReturnValue
    public static CloudStorageFileSystem forBucket(String bucket, CloudStorageConfiguration config, @Nullable StorageOptions storageOptions) {
        Preconditions.checkArgument((!bucket.startsWith("gs:") ? 1 : 0) != 0, (String)"Bucket name must not have schema: %s", (Object[])new Object[]{bucket});
        return new CloudStorageFileSystem(new CloudStorageFileSystemProvider(storageOptions), bucket, (CloudStorageConfiguration)Preconditions.checkNotNull((Object)config));
    }

    CloudStorageFileSystem(CloudStorageFileSystemProvider provider, String bucket, CloudStorageConfiguration config) {
        Preconditions.checkArgument((!bucket.isEmpty() ? 1 : 0) != 0, (Object)"bucket");
        this.provider = provider;
        this.bucket = bucket;
        this.config = config;
    }

    @Override
    public CloudStorageFileSystemProvider provider() {
        return this.provider;
    }

    public String bucket() {
        return this.bucket;
    }

    public CloudStorageConfiguration config() {
        return this.config;
    }

    @Override
    public CloudStoragePath getPath(String first, String ... more) {
        Preconditions.checkArgument((!first.startsWith("gs:") ? 1 : 0) != 0, (String)"Google Cloud Storage FileSystem.getPath() must not have schema and bucket name: %s", (Object[])new Object[]{first});
        return CloudStoragePath.getPath(this, first, more);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getSeparator() {
        return Character.toString('/');
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return ImmutableSet.of((Object)CloudStoragePath.getPath(this, "/", new String[0]));
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return ImmutableSet.of();
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return SUPPORTED_VIEWS;
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        return FileSystems.getDefault().getPathMatcher(syntaxAndPattern);
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchService newWatchService() throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object other) {
        return this == other || other instanceof CloudStorageFileSystem && Objects.equals(this.config, ((CloudStorageFileSystem)other).config) && Objects.equals(this.bucket, ((CloudStorageFileSystem)other).bucket);
    }

    public int hashCode() {
        return Objects.hash(this.bucket);
    }

    public String toString() {
        try {
            return new URI(URI_SCHEME, this.bucket, null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }
}

