/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.cloud.storage.contrib.nio.CloudStorageFileSystem;
import com.google.cloud.storage.contrib.nio.CloudStoragePath;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.util.regex.Pattern;

final class CloudStorageUtil {
    private static final Pattern BUCKET_PATTERN = Pattern.compile("[a-z0-9][-._a-z0-9]+[a-z0-9]");

    static void checkBucket(String bucket) {
        String string = String.valueOf(String.valueOf(bucket));
        Preconditions.checkArgument((boolean)BUCKET_PATTERN.matcher(bucket).matches(), (Object)new StringBuilder(303 + string.length()).append("Invalid bucket name: '").append(string).append("'. ").append("Google Cloud Storage bucket names must contain only lowercase letters, numbers, ").append("dashes (-), underscores (_), and dots (.). Bucket names must start and end with a ").append("number or a letter. See the following page for more details: ").append("https://developers.google.com/storage/docs/bucketnaming").toString());
    }

    static CloudStoragePath checkPath(Path path) {
        if (!(Preconditions.checkNotNull((Object)path) instanceof CloudStoragePath)) {
            throw new ProviderMismatchException(String.format("Not a Cloud Storage path: %s (%s)", path, path.getClass().getSimpleName()));
        }
        return (CloudStoragePath)path;
    }

    static URI stripPathFromUri(URI uri) {
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), null, uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @SafeVarargs
    static <T> void checkNotNullArray(T ... values) {
        for (T value : values) {
            Preconditions.checkNotNull(value);
        }
    }

    static int getMaxChannelReopensFromPath(Path path) {
        return ((CloudStorageFileSystem)path.getFileSystem()).config().maxChannelReopens();
    }

    private CloudStorageUtil() {
    }
}

