/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.cloud.storage.Acl;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.contrib.nio.CloudStorageFileAttributes;
import com.google.cloud.storage.contrib.nio.CloudStorageFileSystem;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.nio.file.attribute.FileTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
final class CloudStorageObjectAttributes
implements CloudStorageFileAttributes {
    @Nonnull
    private final BlobInfo info;

    CloudStorageObjectAttributes(BlobInfo info) {
        this.info = (BlobInfo)Preconditions.checkNotNull((Object)info);
    }

    @Override
    public long size() {
        return this.info.size();
    }

    @Override
    public FileTime creationTime() {
        if (this.info.updateTime() == null) {
            return CloudStorageFileSystem.FILE_TIME_UNKNOWN;
        }
        return FileTime.fromMillis(this.info.updateTime());
    }

    @Override
    public FileTime lastModifiedTime() {
        return this.creationTime();
    }

    @Override
    public Optional<String> etag() {
        return Optional.fromNullable((Object)this.info.etag());
    }

    @Override
    public Optional<String> mimeType() {
        return Optional.fromNullable((Object)this.info.contentType());
    }

    @Override
    public Optional<List<Acl>> acl() {
        return Optional.fromNullable((Object)this.info.acl());
    }

    @Override
    public Optional<String> cacheControl() {
        return Optional.fromNullable((Object)this.info.cacheControl());
    }

    @Override
    public Optional<String> contentEncoding() {
        return Optional.fromNullable((Object)this.info.contentEncoding());
    }

    @Override
    public Optional<String> contentDisposition() {
        return Optional.fromNullable((Object)this.info.contentDisposition());
    }

    @Override
    public ImmutableMap<String, String> userMetadata() {
        if (null == this.info.metadata()) {
            return ImmutableMap.of();
        }
        return ImmutableMap.copyOf((Map)this.info.metadata());
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isOther() {
        return false;
    }

    @Override
    public boolean isRegularFile() {
        return true;
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public FileTime lastAccessTime() {
        return CloudStorageFileSystem.FILE_TIME_UNKNOWN;
    }

    @Override
    public Object fileKey() {
        return this.info.blobId().bucket() + this.info.blobId().name() + this.info.blobId().generation();
    }

    public boolean equals(Object other) {
        return this == other || other instanceof CloudStorageObjectAttributes && Objects.equals(this.info, ((CloudStorageObjectAttributes)other).info);
    }

    public int hashCode() {
        return this.info.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("info", (Object)this.info).toString();
    }
}

