/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
final class UnixPath
implements CharSequence {
    public static final char DOT = '.';
    public static final char SEPARATOR = '/';
    public static final String ROOT = "/";
    public static final String CURRENT_DIR = ".";
    public static final String PARENT_DIR = "..";
    public static final UnixPath EMPTY_PATH = new UnixPath(false, "");
    public static final UnixPath ROOT_PATH = new UnixPath(false, "/");
    private static final Splitter SPLITTER = Splitter.on((char)'/').omitEmptyStrings();
    private static final Splitter SPLITTER_PERMIT_EMPTY_COMPONENTS = Splitter.on((char)'/');
    private static final Joiner JOINER = Joiner.on((char)'/');
    private static final Ordering<Iterable<String>> ORDERING = Ordering.natural().lexicographical();
    private final String path;
    private List<String> lazyStringParts;
    private final boolean permitEmptyComponents;

    private UnixPath(boolean permitEmptyComponents, String path) {
        this.path = (String)Preconditions.checkNotNull((Object)path);
        this.permitEmptyComponents = permitEmptyComponents;
    }

    public static UnixPath getPath(boolean permitEmptyComponents, String path) {
        if (path.isEmpty()) {
            return EMPTY_PATH;
        }
        if (UnixPath.isRootInternal(path)) {
            return ROOT_PATH;
        }
        return new UnixPath(permitEmptyComponents, path);
    }

    public static UnixPath getPath(boolean permitEmptyComponents, String first, String ... more) {
        if (more.length == 0) {
            return UnixPath.getPath(permitEmptyComponents, first);
        }
        StringBuilder builder = new StringBuilder(first);
        for (int i = 0; i < more.length; ++i) {
            String part = more[i];
            if (part.isEmpty()) continue;
            if (UnixPath.isAbsoluteInternal(part)) {
                if (i == more.length - 1) {
                    return new UnixPath(permitEmptyComponents, part);
                }
                builder.replace(0, builder.length(), part);
                continue;
            }
            if (UnixPath.hasTrailingSeparatorInternal(builder)) {
                builder.append(part);
                continue;
            }
            builder.append('/');
            builder.append(part);
        }
        return new UnixPath(permitEmptyComponents, builder.toString());
    }

    public boolean isRoot() {
        return UnixPath.isRootInternal(this.path);
    }

    private static boolean isRootInternal(String path) {
        return path.length() == 1 && path.charAt(0) == '/';
    }

    public boolean isAbsolute() {
        return UnixPath.isAbsoluteInternal(this.path);
    }

    private static boolean isAbsoluteInternal(String path) {
        return !path.isEmpty() && path.charAt(0) == '/';
    }

    public boolean hasTrailingSeparator() {
        return UnixPath.hasTrailingSeparatorInternal(this.path);
    }

    private static boolean hasTrailingSeparatorInternal(CharSequence path) {
        return path.length() != 0 && path.charAt(path.length() - 1) == '/';
    }

    public boolean seemsLikeADirectory() {
        int length = this.path.length();
        return this.path.isEmpty() || this.path.charAt(length - 1) == '/' || this.path.endsWith(CURRENT_DIR) && (length == 1 || this.path.charAt(length - 2) == '/') || this.path.endsWith(PARENT_DIR) && (length == 2 || this.path.charAt(length - 3) == '/');
    }

    @Nullable
    public UnixPath getFileName() {
        if (this.path.isEmpty()) {
            return EMPTY_PATH;
        }
        if (this.isRoot()) {
            return null;
        }
        List<String> parts = this.getParts();
        String last = parts.get(parts.size() - 1);
        return parts.size() == 1 && this.path.equals(last) ? this : new UnixPath(this.permitEmptyComponents, last);
    }

    @Nullable
    public UnixPath getParent() {
        int index;
        if (this.path.isEmpty() || this.isRoot()) {
            return null;
        }
        int n = index = this.hasTrailingSeparator() ? this.path.lastIndexOf(47, this.path.length() - 2) : this.path.lastIndexOf(47);
        if (index == -1) {
            return this.isAbsolute() ? ROOT_PATH : null;
        }
        return new UnixPath(this.permitEmptyComponents, this.path.substring(0, index + 1));
    }

    @Nullable
    public UnixPath getRoot() {
        return this.isAbsolute() ? ROOT_PATH : null;
    }

    public UnixPath subpath(int beginIndex, int endIndex) {
        List<String> subList;
        if (this.path.isEmpty() && beginIndex == 0 && endIndex == 1) {
            return this;
        }
        Preconditions.checkArgument((beginIndex >= 0 && endIndex > beginIndex ? 1 : 0) != 0);
        try {
            subList = this.getParts().subList(beginIndex, endIndex);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException();
        }
        return new UnixPath(this.permitEmptyComponents, JOINER.join(subList));
    }

    public int getNameCount() {
        if (this.path.isEmpty()) {
            return 1;
        }
        if (this.isRoot()) {
            return 0;
        }
        return this.getParts().size();
    }

    public UnixPath getName(int index) {
        if (this.path.isEmpty()) {
            return this;
        }
        try {
            return new UnixPath(this.permitEmptyComponents, this.getParts().get(index));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException();
        }
    }

    public UnixPath normalize() {
        int index;
        ArrayList<String> parts = new ArrayList<String>();
        boolean mutated = false;
        int resultLength = 0;
        int mark = 0;
        do {
            String part;
            switch (part = this.path.substring(mark, (index = this.path.indexOf(47, mark)) == -1 ? this.path.length() : index + 1)) {
                case ".": 
                case "./": {
                    mutated = true;
                    break;
                }
                case "..": 
                case "../": {
                    mutated = true;
                    if (parts.isEmpty()) break;
                    resultLength -= ((String)parts.remove(parts.size() - 1)).length();
                    break;
                }
                default: {
                    if (index != mark || index == 0) {
                        parts.add(part);
                        resultLength = part.length();
                        break;
                    }
                    mutated = true;
                }
            }
            mark = index + 1;
        } while (index != -1);
        if (!mutated) {
            return this;
        }
        StringBuilder result = new StringBuilder(resultLength);
        for (String part : parts) {
            result.append(part);
        }
        return new UnixPath(this.permitEmptyComponents, result.toString());
    }

    public UnixPath resolve(UnixPath other) {
        if (other.path.isEmpty()) {
            return this;
        }
        if (other.isAbsolute()) {
            return other;
        }
        if (this.hasTrailingSeparator()) {
            return new UnixPath(this.permitEmptyComponents, this.path + other.path);
        }
        return new UnixPath(this.permitEmptyComponents, this.path + '/' + other.path);
    }

    public UnixPath resolveSibling(UnixPath other) {
        Preconditions.checkNotNull((Object)other);
        UnixPath parent = this.getParent();
        return parent == null ? other : parent.resolve(other);
    }

    public UnixPath relativize(UnixPath other) {
        Preconditions.checkArgument((this.isAbsolute() == other.isAbsolute() ? 1 : 0) != 0, (Object)"'other' is different type of Path");
        if (this.path.isEmpty()) {
            return other;
        }
        PeekingIterator left = Iterators.peekingIterator(this.split());
        PeekingIterator right = Iterators.peekingIterator(other.split());
        while (left.hasNext() && right.hasNext() && ((String)left.peek()).equals(right.peek())) {
            left.next();
            right.next();
        }
        StringBuilder result = new StringBuilder(this.path.length() + other.path.length());
        while (left.hasNext()) {
            result.append(PARENT_DIR);
            result.append('/');
            left.next();
        }
        while (right.hasNext()) {
            result.append((String)right.next());
            result.append('/');
        }
        if (result.length() > 0 && !other.hasTrailingSeparator()) {
            result.deleteCharAt(result.length() - 1);
        }
        return new UnixPath(this.permitEmptyComponents, result.toString());
    }

    public boolean startsWith(UnixPath other) {
        UnixPath me = this.removeTrailingSeparator();
        other = other.removeTrailingSeparator();
        if (other.path.length() > me.path.length()) {
            return false;
        }
        if (me.isAbsolute() != other.isAbsolute()) {
            return false;
        }
        if (!me.path.isEmpty() && other.path.isEmpty()) {
            return false;
        }
        return UnixPath.startsWith(this.split(), other.split());
    }

    private static boolean startsWith(Iterator<String> lefts, Iterator<String> rights) {
        while (rights.hasNext()) {
            if (lefts.hasNext() && rights.next().equals(lefts.next())) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(UnixPath other) {
        UnixPath me = this.removeTrailingSeparator();
        other = other.removeTrailingSeparator();
        if (other.path.length() > me.path.length()) {
            return false;
        }
        if (!me.path.isEmpty() && other.path.isEmpty()) {
            return false;
        }
        if (other.isAbsolute()) {
            return me.isAbsolute() && me.path.equals(other.path);
        }
        return UnixPath.startsWith(me.splitReverse(), other.splitReverse());
    }

    public int compareTo(UnixPath other) {
        return ORDERING.compare(this.getParts(), other.getParts());
    }

    public UnixPath toAbsolutePath(UnixPath currentWorkingDirectory) {
        Preconditions.checkArgument((boolean)currentWorkingDirectory.isAbsolute());
        return this.isAbsolute() ? this : currentWorkingDirectory.resolve(this);
    }

    public UnixPath toAbsolutePath() {
        return this.toAbsolutePath(ROOT_PATH);
    }

    public UnixPath removeBeginningSeparator() {
        return this.isAbsolute() ? new UnixPath(this.permitEmptyComponents, this.path.substring(1)) : this;
    }

    public UnixPath addTrailingSeparator() {
        return this.hasTrailingSeparator() ? this : new UnixPath(this.permitEmptyComponents, this.path + '/');
    }

    public UnixPath removeTrailingSeparator() {
        if (!this.isRoot() && this.hasTrailingSeparator()) {
            return new UnixPath(this.permitEmptyComponents, this.path.substring(0, this.path.length() - 1));
        }
        return this;
    }

    public Iterator<String> split() {
        return this.getParts().iterator();
    }

    public Iterator<String> splitReverse() {
        return Lists.reverse(this.getParts()).iterator();
    }

    public boolean equals(Object other) {
        return this == other || other instanceof UnixPath && this.path.equals(((UnixPath)other).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public String toString() {
        return this.path;
    }

    @Override
    public int length() {
        return this.path.length();
    }

    @Override
    public char charAt(int index) {
        return this.path.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.path.subSequence(start, end);
    }

    @Override
    public boolean isEmpty() {
        return this.path.isEmpty();
    }

    private List<String> getParts() {
        List<String> result = this.lazyStringParts;
        return result != null ? result : (this.lazyStringParts = this.path.isEmpty() || this.isRoot() ? Collections.emptyList() : this.createParts());
    }

    private List<String> createParts() {
        if (this.permitEmptyComponents) {
            return SPLITTER_PERMIT_EMPTY_COMPONENTS.splitToList((CharSequence)(this.path.charAt(0) == '/' ? this.path.substring(1) : this.path));
        }
        return SPLITTER.splitToList((CharSequence)this.path);
    }
}

