/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.cloud.storage.StorageException;
import java.io.EOFException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import javax.net.ssl.SSLException;

public class CloudStorageRetryHandler {
    private int retries;
    private int reopens;
    private long totalWaitTime;
    private final int maxRetries;
    private final int maxReopens;

    public CloudStorageRetryHandler(int maxRetriesAndReopens) {
        this.maxRetries = maxRetriesAndReopens;
        this.maxReopens = maxRetriesAndReopens;
    }

    public CloudStorageRetryHandler(int maxRetries, int maxReopens) {
        this.maxRetries = maxRetries;
        this.maxReopens = maxReopens;
    }

    public int retries() {
        return this.retries;
    }

    public int reopens() {
        return this.reopens;
    }

    public boolean handleStorageException(StorageException exs) throws StorageException {
        if (CloudStorageRetryHandler.isRetryable(exs)) {
            this.handleRetryForStorageException(exs);
            return false;
        }
        if (CloudStorageRetryHandler.isReopenable(exs)) {
            this.handleReopenForStorageException(exs);
            return true;
        }
        throw exs;
    }

    private void handleRetryForStorageException(StorageException exs) throws StorageException {
        ++this.retries;
        if (this.retries > this.maxRetries) {
            throw new StorageException(exs.getCode(), "All " + this.maxRetries + " retries failed. Waited a total of " + this.totalWaitTime + " ms between attempts", (Throwable)exs);
        }
        this.sleepForAttempt(this.retries);
    }

    private void handleReopenForStorageException(StorageException exs) throws StorageException {
        ++this.reopens;
        if (this.reopens > this.maxReopens) {
            throw new StorageException(exs.getCode(), "All " + this.maxReopens + " reopens failed. Waited a total of " + this.totalWaitTime + " ms between attempts", (Throwable)exs);
        }
        this.sleepForAttempt(this.reopens);
    }

    void sleepForAttempt(int attempt) {
        long delay = 1000L * (1L << Math.min(attempt, 7));
        try {
            Thread.sleep(delay);
            this.totalWaitTime += delay;
        }
        catch (InterruptedException iex) {
            Thread.currentThread().interrupt();
        }
    }

    private static boolean isRetryable(StorageException exs) {
        return exs.isRetryable() || exs.getCode() == 500 || exs.getCode() == 502 || exs.getCode() == 503;
    }

    private static boolean isReopenable(StorageException exs) {
        int maxDepth = 20;
        for (Object throwable = exs; throwable != null && maxDepth-- > 0; throwable = throwable.getCause()) {
            if ((throwable.getMessage() == null || !throwable.getMessage().contains("Connection closed prematurely")) && !(throwable instanceof SSLException) && !(throwable instanceof EOFException) && !(throwable instanceof SocketException) && !(throwable instanceof SocketTimeoutException)) continue;
            return true;
        }
        return false;
    }
}

