/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio.testing;

import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.BucketAccessControl;
import com.google.api.services.storage.model.Notification;
import com.google.api.services.storage.model.ObjectAccessControl;
import com.google.api.services.storage.model.Policy;
import com.google.api.services.storage.model.ServiceAccount;
import com.google.api.services.storage.model.StorageObject;
import com.google.api.services.storage.model.TestIamPermissionsResponse;
import com.google.cloud.Tuple;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.spi.v1.RpcBatch;
import com.google.cloud.storage.spi.v1.StorageRpc;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.FileAlreadyExistsException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class FakeStorageRpc
implements StorageRpc {
    Map<String, StorageObject> metadata = new HashMap<String, StorageObject>();
    Map<String, byte[]> contents = new HashMap<String, byte[]>();
    Map<String, byte[]> futureContents = new HashMap<String, byte[]>();
    private final boolean throwIfOption;

    public FakeStorageRpc(boolean throwIfOption) {
        this.throwIfOption = throwIfOption;
    }

    void reset() {
        this.metadata = new HashMap<String, StorageObject>();
        this.contents = new HashMap<String, byte[]>();
    }

    public Bucket create(Bucket bucket, Map<StorageRpc.Option, ?> options) throws StorageException {
        throw new UnsupportedOperationException();
    }

    public StorageObject create(StorageObject object, InputStream content, Map<StorageRpc.Option, ?> options) throws StorageException {
        this.potentiallyThrow(options);
        String key = this.fullname(object);
        this.metadata.put(key, object);
        try {
            this.contents.put(key, ByteStreams.toByteArray((InputStream)content));
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        return object;
    }

    public Tuple<String, Iterable<Bucket>> list(Map<StorageRpc.Option, ?> options) throws StorageException {
        throw new UnsupportedOperationException();
    }

    public Tuple<String, Iterable<StorageObject>> list(String bucket, Map<StorageRpc.Option, ?> options) throws StorageException {
        String delimiter = null;
        String preprefix = "";
        block5: for (Map.Entry<StorageRpc.Option, ?> e : options.entrySet()) {
            switch (e.getKey()) {
                case PREFIX: {
                    preprefix = (String)e.getValue();
                    if (!preprefix.startsWith("/")) continue block5;
                    preprefix = preprefix.substring(1);
                    continue block5;
                }
                case DELIMITER: {
                    delimiter = (String)e.getValue();
                    continue block5;
                }
                case FIELDS: {
                    continue block5;
                }
            }
            throw new UnsupportedOperationException("Unknown option: " + e.getKey());
        }
        String prefix = preprefix;
        ArrayList<Object> values = new ArrayList<Object>();
        HashMap<String, StorageObject> folders = new HashMap<String, StorageObject>();
        for (StorageObject so : this.metadata.values()) {
            if (!so.getName().startsWith(prefix) || FakeStorageRpc.processedAsFolder(so, delimiter, prefix, folders)) continue;
            values.add(so);
        }
        values.addAll(folders.values());
        return Tuple.of(null, values);
    }

    public Bucket get(Bucket bucket, Map<StorageRpc.Option, ?> options) throws StorageException {
        this.potentiallyThrow(options);
        return null;
    }

    public StorageObject get(StorageObject object, Map<StorageRpc.Option, ?> options) throws StorageException {
        if (this.throwIfOption && !options.isEmpty() && options.size() > 1 && options.keySet().toArray()[0] != Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.ID})) {
            throw new UnsupportedOperationException();
        }
        String key = this.fullname(object);
        if (this.metadata.containsKey(key)) {
            StorageObject ret = this.metadata.get(key);
            if (this.contents.containsKey(key)) {
                ret.setSize(BigInteger.valueOf(this.contents.get(key).length));
            }
            ret.setId(key);
            return ret;
        }
        return null;
    }

    public Bucket patch(Bucket bucket, Map<StorageRpc.Option, ?> options) throws StorageException {
        this.potentiallyThrow(options);
        return null;
    }

    public StorageObject patch(StorageObject storageObject, Map<StorageRpc.Option, ?> options) throws StorageException {
        this.potentiallyThrow(options);
        return null;
    }

    public boolean delete(Bucket bucket, Map<StorageRpc.Option, ?> options) throws StorageException {
        return false;
    }

    public boolean delete(StorageObject object, Map<StorageRpc.Option, ?> options) throws StorageException {
        String key = this.fullname(object);
        this.contents.remove(key);
        return null != this.metadata.remove(key);
    }

    public RpcBatch createBatch() {
        throw new UnsupportedOperationException();
    }

    public StorageObject compose(Iterable<StorageObject> sources, StorageObject target, Map<StorageRpc.Option, ?> targetOptions) throws StorageException {
        return null;
    }

    public byte[] load(StorageObject storageObject, Map<StorageRpc.Option, ?> options) throws StorageException {
        String key = this.fullname(storageObject);
        if (!this.contents.containsKey(key)) {
            throw new StorageException(404, "File not found: " + key);
        }
        return this.contents.get(key);
    }

    public Tuple<String, byte[]> read(StorageObject from, Map<StorageRpc.Option, ?> options, long zposition, int zbytes) throws StorageException {
        byte[] full;
        Long generationMatch = null;
        for (StorageRpc.Option op : options.keySet()) {
            if (op.equals((Object)StorageRpc.Option.IF_GENERATION_MATCH)) {
                generationMatch = (Long)options.get(op);
                continue;
            }
            throw new UnsupportedOperationException("Unknown option: " + op);
        }
        String key = this.fullname(from);
        if (!this.contents.containsKey(key)) {
            throw new StorageException(404, "File not found: " + key);
        }
        this.checkGeneration(key, generationMatch);
        long position = zposition;
        int bytes = zbytes;
        if (position < 0L) {
            position = 0L;
        }
        if ((int)position + bytes > (full = this.contents.get(key)).length) {
            bytes = full.length - (int)position;
        }
        if (bytes <= 0) {
            return Tuple.of((Object)"etag-goes-here", (Object)new byte[0]);
        }
        byte[] ret = new byte[bytes];
        System.arraycopy(full, (int)position, ret, 0, bytes);
        return Tuple.of((Object)"etag-goes-here", (Object)ret);
    }

    public String open(StorageObject object, Map<StorageRpc.Option, ?> options) throws StorageException {
        String key = this.fullname(object);
        Long generationMatch = null;
        for (StorageRpc.Option option : options.keySet()) {
            if (option != StorageRpc.Option.IF_GENERATION_MATCH) continue;
            generationMatch = (Long)options.get(option);
        }
        this.checkGeneration(key, generationMatch);
        this.metadata.put(key, object);
        return this.fullname(object);
    }

    public void write(String uploadId, byte[] toWrite, int toWriteOffset, long destOffset, int length, boolean last) throws StorageException {
        byte[] bytes;
        if (this.futureContents.containsKey(uploadId)) {
            bytes = this.futureContents.get(uploadId);
            if ((long)bytes.length < (long)length + destOffset) {
                byte[] newBytes = new byte[(int)((long)length + destOffset)];
                System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
                bytes = newBytes;
            }
        } else {
            bytes = new byte[(int)((long)length + destOffset)];
        }
        System.arraycopy(toWrite, toWriteOffset, bytes, (int)destOffset, length);
        if (last) {
            this.contents.put(uploadId, bytes);
            this.futureContents.remove(uploadId);
            if (this.metadata.containsKey(uploadId)) {
                StorageObject storageObject = this.metadata.get(uploadId);
                Long generation = storageObject.getGeneration();
                if (null == generation) {
                    generation = 0L;
                }
                generation = generation + 1L;
                storageObject.setGeneration(generation);
                this.metadata.put(uploadId, storageObject);
            }
        } else {
            this.futureContents.put(uploadId, bytes);
        }
    }

    public StorageRpc.RewriteResponse openRewrite(StorageRpc.RewriteRequest rewriteRequest) throws StorageException {
        String sourceKey = this.fullname(rewriteRequest.source);
        if (!this.contents.containsKey(sourceKey)) {
            throw new StorageException(404, "File not found: " + sourceKey);
        }
        Long generationMatch = null;
        for (StorageRpc.Option option : rewriteRequest.targetOptions.keySet()) {
            if (option != StorageRpc.Option.IF_GENERATION_MATCH) continue;
            generationMatch = (Long)rewriteRequest.targetOptions.get(option);
        }
        String destKey = this.fullname(rewriteRequest.target);
        this.checkGeneration(destKey, generationMatch);
        this.metadata.put(destKey, rewriteRequest.target);
        byte[] data = this.contents.get(sourceKey);
        this.contents.put(destKey, Arrays.copyOf(data, data.length));
        return new StorageRpc.RewriteResponse(rewriteRequest, rewriteRequest.target, (long)data.length, true, "rewriteToken goes here", (long)data.length);
    }

    public StorageRpc.RewriteResponse continueRewrite(StorageRpc.RewriteResponse previousResponse) throws StorageException {
        throw new UnsupportedOperationException();
    }

    public BucketAccessControl getAcl(String bucket, String entity, Map<StorageRpc.Option, ?> options) {
        throw new UnsupportedOperationException();
    }

    public boolean deleteAcl(String bucket, String entity, Map<StorageRpc.Option, ?> options) {
        throw new UnsupportedOperationException();
    }

    public BucketAccessControl createAcl(BucketAccessControl acl, Map<StorageRpc.Option, ?> options) {
        throw new UnsupportedOperationException();
    }

    public BucketAccessControl patchAcl(BucketAccessControl acl, Map<StorageRpc.Option, ?> options) {
        throw new UnsupportedOperationException();
    }

    public List<BucketAccessControl> listAcls(String bucket, Map<StorageRpc.Option, ?> options) {
        throw new UnsupportedOperationException();
    }

    public ObjectAccessControl getDefaultAcl(String bucket, String entity) {
        throw new UnsupportedOperationException();
    }

    public boolean deleteDefaultAcl(String bucket, String entity) {
        throw new UnsupportedOperationException();
    }

    public ObjectAccessControl createDefaultAcl(ObjectAccessControl acl) {
        throw new UnsupportedOperationException();
    }

    public ObjectAccessControl patchDefaultAcl(ObjectAccessControl acl) {
        throw new UnsupportedOperationException();
    }

    public List<ObjectAccessControl> listDefaultAcls(String bucket) {
        throw new UnsupportedOperationException();
    }

    public ObjectAccessControl getAcl(String bucket, String object, Long generation, String entity) {
        throw new UnsupportedOperationException();
    }

    public boolean deleteAcl(String bucket, String object, Long generation, String entity) {
        throw new UnsupportedOperationException();
    }

    public ObjectAccessControl createAcl(ObjectAccessControl acl) {
        throw new UnsupportedOperationException();
    }

    public ObjectAccessControl patchAcl(ObjectAccessControl acl) {
        throw new UnsupportedOperationException();
    }

    public List<ObjectAccessControl> listAcls(String bucket, String object, Long generation) {
        throw new UnsupportedOperationException();
    }

    private String fullname(StorageObject so) {
        return so.getBucket() + "/" + so.getName();
    }

    private void potentiallyThrow(Map<StorageRpc.Option, ?> options) throws UnsupportedOperationException {
        if (this.throwIfOption && !options.isEmpty()) {
            throw new UnsupportedOperationException();
        }
    }

    private void checkGeneration(String key, Long generationMatch) {
        Long generation;
        if (null == generationMatch) {
            return;
        }
        if (generationMatch == 0L && this.metadata.containsKey(key)) {
            throw new StorageException((IOException)new FileAlreadyExistsException(key));
        }
        if (generationMatch != 0L && !generationMatch.equals(generation = this.metadata.get(key).getGeneration())) {
            throw new StorageException(404, "Generation mismatch. Requested " + generationMatch + " but got " + generation);
        }
    }

    private static boolean processedAsFolder(StorageObject so, String delimiter, String prefix, Map<String, StorageObject> folders) {
        if (delimiter == null) {
            return false;
        }
        int nextSlash = so.getName().indexOf(delimiter, prefix.length());
        if (nextSlash < 0) {
            return false;
        }
        String folderName = so.getName().substring(0, nextSlash + 1);
        if (folders.containsKey(folderName)) {
            return true;
        }
        StorageObject fakeFolder = new StorageObject();
        fakeFolder.setName(folderName);
        fakeFolder.setBucket(so.getBucket());
        fakeFolder.setGeneration(so.getGeneration());
        folders.put(folderName, fakeFolder);
        return true;
    }

    public Policy getIamPolicy(String bucket, Map<StorageRpc.Option, ?> options) {
        throw new UnsupportedOperationException();
    }

    public Policy setIamPolicy(String bucket, Policy policy, Map<StorageRpc.Option, ?> options) {
        throw new UnsupportedOperationException();
    }

    public TestIamPermissionsResponse testIamPermissions(String bucket, List<String> permissions, Map<StorageRpc.Option, ?> options) {
        throw new UnsupportedOperationException();
    }

    public boolean deleteNotification(String bucket, String notification) {
        throw new UnsupportedOperationException();
    }

    public List<Notification> listNotifications(String bucket) {
        throw new UnsupportedOperationException();
    }

    public Notification createNotification(String bucket, Notification notification) {
        throw new UnsupportedOperationException();
    }

    public Bucket lockRetentionPolicy(Bucket bucket, Map<StorageRpc.Option, ?> options) {
        throw new UnsupportedOperationException();
    }

    public ServiceAccount getServiceAccount(String projectId) {
        return null;
    }
}

