/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.orgpolicy.v2.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.orgpolicy.v2.CreateCustomConstraintRequest;
import com.google.cloud.orgpolicy.v2.CreatePolicyRequest;
import com.google.cloud.orgpolicy.v2.CustomConstraint;
import com.google.cloud.orgpolicy.v2.DeleteCustomConstraintRequest;
import com.google.cloud.orgpolicy.v2.DeletePolicyRequest;
import com.google.cloud.orgpolicy.v2.GetCustomConstraintRequest;
import com.google.cloud.orgpolicy.v2.GetEffectivePolicyRequest;
import com.google.cloud.orgpolicy.v2.GetPolicyRequest;
import com.google.cloud.orgpolicy.v2.ListConstraintsRequest;
import com.google.cloud.orgpolicy.v2.ListConstraintsResponse;
import com.google.cloud.orgpolicy.v2.ListCustomConstraintsRequest;
import com.google.cloud.orgpolicy.v2.ListCustomConstraintsResponse;
import com.google.cloud.orgpolicy.v2.ListPoliciesRequest;
import com.google.cloud.orgpolicy.v2.ListPoliciesResponse;
import com.google.cloud.orgpolicy.v2.OrgPolicyClient;
import com.google.cloud.orgpolicy.v2.Policy;
import com.google.cloud.orgpolicy.v2.UpdateCustomConstraintRequest;
import com.google.cloud.orgpolicy.v2.UpdatePolicyRequest;
import com.google.cloud.orgpolicy.v2.stub.HttpJsonOrgPolicyCallableFactory;
import com.google.cloud.orgpolicy.v2.stub.OrgPolicyStub;
import com.google.cloud.orgpolicy.v2.stub.OrgPolicyStubSettings;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonOrgPolicyStub
extends OrgPolicyStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListConstraintsRequest, ListConstraintsResponse> listConstraintsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.orgpolicy.v2.OrgPolicy/ListConstraints").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*}/constraints", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{parent=folders/*}/constraints", "/v2/{parent=organizations/*}/constraints"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListConstraintsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListPoliciesRequest, ListPoliciesResponse> listPoliciesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.orgpolicy.v2.OrgPolicy/ListPolicies").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*}/policies", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{parent=folders/*}/policies", "/v2/{parent=organizations/*}/policies"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListPoliciesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetPolicyRequest, Policy> getPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.orgpolicy.v2.OrgPolicy/GetPolicy").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/policies/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{name=folders/*/policies/*}", "/v2/{name=organizations/*/policies/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetEffectivePolicyRequest, Policy> getEffectivePolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.orgpolicy.v2.OrgPolicy/GetEffectivePolicy").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/policies/*}:getEffectivePolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{name=folders/*/policies/*}:getEffectivePolicy", "/v2/{name=organizations/*/policies/*}:getEffectivePolicy"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreatePolicyRequest, Policy> createPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.orgpolicy.v2.OrgPolicy/CreatePolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*}/policies", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{parent=folders/*}/policies", "/v2/{parent=organizations/*}/policies"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("policy", (Message)request.getPolicy(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdatePolicyRequest, Policy> updatePolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.orgpolicy.v2.OrgPolicy/UpdatePolicy").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{policy.name=projects/*/policies/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "policy.name", (Object)request.getPolicy().getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{policy.name=folders/*/policies/*}", "/v2/{policy.name=organizations/*/policies/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("policy", (Message)request.getPolicy(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeletePolicyRequest, Empty> deletePolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.orgpolicy.v2.OrgPolicy/DeletePolicy").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/policies/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{name=folders/*/policies/*}", "/v2/{name=organizations/*/policies/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateCustomConstraintRequest, CustomConstraint> createCustomConstraintMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.orgpolicy.v2.OrgPolicy/CreateCustomConstraint").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=organizations/*}/customConstraints", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("customConstraint", (Message)request.getCustomConstraint(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CustomConstraint.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateCustomConstraintRequest, CustomConstraint> updateCustomConstraintMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.orgpolicy.v2.OrgPolicy/UpdateCustomConstraint").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{customConstraint.name=organizations/*/customConstraints/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "customConstraint.name", (Object)request.getCustomConstraint().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("customConstraint", (Message)request.getCustomConstraint(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CustomConstraint.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetCustomConstraintRequest, CustomConstraint> getCustomConstraintMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.orgpolicy.v2.OrgPolicy/GetCustomConstraint").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=organizations/*/customConstraints/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CustomConstraint.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListCustomConstraintsRequest, ListCustomConstraintsResponse> listCustomConstraintsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.orgpolicy.v2.OrgPolicy/ListCustomConstraints").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=organizations/*}/customConstraints", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListCustomConstraintsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteCustomConstraintRequest, Empty> deleteCustomConstraintMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.orgpolicy.v2.OrgPolicy/DeleteCustomConstraint").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=organizations/*/customConstraints/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListConstraintsRequest, ListConstraintsResponse> listConstraintsCallable;
    private final UnaryCallable<ListConstraintsRequest, OrgPolicyClient.ListConstraintsPagedResponse> listConstraintsPagedCallable;
    private final UnaryCallable<ListPoliciesRequest, ListPoliciesResponse> listPoliciesCallable;
    private final UnaryCallable<ListPoliciesRequest, OrgPolicyClient.ListPoliciesPagedResponse> listPoliciesPagedCallable;
    private final UnaryCallable<GetPolicyRequest, Policy> getPolicyCallable;
    private final UnaryCallable<GetEffectivePolicyRequest, Policy> getEffectivePolicyCallable;
    private final UnaryCallable<CreatePolicyRequest, Policy> createPolicyCallable;
    private final UnaryCallable<UpdatePolicyRequest, Policy> updatePolicyCallable;
    private final UnaryCallable<DeletePolicyRequest, Empty> deletePolicyCallable;
    private final UnaryCallable<CreateCustomConstraintRequest, CustomConstraint> createCustomConstraintCallable;
    private final UnaryCallable<UpdateCustomConstraintRequest, CustomConstraint> updateCustomConstraintCallable;
    private final UnaryCallable<GetCustomConstraintRequest, CustomConstraint> getCustomConstraintCallable;
    private final UnaryCallable<ListCustomConstraintsRequest, ListCustomConstraintsResponse> listCustomConstraintsCallable;
    private final UnaryCallable<ListCustomConstraintsRequest, OrgPolicyClient.ListCustomConstraintsPagedResponse> listCustomConstraintsPagedCallable;
    private final UnaryCallable<DeleteCustomConstraintRequest, Empty> deleteCustomConstraintCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonOrgPolicyStub create(OrgPolicyStubSettings settings) throws IOException {
        return new HttpJsonOrgPolicyStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonOrgPolicyStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonOrgPolicyStub(OrgPolicyStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonOrgPolicyStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonOrgPolicyStub(OrgPolicyStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonOrgPolicyStub(OrgPolicyStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonOrgPolicyCallableFactory());
    }

    protected HttpJsonOrgPolicyStub(OrgPolicyStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listConstraintsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listConstraintsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listPoliciesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listPoliciesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getEffectivePolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getEffectivePolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updatePolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updatePolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("policy.name", String.valueOf(request.getPolicy().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deletePolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deletePolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createCustomConstraintTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createCustomConstraintMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateCustomConstraintTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateCustomConstraintMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("custom_constraint.name", String.valueOf(request.getCustomConstraint().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getCustomConstraintTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getCustomConstraintMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listCustomConstraintsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listCustomConstraintsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteCustomConstraintTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteCustomConstraintMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listConstraintsCallable = callableFactory.createUnaryCallable(listConstraintsTransportSettings, settings.listConstraintsSettings(), clientContext);
        this.listConstraintsPagedCallable = callableFactory.createPagedCallable(listConstraintsTransportSettings, settings.listConstraintsSettings(), clientContext);
        this.listPoliciesCallable = callableFactory.createUnaryCallable(listPoliciesTransportSettings, settings.listPoliciesSettings(), clientContext);
        this.listPoliciesPagedCallable = callableFactory.createPagedCallable(listPoliciesTransportSettings, settings.listPoliciesSettings(), clientContext);
        this.getPolicyCallable = callableFactory.createUnaryCallable(getPolicyTransportSettings, settings.getPolicySettings(), clientContext);
        this.getEffectivePolicyCallable = callableFactory.createUnaryCallable(getEffectivePolicyTransportSettings, settings.getEffectivePolicySettings(), clientContext);
        this.createPolicyCallable = callableFactory.createUnaryCallable(createPolicyTransportSettings, settings.createPolicySettings(), clientContext);
        this.updatePolicyCallable = callableFactory.createUnaryCallable(updatePolicyTransportSettings, settings.updatePolicySettings(), clientContext);
        this.deletePolicyCallable = callableFactory.createUnaryCallable(deletePolicyTransportSettings, settings.deletePolicySettings(), clientContext);
        this.createCustomConstraintCallable = callableFactory.createUnaryCallable(createCustomConstraintTransportSettings, settings.createCustomConstraintSettings(), clientContext);
        this.updateCustomConstraintCallable = callableFactory.createUnaryCallable(updateCustomConstraintTransportSettings, settings.updateCustomConstraintSettings(), clientContext);
        this.getCustomConstraintCallable = callableFactory.createUnaryCallable(getCustomConstraintTransportSettings, settings.getCustomConstraintSettings(), clientContext);
        this.listCustomConstraintsCallable = callableFactory.createUnaryCallable(listCustomConstraintsTransportSettings, settings.listCustomConstraintsSettings(), clientContext);
        this.listCustomConstraintsPagedCallable = callableFactory.createPagedCallable(listCustomConstraintsTransportSettings, settings.listCustomConstraintsSettings(), clientContext);
        this.deleteCustomConstraintCallable = callableFactory.createUnaryCallable(deleteCustomConstraintTransportSettings, settings.deleteCustomConstraintSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listConstraintsMethodDescriptor);
        methodDescriptors.add(listPoliciesMethodDescriptor);
        methodDescriptors.add(getPolicyMethodDescriptor);
        methodDescriptors.add(getEffectivePolicyMethodDescriptor);
        methodDescriptors.add(createPolicyMethodDescriptor);
        methodDescriptors.add(updatePolicyMethodDescriptor);
        methodDescriptors.add(deletePolicyMethodDescriptor);
        methodDescriptors.add(createCustomConstraintMethodDescriptor);
        methodDescriptors.add(updateCustomConstraintMethodDescriptor);
        methodDescriptors.add(getCustomConstraintMethodDescriptor);
        methodDescriptors.add(listCustomConstraintsMethodDescriptor);
        methodDescriptors.add(deleteCustomConstraintMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListConstraintsRequest, ListConstraintsResponse> listConstraintsCallable() {
        return this.listConstraintsCallable;
    }

    @Override
    public UnaryCallable<ListConstraintsRequest, OrgPolicyClient.ListConstraintsPagedResponse> listConstraintsPagedCallable() {
        return this.listConstraintsPagedCallable;
    }

    @Override
    public UnaryCallable<ListPoliciesRequest, ListPoliciesResponse> listPoliciesCallable() {
        return this.listPoliciesCallable;
    }

    @Override
    public UnaryCallable<ListPoliciesRequest, OrgPolicyClient.ListPoliciesPagedResponse> listPoliciesPagedCallable() {
        return this.listPoliciesPagedCallable;
    }

    @Override
    public UnaryCallable<GetPolicyRequest, Policy> getPolicyCallable() {
        return this.getPolicyCallable;
    }

    @Override
    public UnaryCallable<GetEffectivePolicyRequest, Policy> getEffectivePolicyCallable() {
        return this.getEffectivePolicyCallable;
    }

    @Override
    public UnaryCallable<CreatePolicyRequest, Policy> createPolicyCallable() {
        return this.createPolicyCallable;
    }

    @Override
    public UnaryCallable<UpdatePolicyRequest, Policy> updatePolicyCallable() {
        return this.updatePolicyCallable;
    }

    @Override
    public UnaryCallable<DeletePolicyRequest, Empty> deletePolicyCallable() {
        return this.deletePolicyCallable;
    }

    @Override
    public UnaryCallable<CreateCustomConstraintRequest, CustomConstraint> createCustomConstraintCallable() {
        return this.createCustomConstraintCallable;
    }

    @Override
    public UnaryCallable<UpdateCustomConstraintRequest, CustomConstraint> updateCustomConstraintCallable() {
        return this.updateCustomConstraintCallable;
    }

    @Override
    public UnaryCallable<GetCustomConstraintRequest, CustomConstraint> getCustomConstraintCallable() {
        return this.getCustomConstraintCallable;
    }

    @Override
    public UnaryCallable<ListCustomConstraintsRequest, ListCustomConstraintsResponse> listCustomConstraintsCallable() {
        return this.listCustomConstraintsCallable;
    }

    @Override
    public UnaryCallable<ListCustomConstraintsRequest, OrgPolicyClient.ListCustomConstraintsPagedResponse> listCustomConstraintsPagedCallable() {
        return this.listCustomConstraintsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteCustomConstraintRequest, Empty> deleteCustomConstraintCallable() {
        return this.deleteCustomConstraintCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

