/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.spi.v1;

import com.google.api.core.AbstractApiService;
import com.google.api.core.ApiClock;
import com.google.api.core.ApiService;
import com.google.api.core.CurrentMillisClock;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.core.Distribution;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.InstantiatingExecutorProvider;
import com.google.cloud.pubsub.spi.v1.MessageReceiver;
import com.google.cloud.pubsub.spi.v1.PollingSubscriberConnection;
import com.google.cloud.pubsub.spi.v1.StreamingSubscriberConnection;
import com.google.cloud.pubsub.spi.v1.SubscriptionAdminSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.pubsub.v1.SubscriptionName;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

public class Subscriber
extends AbstractApiService {
    private static final int THREADS_PER_CHANNEL = 5;
    @VisibleForTesting
    static final int CHANNELS_PER_CORE = 10;
    private static final int MAX_INBOUND_MESSAGE_SIZE = 0x1400000;
    private static final int INITIAL_ACK_DEADLINE_SECONDS = 10;
    private static final int MAX_ACK_DEADLINE_SECONDS = 600;
    static final int MIN_ACK_DEADLINE_SECONDS = 10;
    private static final Duration ACK_DEADLINE_UPDATE_PERIOD = Duration.ofMinutes((long)1L);
    private static final double PERCENTILE_FOR_ACK_DEADLINE_UPDATES = 99.9;
    private static final Logger logger = Logger.getLogger(Subscriber.class.getName());
    private final SubscriptionName subscriptionName;
    private final String cachedSubscriptionNameString;
    private final FlowControlSettings flowControlSettings;
    private final Duration ackExpirationPadding;
    private final Duration maxAckExtensionPeriod;
    private final ScheduledExecutorService executor;
    @Nullable
    private final ScheduledExecutorService alarmsExecutor;
    private final Distribution ackLatencyDistribution = new Distribution(601);
    private final int numChannels;
    private final FlowController flowController;
    private final ChannelProvider channelProvider;
    private final List<ManagedChannel> channels;
    private final MessageReceiver receiver;
    private final List<StreamingSubscriberConnection> streamingSubscriberConnections;
    private final List<PollingSubscriberConnection> pollingSubscriberConnections;
    private final ApiClock clock;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private ScheduledFuture<?> ackDeadlineUpdater;
    private int streamAckDeadlineSeconds;

    private Subscriber(Builder builder) {
        this.receiver = builder.receiver;
        this.flowControlSettings = builder.flowControlSettings;
        this.subscriptionName = builder.subscriptionName;
        this.cachedSubscriptionNameString = this.subscriptionName.toString();
        this.ackExpirationPadding = builder.ackExpirationPadding;
        this.maxAckExtensionPeriod = builder.maxAckExtensionPeriod;
        long streamAckDeadlineMillis = this.ackExpirationPadding.toMillis();
        this.streamAckDeadlineSeconds = Math.max(10, Ints.saturatedCast((long)TimeUnit.MILLISECONDS.toSeconds(streamAckDeadlineMillis)));
        this.clock = builder.clock.isPresent() ? (ApiClock)builder.clock.get() : CurrentMillisClock.getDefaultClock();
        this.flowController = new FlowController(builder.flowControlSettings.toBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.ThrowException).build());
        this.executor = builder.executorProvider.getExecutor();
        if (builder.executorProvider.shouldAutoClose()) {
            this.closeables.add(new AutoCloseable(){

                @Override
                public void close() throws IOException {
                    Subscriber.this.executor.shutdown();
                }
            });
        }
        if (builder.alarmsExecutorProvider != null) {
            this.alarmsExecutor = builder.alarmsExecutorProvider.getExecutor();
            if (builder.alarmsExecutorProvider.shouldAutoClose()) {
                this.closeables.add(new AutoCloseable(){

                    @Override
                    public void close() throws IOException {
                        Subscriber.this.alarmsExecutor.shutdown();
                    }
                });
            }
        } else {
            this.alarmsExecutor = null;
        }
        this.channelProvider = builder.channelProvider;
        this.numChannels = Math.max(1, Runtime.getRuntime().availableProcessors()) * 10;
        this.channels = new ArrayList<ManagedChannel>(this.numChannels);
        this.streamingSubscriberConnections = new ArrayList<StreamingSubscriberConnection>(this.numChannels);
        this.pollingSubscriberConnections = new ArrayList<PollingSubscriberConnection>(this.numChannels);
    }

    public static Builder defaultBuilder(SubscriptionName subscription, MessageReceiver receiver) {
        return new Builder(subscription, receiver);
    }

    public SubscriptionName getSubscriptionName() {
        return this.subscriptionName;
    }

    public Duration getAckExpirationPadding() {
        return this.ackExpirationPadding;
    }

    public FlowControlSettings getFlowControlSettings() {
        return this.flowControlSettings;
    }

    public ApiService startAsync() {
        return super.startAsync();
    }

    protected void doStart() {
        logger.log(Level.FINE, "Starting subscriber group.");
        try {
            for (int i = 0; i < this.numChannels; ++i) {
                final ManagedChannel channel = this.channelProvider.needsExecutor() ? this.channelProvider.getChannel((Executor)this.executor) : this.channelProvider.getChannel();
                this.channels.add(channel);
                if (!this.channelProvider.shouldAutoClose()) continue;
                this.closeables.add(new AutoCloseable(){

                    @Override
                    public void close() {
                        channel.shutdown();
                    }
                });
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.startPollingConnections();
        this.notifyStarted();
    }

    protected void doStop() {
        this.stopAllStreamingConnections();
        this.stopAllPollingConnections();
        try {
            for (AutoCloseable closeable : this.closeables) {
                closeable.close();
            }
            this.notifyStopped();
        }
        catch (Exception e) {
            this.notifyFailed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startStreamingConnections() {
        List<StreamingSubscriberConnection> list = this.streamingSubscriberConnections;
        synchronized (list) {
            for (int i = 0; i < this.numChannels; ++i) {
                this.streamingSubscriberConnections.add(new StreamingSubscriberConnection(this.cachedSubscriptionNameString, this.receiver, this.ackExpirationPadding, this.maxAckExtensionPeriod, this.streamAckDeadlineSeconds, this.ackLatencyDistribution, (Channel)this.channels.get(i), this.flowController, this.executor, this.alarmsExecutor, this.clock));
            }
            this.startConnections(this.streamingSubscriberConnections, new ApiService.Listener(){

                public void failed(ApiService.State from, Throwable failure) {
                    Subscriber.this.stopAllStreamingConnections();
                    if (failure instanceof StatusRuntimeException && ((StatusRuntimeException)failure).getStatus().getCode() == Status.Code.UNIMPLEMENTED) {
                        logger.info("Unable to open streaming connections, falling back to polling.");
                        Subscriber.this.startPollingConnections();
                        return;
                    }
                    Subscriber.this.notifyFailed(failure);
                }
            });
        }
        this.ackDeadlineUpdater = this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                long ackLatency = Subscriber.this.ackLatencyDistribution.getNthPercentile(99.9);
                if (ackLatency > 0L) {
                    long ackExpirationPaddingMillis = Subscriber.this.ackExpirationPadding.toMillis();
                    int possibleStreamAckDeadlineSeconds = Math.max(10, Ints.saturatedCast((long)Math.max(ackLatency, TimeUnit.MILLISECONDS.toSeconds(ackExpirationPaddingMillis))));
                    if (Subscriber.this.streamAckDeadlineSeconds != possibleStreamAckDeadlineSeconds) {
                        Subscriber.this.streamAckDeadlineSeconds = possibleStreamAckDeadlineSeconds;
                        logger.log(Level.FINER, "Updating stream deadline to {0} seconds.", Subscriber.this.streamAckDeadlineSeconds);
                        for (StreamingSubscriberConnection subscriberConnection : Subscriber.this.streamingSubscriberConnections) {
                            subscriberConnection.updateStreamAckDeadline(Subscriber.this.streamAckDeadlineSeconds);
                        }
                    }
                }
            }
        }, ACK_DEADLINE_UPDATE_PERIOD.toMillis(), ACK_DEADLINE_UPDATE_PERIOD.toMillis(), TimeUnit.MILLISECONDS);
    }

    private void stopAllStreamingConnections() {
        this.stopConnections(this.streamingSubscriberConnections);
        if (this.ackDeadlineUpdater != null) {
            this.ackDeadlineUpdater.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startPollingConnections() {
        List<PollingSubscriberConnection> list = this.pollingSubscriberConnections;
        synchronized (list) {
            for (int i = 0; i < this.numChannels; ++i) {
                this.pollingSubscriberConnections.add(new PollingSubscriberConnection(this.cachedSubscriptionNameString, this.receiver, this.ackExpirationPadding, this.maxAckExtensionPeriod, this.ackLatencyDistribution, (Channel)this.channels.get(i), this.flowController, this.flowControlSettings.getMaxOutstandingElementCount(), this.executor, this.alarmsExecutor, this.clock));
            }
            this.startConnections(this.pollingSubscriberConnections, new ApiService.Listener(){

                public void failed(ApiService.State from, Throwable failure) {
                    block2: {
                        Subscriber.this.stopAllPollingConnections();
                        try {
                            Subscriber.this.notifyFailed(failure);
                        }
                        catch (IllegalStateException e) {
                            if (!Subscriber.this.isRunning()) break block2;
                            throw e;
                        }
                    }
                }
            });
        }
    }

    private void stopAllPollingConnections() {
        this.stopConnections(this.pollingSubscriberConnections);
    }

    private void startConnections(List<? extends ApiService> connections, final ApiService.Listener connectionsListener) {
        final CountDownLatch subscribersStarting = new CountDownLatch(this.numChannels);
        for (final ApiService apiService : connections) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    apiService.addListener(connectionsListener, (Executor)Subscriber.this.executor);
                    try {
                        apiService.startAsync().awaitRunning();
                    }
                    finally {
                        subscribersStarting.countDown();
                    }
                }
            });
        }
        try {
            subscribersStarting.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopConnections(List<? extends ApiService> connections) {
        ArrayList<? extends ApiService> liveConnections;
        List<? extends ApiService> list = connections;
        synchronized (list) {
            liveConnections = new ArrayList<ApiService>(connections);
            connections.clear();
        }
        final CountDownLatch connectionsStopping = new CountDownLatch(liveConnections.size());
        for (final ApiService apiService : liveConnections) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        apiService.stopAsync().awaitTerminated();
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    connectionsStopping.countDown();
                }
            });
        }
        try {
            connectionsStopping.await();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public static final class Builder {
        private static final Duration MIN_ACK_EXPIRATION_PADDING = Duration.ofMillis((long)100L);
        private static final Duration DEFAULT_ACK_EXPIRATION_PADDING = Duration.ofMillis((long)500L);
        private static final Duration DEFAULT_MAX_ACK_EXTENSION_PERIOD = Duration.ofMinutes((long)60L);
        static final ExecutorProvider DEFAULT_EXECUTOR_PROVIDER = InstantiatingExecutorProvider.newBuilder().setExecutorThreadCount(50 * Runtime.getRuntime().availableProcessors()).build();
        SubscriptionName subscriptionName;
        MessageReceiver receiver;
        Duration ackExpirationPadding = DEFAULT_ACK_EXPIRATION_PADDING;
        Duration maxAckExtensionPeriod = DEFAULT_MAX_ACK_EXTENSION_PERIOD;
        FlowControlSettings flowControlSettings = FlowControlSettings.getDefaultInstance();
        ExecutorProvider executorProvider = DEFAULT_EXECUTOR_PROVIDER;
        @Nullable
        ExecutorProvider alarmsExecutorProvider;
        ChannelProvider channelProvider = SubscriptionAdminSettings.defaultChannelProviderBuilder().setMaxInboundMessageSize(Integer.valueOf(0x1400000)).build();
        Optional<ApiClock> clock = Optional.absent();

        Builder(SubscriptionName subscriptionName, MessageReceiver receiver) {
            this.subscriptionName = subscriptionName;
            this.receiver = receiver;
        }

        public Builder setChannelProvider(ChannelProvider channelProvider) {
            this.channelProvider = (ChannelProvider)Preconditions.checkNotNull((Object)channelProvider);
            return this;
        }

        public Builder setFlowControlSettings(FlowControlSettings flowControlSettings) {
            this.flowControlSettings = (FlowControlSettings)Preconditions.checkNotNull((Object)flowControlSettings);
            return this;
        }

        public Builder setAckExpirationPadding(Duration ackExpirationPadding) {
            Preconditions.checkArgument((ackExpirationPadding.compareTo(MIN_ACK_EXPIRATION_PADDING) >= 0 ? 1 : 0) != 0);
            this.ackExpirationPadding = ackExpirationPadding;
            return this;
        }

        public Builder setMaxAckExtensionPeriod(Duration maxAckExtensionPeriod) {
            Preconditions.checkArgument((maxAckExtensionPeriod.toMillis() >= 0L ? 1 : 0) != 0);
            this.maxAckExtensionPeriod = maxAckExtensionPeriod;
            return this;
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = (ExecutorProvider)Preconditions.checkNotNull((Object)executorProvider);
            return this;
        }

        public Builder setLeaseAlarmsExecutorProvider(ExecutorProvider executorProvider) {
            this.alarmsExecutorProvider = (ExecutorProvider)Preconditions.checkNotNull((Object)executorProvider);
            return this;
        }

        Builder setClock(ApiClock clock) {
            this.clock = Optional.of((Object)clock);
            return this;
        }

        public Subscriber build() {
            return new Subscriber(this);
        }
    }
}

