/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.grpc.ChannelAndExecutor;
import com.google.api.gax.grpc.ClientContext;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.auth.Credentials;
import com.google.cloud.pubsub.v1.PagedResponseWrappers;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.pubsub.v1.DeleteTopicRequest;
import com.google.pubsub.v1.GetTopicRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicsRequest;
import com.google.pubsub.v1.ListTopicsResponse;
import com.google.pubsub.v1.ProjectName;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.Topic;
import com.google.pubsub.v1.TopicName;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

@BetaApi
public class TopicAdminClient
implements AutoCloseable {
    private final TopicAdminSettings settings;
    private final ScheduledExecutorService executor;
    private final ManagedChannel channel;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final UnaryCallable<Topic, Topic> createTopicCallable;
    private final UnaryCallable<PublishRequest, PublishResponse> publishCallable;
    private final UnaryCallable<GetTopicRequest, Topic> getTopicCallable;
    private final UnaryCallable<ListTopicsRequest, ListTopicsResponse> listTopicsCallable;
    private final UnaryCallable<ListTopicsRequest, PagedResponseWrappers.ListTopicsPagedResponse> listTopicsPagedCallable;
    private final UnaryCallable<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> listTopicSubscriptionsCallable;
    private final UnaryCallable<ListTopicSubscriptionsRequest, PagedResponseWrappers.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsPagedCallable;
    private final UnaryCallable<DeleteTopicRequest, Empty> deleteTopicCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;

    public static final TopicAdminClient create() throws IOException {
        return TopicAdminClient.create(TopicAdminSettings.defaultBuilder().build());
    }

    public static final TopicAdminClient create(TopicAdminSettings settings) throws IOException {
        return new TopicAdminClient(settings);
    }

    protected TopicAdminClient(TopicAdminSettings settings) throws IOException {
        this.settings = settings;
        ChannelAndExecutor channelAndExecutor = settings.getChannelAndExecutor();
        this.executor = channelAndExecutor.getExecutor();
        this.channel = channelAndExecutor.getChannel();
        Credentials credentials = settings.getCredentialsProvider().getCredentials();
        ClientContext clientContext = ClientContext.newBuilder().setExecutor(this.executor).setChannel((Channel)this.channel).setCredentials(credentials).build();
        this.createTopicCallable = UnaryCallable.create(settings.createTopicSettings(), (ClientContext)clientContext);
        this.publishCallable = UnaryCallable.create(settings.publishSettings(), (ClientContext)clientContext);
        this.getTopicCallable = UnaryCallable.create(settings.getTopicSettings(), (ClientContext)clientContext);
        this.listTopicsCallable = UnaryCallable.create(settings.listTopicsSettings(), (ClientContext)clientContext);
        this.listTopicsPagedCallable = UnaryCallable.createPagedVariant(settings.listTopicsSettings(), (ClientContext)clientContext);
        this.listTopicSubscriptionsCallable = UnaryCallable.create(settings.listTopicSubscriptionsSettings(), (ClientContext)clientContext);
        this.listTopicSubscriptionsPagedCallable = UnaryCallable.createPagedVariant(settings.listTopicSubscriptionsSettings(), (ClientContext)clientContext);
        this.deleteTopicCallable = UnaryCallable.create(settings.deleteTopicSettings(), (ClientContext)clientContext);
        this.setIamPolicyCallable = UnaryCallable.create(settings.setIamPolicySettings(), (ClientContext)clientContext);
        this.getIamPolicyCallable = UnaryCallable.create(settings.getIamPolicySettings(), (ClientContext)clientContext);
        this.testIamPermissionsCallable = UnaryCallable.create(settings.testIamPermissionsSettings(), (ClientContext)clientContext);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    TopicAdminClient.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    TopicAdminClient.this.executor.shutdown();
                }
            });
        }
    }

    public final TopicAdminSettings getSettings() {
        return this.settings;
    }

    public final Topic createTopic(TopicName name) {
        Topic request = Topic.newBuilder().setNameWithTopicName(name).build();
        return this.createTopic(request);
    }

    private final Topic createTopic(Topic request) {
        return (Topic)this.createTopicCallable().call((Object)request);
    }

    public final UnaryCallable<Topic, Topic> createTopicCallable() {
        return this.createTopicCallable;
    }

    final PublishResponse publish(TopicName topic, List<PubsubMessage> messages) {
        PublishRequest request = PublishRequest.newBuilder().setTopicWithTopicName(topic).addAllMessages(messages).build();
        return this.publish(request);
    }

    final PublishResponse publish(PublishRequest request) {
        return (PublishResponse)this.publishCallable().call((Object)request);
    }

    final UnaryCallable<PublishRequest, PublishResponse> publishCallable() {
        return this.publishCallable;
    }

    public final Topic getTopic(TopicName topic) {
        GetTopicRequest request = GetTopicRequest.newBuilder().setTopicWithTopicName(topic).build();
        return this.getTopic(request);
    }

    private final Topic getTopic(GetTopicRequest request) {
        return (Topic)this.getTopicCallable().call((Object)request);
    }

    public final UnaryCallable<GetTopicRequest, Topic> getTopicCallable() {
        return this.getTopicCallable;
    }

    public final PagedResponseWrappers.ListTopicsPagedResponse listTopics(ProjectName project) {
        ListTopicsRequest request = ListTopicsRequest.newBuilder().setProjectWithProjectName(project).build();
        return this.listTopics(request);
    }

    public final PagedResponseWrappers.ListTopicsPagedResponse listTopics(ListTopicsRequest request) {
        return (PagedResponseWrappers.ListTopicsPagedResponse)((Object)this.listTopicsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTopicsRequest, PagedResponseWrappers.ListTopicsPagedResponse> listTopicsPagedCallable() {
        return this.listTopicsPagedCallable;
    }

    public final UnaryCallable<ListTopicsRequest, ListTopicsResponse> listTopicsCallable() {
        return this.listTopicsCallable;
    }

    public final PagedResponseWrappers.ListTopicSubscriptionsPagedResponse listTopicSubscriptions(TopicName topic) {
        ListTopicSubscriptionsRequest request = ListTopicSubscriptionsRequest.newBuilder().setTopicWithTopicName(topic).build();
        return this.listTopicSubscriptions(request);
    }

    public final PagedResponseWrappers.ListTopicSubscriptionsPagedResponse listTopicSubscriptions(ListTopicSubscriptionsRequest request) {
        return (PagedResponseWrappers.ListTopicSubscriptionsPagedResponse)((Object)this.listTopicSubscriptionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTopicSubscriptionsRequest, PagedResponseWrappers.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsPagedCallable() {
        return this.listTopicSubscriptionsPagedCallable;
    }

    public final UnaryCallable<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> listTopicSubscriptionsCallable() {
        return this.listTopicSubscriptionsCallable;
    }

    public final void deleteTopic(TopicName topic) {
        DeleteTopicRequest request = DeleteTopicRequest.newBuilder().setTopicWithTopicName(topic).build();
        this.deleteTopic(request);
    }

    private final void deleteTopic(DeleteTopicRequest request) {
        this.deleteTopicCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTopicRequest, Empty> deleteTopicCallable() {
        return this.deleteTopicCallable;
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    private final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

