/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.spi.v1;

import com.google.api.gax.core.PagedListResponse;
import com.google.api.gax.grpc.ApiCallable;
import com.google.api.gax.protobuf.PathTemplate;
import com.google.cloud.pubsub.spi.v1.PublisherSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.pubsub.v1.DeleteTopicRequest;
import com.google.pubsub.v1.GetTopicRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicsRequest;
import com.google.pubsub.v1.ListTopicsResponse;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.Topic;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

public class PublisherApi
implements AutoCloseable {
    private final PublisherSettings settings;
    private final ManagedChannel channel;
    private final ScheduledExecutorService executor;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final ApiCallable<Topic, Topic> createTopicCallable;
    private final ApiCallable<PublishRequest, PublishResponse> publishCallable;
    private final ApiCallable<GetTopicRequest, Topic> getTopicCallable;
    private final ApiCallable<ListTopicsRequest, ListTopicsResponse> listTopicsCallable;
    private final ApiCallable<ListTopicsRequest, PagedListResponse<ListTopicsRequest, ListTopicsResponse, Topic>> listTopicsPagedCallable;
    private final ApiCallable<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> listTopicSubscriptionsCallable;
    private final ApiCallable<ListTopicSubscriptionsRequest, PagedListResponse<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String>> listTopicSubscriptionsPagedCallable;
    private final ApiCallable<DeleteTopicRequest, Empty> deleteTopicCallable;
    private final ApiCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final ApiCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final ApiCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private static final PathTemplate PROJECT_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}");
    private static final PathTemplate TOPIC_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/topics/{topic}");

    public final PublisherSettings getSettings() {
        return this.settings;
    }

    public static final String formatProjectName(String project) {
        return PROJECT_PATH_TEMPLATE.instantiate(new String[]{"project", project});
    }

    public static final String formatTopicName(String project, String topic) {
        return TOPIC_PATH_TEMPLATE.instantiate(new String[]{"project", project, "topic", topic});
    }

    public static final String parseProjectFromProjectName(String projectName) {
        return PROJECT_PATH_TEMPLATE.parse(projectName).get((Object)"project");
    }

    public static final String parseProjectFromTopicName(String topicName) {
        return TOPIC_PATH_TEMPLATE.parse(topicName).get((Object)"project");
    }

    public static final String parseTopicFromTopicName(String topicName) {
        return TOPIC_PATH_TEMPLATE.parse(topicName).get((Object)"topic");
    }

    public static final PublisherApi create() throws IOException {
        return PublisherApi.create(PublisherSettings.defaultBuilder().build());
    }

    public static final PublisherApi create(PublisherSettings settings) throws IOException {
        return new PublisherApi(settings);
    }

    protected PublisherApi(PublisherSettings settings) throws IOException {
        this.settings = settings;
        this.executor = settings.getExecutorProvider().getOrBuildExecutor();
        this.channel = settings.getChannelProvider().getOrBuildChannel((Executor)this.executor);
        this.createTopicCallable = ApiCallable.create(settings.createTopicSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.publishCallable = ApiCallable.create(settings.publishSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.publishSettings().getBundlerFactory() != null) {
            this.closeables.add((AutoCloseable)settings.publishSettings().getBundlerFactory());
        }
        this.getTopicCallable = ApiCallable.create(settings.getTopicSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listTopicsCallable = ApiCallable.create(settings.listTopicsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listTopicsPagedCallable = ApiCallable.createPagedVariant(settings.listTopicsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listTopicSubscriptionsCallable = ApiCallable.create(settings.listTopicSubscriptionsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listTopicSubscriptionsPagedCallable = ApiCallable.createPagedVariant(settings.listTopicSubscriptionsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.deleteTopicCallable = ApiCallable.create(settings.deleteTopicSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.setIamPolicyCallable = ApiCallable.create(settings.setIamPolicySettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.getIamPolicyCallable = ApiCallable.create(settings.getIamPolicySettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.testIamPermissionsCallable = ApiCallable.create(settings.testIamPermissionsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    PublisherApi.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    PublisherApi.this.executor.shutdown();
                }
            });
        }
    }

    public final Topic createTopic(String name) {
        TOPIC_PATH_TEMPLATE.validate(name, "createTopic");
        Topic request = Topic.newBuilder().setName(name).build();
        return this.createTopic(request);
    }

    private final Topic createTopic(Topic request) {
        return (Topic)this.createTopicCallable().call((Object)request);
    }

    public final ApiCallable<Topic, Topic> createTopicCallable() {
        return this.createTopicCallable;
    }

    public final PublishResponse publish(String topic, List<PubsubMessage> messages) {
        TOPIC_PATH_TEMPLATE.validate(topic, "publish");
        PublishRequest request = PublishRequest.newBuilder().setTopic(topic).addAllMessages(messages).build();
        return this.publish(request);
    }

    public final PublishResponse publish(PublishRequest request) {
        return (PublishResponse)this.publishCallable().call((Object)request);
    }

    public final ApiCallable<PublishRequest, PublishResponse> publishCallable() {
        return this.publishCallable;
    }

    public final Topic getTopic(String topic) {
        TOPIC_PATH_TEMPLATE.validate(topic, "getTopic");
        GetTopicRequest request = GetTopicRequest.newBuilder().setTopic(topic).build();
        return this.getTopic(request);
    }

    private final Topic getTopic(GetTopicRequest request) {
        return (Topic)this.getTopicCallable().call((Object)request);
    }

    public final ApiCallable<GetTopicRequest, Topic> getTopicCallable() {
        return this.getTopicCallable;
    }

    public final PagedListResponse<ListTopicsRequest, ListTopicsResponse, Topic> listTopics(String project) {
        PROJECT_PATH_TEMPLATE.validate(project, "listTopics");
        ListTopicsRequest request = ListTopicsRequest.newBuilder().setProject(project).build();
        return this.listTopics(request);
    }

    public final PagedListResponse<ListTopicsRequest, ListTopicsResponse, Topic> listTopics(ListTopicsRequest request) {
        return (PagedListResponse)this.listTopicsPagedCallable().call((Object)request);
    }

    public final ApiCallable<ListTopicsRequest, PagedListResponse<ListTopicsRequest, ListTopicsResponse, Topic>> listTopicsPagedCallable() {
        return this.listTopicsPagedCallable;
    }

    public final ApiCallable<ListTopicsRequest, ListTopicsResponse> listTopicsCallable() {
        return this.listTopicsCallable;
    }

    public final PagedListResponse<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String> listTopicSubscriptions(String topic) {
        TOPIC_PATH_TEMPLATE.validate(topic, "listTopicSubscriptions");
        ListTopicSubscriptionsRequest request = ListTopicSubscriptionsRequest.newBuilder().setTopic(topic).build();
        return this.listTopicSubscriptions(request);
    }

    public final PagedListResponse<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String> listTopicSubscriptions(ListTopicSubscriptionsRequest request) {
        return (PagedListResponse)this.listTopicSubscriptionsPagedCallable().call((Object)request);
    }

    public final ApiCallable<ListTopicSubscriptionsRequest, PagedListResponse<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String>> listTopicSubscriptionsPagedCallable() {
        return this.listTopicSubscriptionsPagedCallable;
    }

    public final ApiCallable<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> listTopicSubscriptionsCallable() {
        return this.listTopicSubscriptionsCallable;
    }

    public final void deleteTopic(String topic) {
        TOPIC_PATH_TEMPLATE.validate(topic, "deleteTopic");
        DeleteTopicRequest request = DeleteTopicRequest.newBuilder().setTopic(topic).build();
        this.deleteTopic(request);
    }

    private final void deleteTopic(DeleteTopicRequest request) {
        this.deleteTopicCallable().call((Object)request);
    }

    public final ApiCallable<DeleteTopicRequest, Empty> deleteTopicCallable() {
        return this.deleteTopicCallable;
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        TOPIC_PATH_TEMPLATE.validate(resource, "setIamPolicy");
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final ApiCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    public final Policy getIamPolicy(String resource) {
        TOPIC_PATH_TEMPLATE.validate(resource, "getIamPolicy");
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    private final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final ApiCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TOPIC_PATH_TEMPLATE.validate(resource, "testIamPermissions");
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final ApiCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

