/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.AbstractApiService;
import com.google.api.core.ApiClock;
import com.google.api.core.ApiService;
import com.google.api.core.BetaApi;
import com.google.api.core.CurrentMillisClock;
import com.google.api.core.InternalApi;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.Distribution;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.NoHeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.pubsub.v1.MessageDispatcher;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsub.v1.StreamingSubscriberConnection;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.SubscriberGrpc;
import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.auth.MoreCallCredentials;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

public class Subscriber
extends AbstractApiService {
    private static final int THREADS_PER_CHANNEL = 5;
    @InternalApi
    static final int CHANNELS_PER_CORE = 1;
    private static final int MAX_INBOUND_MESSAGE_SIZE = 0x1400000;
    @InternalApi
    static final int MAX_ACK_DEADLINE_SECONDS = 600;
    @InternalApi
    static final int MIN_ACK_DEADLINE_SECONDS = 10;
    private static final ScheduledExecutorService SHARED_SYSTEM_EXECUTOR = InstantiatingExecutorProvider.newBuilder().setExecutorThreadCount(6).build().getExecutor();
    private static final Logger logger = Logger.getLogger(Subscriber.class.getName());
    private final String subscriptionName;
    private final FlowControlSettings flowControlSettings;
    private final Duration ackExpirationPadding;
    private final Duration maxAckExtensionPeriod;
    private final ScheduledExecutorService executor;
    @Nullable
    private final ScheduledExecutorService alarmsExecutor;
    private final Distribution ackLatencyDistribution = new Distribution(601);
    private final int numChannels;
    private final FlowController flowController;
    private final TransportChannelProvider channelProvider;
    private final CredentialsProvider credentialsProvider;
    private final List<Channel> channels;
    private final MessageReceiver receiver;
    private final List<StreamingSubscriberConnection> streamingSubscriberConnections;
    private final Deque<MessageDispatcher.OutstandingMessageBatch> outstandingMessageBatches = new LinkedList<MessageDispatcher.OutstandingMessageBatch>();
    private final ApiClock clock;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private ScheduledFuture<?> ackDeadlineUpdater;

    private Subscriber(Builder builder) {
        TransportChannelProvider channelProvider;
        this.receiver = builder.receiver;
        this.flowControlSettings = builder.flowControlSettings;
        this.subscriptionName = builder.subscriptionName;
        Preconditions.checkArgument((builder.ackExpirationPadding.compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0, (Object)"padding must be positive");
        Preconditions.checkArgument((builder.ackExpirationPadding.compareTo(Duration.ofSeconds((long)10L)) < 0 ? 1 : 0) != 0, (String)"padding must be less than %s seconds", (int)10);
        this.ackExpirationPadding = builder.ackExpirationPadding;
        this.maxAckExtensionPeriod = builder.maxAckExtensionPeriod;
        this.clock = builder.clock.isPresent() ? (ApiClock)builder.clock.get() : CurrentMillisClock.getDefaultClock();
        this.flowController = new FlowController(builder.flowControlSettings.toBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.ThrowException).build());
        this.executor = builder.executorProvider.getExecutor();
        if (builder.executorProvider.shouldAutoClose()) {
            this.closeables.add(new AutoCloseable(){

                @Override
                public void close() throws IOException {
                    Subscriber.this.executor.shutdown();
                }
            });
        }
        this.alarmsExecutor = builder.systemExecutorProvider.getExecutor();
        if (builder.systemExecutorProvider.shouldAutoClose()) {
            this.closeables.add(new AutoCloseable(){

                @Override
                public void close() throws IOException {
                    Subscriber.this.alarmsExecutor.shutdown();
                }
            });
        }
        if ((channelProvider = builder.channelProvider).needsExecutor()) {
            channelProvider = channelProvider.withExecutor(this.executor);
        }
        if (channelProvider.needsHeaders()) {
            ImmutableMap headers = ImmutableMap.builder().putAll(builder.headerProvider.getHeaders()).putAll(builder.internalHeaderProvider.getHeaders()).build();
            channelProvider = channelProvider.withHeaders((Map)headers);
        }
        if (channelProvider.needsEndpoint()) {
            channelProvider = channelProvider.withEndpoint(SubscriptionAdminSettings.getDefaultEndpoint());
        }
        this.channelProvider = channelProvider;
        this.credentialsProvider = builder.credentialsProvider;
        this.numChannels = builder.parallelPullCount;
        this.channels = new ArrayList<Channel>(this.numChannels);
        this.streamingSubscriberConnections = new ArrayList<StreamingSubscriberConnection>(this.numChannels);
    }

    public static Builder newBuilder(ProjectSubscriptionName subscription, MessageReceiver receiver) {
        return Subscriber.newBuilder(subscription.toString(), receiver);
    }

    public static Builder newBuilder(String subscription, MessageReceiver receiver) {
        return new Builder(subscription, receiver);
    }

    public ProjectSubscriptionName getSubscriptionName() {
        return ProjectSubscriptionName.parse((String)this.subscriptionName);
    }

    public String getSubscriptionNameString() {
        return this.subscriptionName;
    }

    @InternalApi
    Duration getAckExpirationPadding() {
        return this.ackExpirationPadding;
    }

    public FlowControlSettings getFlowControlSettings() {
        return this.flowControlSettings;
    }

    public ApiService startAsync() {
        return super.startAsync();
    }

    protected void doStart() {
        logger.log(Level.FINE, "Starting subscriber group.");
        try {
            for (int i = 0; i < this.numChannels; ++i) {
                GrpcTransportChannel transportChannel = (GrpcTransportChannel)this.channelProvider.getTransportChannel();
                this.channels.add(transportChannel.getChannel());
                if (!this.channelProvider.shouldAutoClose()) continue;
                this.closeables.add((AutoCloseable)transportChannel);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Subscriber.this.startStreamingConnections();
                    Subscriber.this.notifyStarted();
                }
                catch (Throwable t) {
                    Subscriber.this.notifyFailed(t);
                }
            }
        }).start();
    }

    protected void doStop() {
        this.stopAllStreamingConnections();
        try {
            for (AutoCloseable closeable : this.closeables) {
                closeable.close();
            }
            this.notifyStopped();
        }
        catch (Exception e) {
            this.notifyFailed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startStreamingConnections() throws IOException {
        List<StreamingSubscriberConnection> list = this.streamingSubscriberConnections;
        synchronized (list) {
            Credentials credentials = this.credentialsProvider.getCredentials();
            CallCredentials callCredentials = credentials == null ? null : MoreCallCredentials.from((Credentials)credentials);
            for (Channel channel : this.channels) {
                SubscriberGrpc.SubscriberStub stub = SubscriberGrpc.newStub((Channel)channel);
                if (callCredentials != null) {
                    stub = (SubscriberGrpc.SubscriberStub)stub.withCallCredentials(callCredentials);
                }
                this.streamingSubscriberConnections.add(new StreamingSubscriberConnection(this.subscriptionName, this.receiver, this.ackExpirationPadding, this.maxAckExtensionPeriod, this.ackLatencyDistribution, stub, this.flowController, this.outstandingMessageBatches, this.executor, this.alarmsExecutor, this.clock));
            }
            this.startConnections(this.streamingSubscriberConnections, new ApiService.Listener(){

                public void failed(ApiService.State from, Throwable failure) {
                    block2: {
                        Subscriber.this.stopAllStreamingConnections();
                        try {
                            Subscriber.this.notifyFailed(failure);
                        }
                        catch (IllegalStateException e) {
                            if (!Subscriber.this.isRunning()) break block2;
                            throw e;
                        }
                    }
                }
            });
        }
    }

    private void stopAllStreamingConnections() {
        this.stopConnections(this.streamingSubscriberConnections);
        if (this.ackDeadlineUpdater != null) {
            this.ackDeadlineUpdater.cancel(true);
        }
    }

    private void startConnections(List<? extends ApiService> connections, ApiService.Listener connectionsListener) {
        for (ApiService apiService : connections) {
            apiService.addListener(connectionsListener, (Executor)this.executor);
            apiService.startAsync();
        }
        for (ApiService apiService : connections) {
            apiService.awaitRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopConnections(List<? extends ApiService> connections) {
        ArrayList<? extends ApiService> liveConnections;
        Iterator<? extends ApiService> iterator = connections;
        synchronized (iterator) {
            liveConnections = new ArrayList<ApiService>(connections);
            connections.clear();
        }
        for (ApiService apiService : liveConnections) {
            apiService.stopAsync();
        }
        for (ApiService apiService : liveConnections) {
            try {
                apiService.awaitTerminated();
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    static /* synthetic */ ScheduledExecutorService access$700() {
        return SHARED_SYSTEM_EXECUTOR;
    }

    public static final class Builder {
        private static final Duration MIN_ACK_EXPIRATION_PADDING = Duration.ofMillis((long)100L);
        private static final Duration DEFAULT_ACK_EXPIRATION_PADDING = Duration.ofSeconds((long)5L);
        private static final Duration DEFAULT_MAX_ACK_EXTENSION_PERIOD = Duration.ofMinutes((long)60L);
        private static final long DEFAULT_MEMORY_PERCENTAGE = 20L;
        static final ExecutorProvider DEFAULT_EXECUTOR_PROVIDER = InstantiatingExecutorProvider.newBuilder().setExecutorThreadCount(5 * Runtime.getRuntime().availableProcessors()).build();
        String subscriptionName;
        MessageReceiver receiver;
        Duration ackExpirationPadding = DEFAULT_ACK_EXPIRATION_PADDING;
        Duration maxAckExtensionPeriod = DEFAULT_MAX_ACK_EXTENSION_PERIOD;
        FlowControlSettings flowControlSettings = FlowControlSettings.newBuilder().setMaxOutstandingRequestBytes(Long.valueOf(Runtime.getRuntime().maxMemory() * 20L / 100L)).build();
        ExecutorProvider executorProvider = DEFAULT_EXECUTOR_PROVIDER;
        ExecutorProvider systemExecutorProvider = FixedExecutorProvider.create((ScheduledExecutorService)Subscriber.access$700());
        TransportChannelProvider channelProvider = SubscriptionAdminSettings.defaultGrpcTransportProviderBuilder().setMaxInboundMessageSize(Integer.valueOf(0x1400000)).setKeepAliveTime(Duration.ofMinutes((long)5L)).build();
        HeaderProvider headerProvider = new NoHeaderProvider();
        HeaderProvider internalHeaderProvider = SubscriptionAdminSettings.defaultApiClientHeaderProviderBuilder().build();
        CredentialsProvider credentialsProvider = SubscriptionAdminSettings.defaultCredentialsProviderBuilder().build();
        Optional<ApiClock> clock = Optional.absent();
        int parallelPullCount = Runtime.getRuntime().availableProcessors() * 1;

        Builder(String subscriptionName, MessageReceiver receiver) {
            this.subscriptionName = subscriptionName;
            this.receiver = receiver;
        }

        public Builder setChannelProvider(TransportChannelProvider channelProvider) {
            this.channelProvider = (TransportChannelProvider)Preconditions.checkNotNull((Object)channelProvider);
            return this;
        }

        @BetaApi
        public Builder setHeaderProvider(HeaderProvider headerProvider) {
            this.headerProvider = (HeaderProvider)Preconditions.checkNotNull((Object)headerProvider);
            return this;
        }

        Builder setInternalHeaderProvider(HeaderProvider internalHeaderProvider) {
            this.internalHeaderProvider = (HeaderProvider)Preconditions.checkNotNull((Object)internalHeaderProvider);
            return this;
        }

        public Builder setFlowControlSettings(FlowControlSettings flowControlSettings) {
            this.flowControlSettings = (FlowControlSettings)Preconditions.checkNotNull((Object)flowControlSettings);
            return this;
        }

        @InternalApi
        Builder setAckExpirationPadding(Duration ackExpirationPadding) {
            Preconditions.checkArgument((ackExpirationPadding.compareTo(MIN_ACK_EXPIRATION_PADDING) >= 0 ? 1 : 0) != 0);
            this.ackExpirationPadding = ackExpirationPadding;
            return this;
        }

        public Builder setMaxAckExtensionPeriod(Duration maxAckExtensionPeriod) {
            Preconditions.checkArgument((maxAckExtensionPeriod.toMillis() >= 0L ? 1 : 0) != 0);
            this.maxAckExtensionPeriod = maxAckExtensionPeriod;
            return this;
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = (ExecutorProvider)Preconditions.checkNotNull((Object)executorProvider);
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = (CredentialsProvider)Preconditions.checkNotNull((Object)credentialsProvider);
            return this;
        }

        public Builder setSystemExecutorProvider(ExecutorProvider executorProvider) {
            this.systemExecutorProvider = (ExecutorProvider)Preconditions.checkNotNull((Object)executorProvider);
            return this;
        }

        public Builder setParallelPullCount(int parallelPullCount) {
            this.parallelPullCount = parallelPullCount;
            return this;
        }

        Builder setClock(ApiClock clock) {
            this.clock = Optional.of((Object)clock);
            return this;
        }

        public Subscriber build() {
            return new Subscriber(this);
        }
    }
}

