/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.AbstractApiService;
import com.google.api.core.ApiClock;
import com.google.api.core.ApiService;
import com.google.api.core.BetaApi;
import com.google.api.core.CurrentMillisClock;
import com.google.api.core.InternalApi;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.Distribution;
import com.google.api.gax.core.ExecutorAsBackgroundResource;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.NoHeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsub.v1.StreamingSubscriberConnection;
import com.google.cloud.pubsub.v1.SubscriberInterface;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.cloud.pubsub.v1.stub.GrpcSubscriberStub;
import com.google.cloud.pubsub.v1.stub.SubscriberStub;
import com.google.cloud.pubsub.v1.stub.SubscriberStubSettings;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.PubsubMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

public class Subscriber
extends AbstractApiService
implements SubscriberInterface {
    @InternalApi
    static final Duration DEFAULT_MAX_DURATION_PER_ACK_EXTENSION = Duration.ofMillis((long)0L);
    private static final int THREADS_PER_CHANNEL = 5;
    private static final int MAX_INBOUND_MESSAGE_SIZE = 0x1400000;
    @InternalApi
    static final int MAX_ACK_DEADLINE_SECONDS = 600;
    @InternalApi
    static final int MIN_ACK_DEADLINE_SECONDS = 10;
    private static final Duration ACK_EXPIRATION_PADDING = Duration.ofSeconds((long)5L);
    private static final Logger logger = Logger.getLogger(Subscriber.class.getName());
    private final String subscriptionName;
    private final FlowControlSettings flowControlSettings;
    private final boolean useLegacyFlowControl;
    private final Duration maxAckExtensionPeriod;
    private final Duration maxDurationPerAckExtension;
    private final ExecutorProvider executorProvider;
    @Nullable
    private final ScheduledExecutorService alarmsExecutor;
    private final Distribution ackLatencyDistribution = new Distribution(601);
    private SubscriberStub subStub;
    private final SubscriberStubSettings subStubSettings;
    private final FlowController flowController;
    private final int numPullers;
    private final MessageReceiver receiver;
    private final List<StreamingSubscriberConnection> streamingSubscriberConnections;
    private final ApiClock clock;
    private final List<BackgroundResource> backgroundResources = new ArrayList<BackgroundResource>();

    private Subscriber(Builder builder) {
        TransportChannelProvider channelProvider;
        this.receiver = builder.receiver;
        this.flowControlSettings = builder.flowControlSettings;
        this.useLegacyFlowControl = builder.useLegacyFlowControl;
        this.subscriptionName = builder.subscriptionName;
        this.maxAckExtensionPeriod = builder.maxAckExtensionPeriod;
        this.maxDurationPerAckExtension = builder.maxDurationPerAckExtension;
        this.clock = builder.clock.isPresent() ? (ApiClock)builder.clock.get() : CurrentMillisClock.getDefaultClock();
        this.flowController = new FlowController(builder.flowControlSettings.toBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block).build());
        this.numPullers = builder.parallelPullCount;
        this.executorProvider = builder.executorProvider;
        ExecutorProvider systemExecutorProvider = builder.systemExecutorProvider;
        this.alarmsExecutor = systemExecutorProvider.getExecutor();
        if (systemExecutorProvider.shouldAutoClose()) {
            this.backgroundResources.add((BackgroundResource)new ExecutorAsBackgroundResource((ExecutorService)this.alarmsExecutor));
        }
        if ((channelProvider = builder.channelProvider).acceptsPoolSize()) {
            channelProvider = channelProvider.withPoolSize(this.numPullers);
        }
        try {
            this.subStubSettings = ((SubscriberStubSettings.Builder)((SubscriberStubSettings.Builder)((SubscriberStubSettings.Builder)((SubscriberStubSettings.Builder)((SubscriberStubSettings.Builder)SubscriberStubSettings.newBuilder().setExecutorProvider(systemExecutorProvider)).setCredentialsProvider(builder.credentialsProvider)).setTransportChannelProvider(channelProvider)).setHeaderProvider(builder.headerProvider)).setEndpoint(builder.endpoint)).build();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.streamingSubscriberConnections = new ArrayList<StreamingSubscriberConnection>(this.numPullers);
        this.ackLatencyDistribution.record(10);
    }

    public static Builder newBuilder(ProjectSubscriptionName subscription, MessageReceiver receiver) {
        return Subscriber.newBuilder(subscription.toString(), receiver);
    }

    public static Builder newBuilder(String subscription, MessageReceiver receiver) {
        return new Builder(subscription, receiver);
    }

    public static Integer getDeliveryAttempt(PubsubMessage message) {
        if (!message.containsAttributes("googclient_deliveryattempt")) {
            return null;
        }
        return Integer.parseInt(message.getAttributesOrThrow("googclient_deliveryattempt"));
    }

    public String getSubscriptionNameString() {
        return this.subscriptionName;
    }

    public FlowControlSettings getFlowControlSettings() {
        return this.flowControlSettings;
    }

    public ApiService startAsync() {
        return super.startAsync();
    }

    protected void doStart() {
        logger.log(Level.FINE, "Starting subscriber group.");
        try {
            this.subStub = GrpcSubscriberStub.create(this.subStubSettings);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Subscriber.this.startStreamingConnections();
                    Subscriber.this.notifyStarted();
                }
                catch (Throwable t) {
                    Subscriber.this.notifyFailed(t);
                }
            }
        }).start();
    }

    protected void doStop() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Subscriber.this.runShutdown();
                    Subscriber.this.notifyStopped();
                }
                catch (Exception e) {
                    Subscriber.this.notifyFailed(e);
                }
            }
        }).start();
    }

    private void runShutdown() {
        this.stopAllStreamingConnections();
        this.shutdownBackgroundResources();
        this.subStub.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startStreamingConnections() {
        List<StreamingSubscriberConnection> list = this.streamingSubscriberConnections;
        synchronized (list) {
            for (int i = 0; i < this.numPullers; ++i) {
                ScheduledExecutorService executor = this.executorProvider.getExecutor();
                if (this.executorProvider.shouldAutoClose()) {
                    this.backgroundResources.add((BackgroundResource)new ExecutorAsBackgroundResource((ExecutorService)executor));
                }
                this.streamingSubscriberConnections.add(new StreamingSubscriberConnection(this.subscriptionName, this.receiver, ACK_EXPIRATION_PADDING, this.maxAckExtensionPeriod, this.maxDurationPerAckExtension, this.ackLatencyDistribution, this.subStub, i, this.flowControlSettings, this.useLegacyFlowControl, this.flowController, executor, this.alarmsExecutor, this.clock));
            }
            this.startConnections(this.streamingSubscriberConnections, new ApiService.Listener(){

                public void failed(ApiService.State from, Throwable failure) {
                    block2: {
                        Subscriber.this.runShutdown();
                        try {
                            Subscriber.this.notifyFailed(failure);
                        }
                        catch (IllegalStateException e) {
                            if (!Subscriber.this.isRunning()) break block2;
                            throw e;
                        }
                    }
                }
            });
        }
    }

    private void stopAllStreamingConnections() {
        this.stopConnections(this.streamingSubscriberConnections);
    }

    private void shutdownBackgroundResources() {
        for (BackgroundResource resource : this.backgroundResources) {
            resource.shutdown();
        }
    }

    private void startConnections(List<? extends ApiService> connections, ApiService.Listener connectionsListener) {
        for (ApiService apiService : connections) {
            apiService.addListener(connectionsListener, (Executor)this.alarmsExecutor);
            apiService.startAsync();
        }
        for (ApiService apiService : connections) {
            apiService.awaitRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopConnections(List<? extends ApiService> connections) {
        ArrayList<? extends ApiService> liveConnections;
        Iterator<? extends ApiService> iterator = connections;
        synchronized (iterator) {
            liveConnections = new ArrayList<ApiService>(connections);
            connections.clear();
        }
        for (ApiService apiService : liveConnections) {
            apiService.stopAsync();
        }
        for (ApiService apiService : liveConnections) {
            try {
                apiService.awaitTerminated();
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    public static final class Builder {
        private static final Duration DEFAULT_MAX_ACK_EXTENSION_PERIOD = Duration.ofMinutes((long)60L);
        static final FlowControlSettings DEFAULT_FLOW_CONTROL_SETTINGS = FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Long.valueOf(1000L)).setMaxOutstandingRequestBytes(Long.valueOf(0x6400000L)).build();
        private static final ExecutorProvider DEFAULT_EXECUTOR_PROVIDER = InstantiatingExecutorProvider.newBuilder().setExecutorThreadCount(5).build();
        private static final AtomicInteger SYSTEM_EXECUTOR_COUNTER = new AtomicInteger();
        private String subscriptionName;
        private MessageReceiver receiver;
        private Duration maxAckExtensionPeriod = DEFAULT_MAX_ACK_EXTENSION_PERIOD;
        private Duration maxDurationPerAckExtension = DEFAULT_MAX_DURATION_PER_ACK_EXTENSION;
        private boolean useLegacyFlowControl = false;
        private FlowControlSettings flowControlSettings = DEFAULT_FLOW_CONTROL_SETTINGS;
        private ExecutorProvider executorProvider = DEFAULT_EXECUTOR_PROVIDER;
        private ExecutorProvider systemExecutorProvider = null;
        private TransportChannelProvider channelProvider = SubscriptionAdminSettings.defaultGrpcTransportProviderBuilder().setMaxInboundMessageSize(Integer.valueOf(0x1400000)).setKeepAliveTime(Duration.ofMinutes((long)5L)).build();
        private HeaderProvider headerProvider = new NoHeaderProvider();
        private CredentialsProvider credentialsProvider = SubscriptionAdminSettings.defaultCredentialsProviderBuilder().build();
        private Optional<ApiClock> clock = Optional.absent();
        private int parallelPullCount = 1;
        private String endpoint = SubscriberStubSettings.getDefaultEndpoint();

        Builder(String subscriptionName, MessageReceiver receiver) {
            this.subscriptionName = subscriptionName;
            this.receiver = receiver;
        }

        public Builder setChannelProvider(TransportChannelProvider channelProvider) {
            this.channelProvider = (TransportChannelProvider)Preconditions.checkNotNull((Object)channelProvider);
            return this;
        }

        @BetaApi
        public Builder setHeaderProvider(HeaderProvider headerProvider) {
            this.headerProvider = (HeaderProvider)Preconditions.checkNotNull((Object)headerProvider);
            return this;
        }

        public Builder setFlowControlSettings(FlowControlSettings flowControlSettings) {
            this.flowControlSettings = (FlowControlSettings)Preconditions.checkNotNull((Object)flowControlSettings);
            return this;
        }

        public Builder setUseLegacyFlowControl(boolean value) {
            this.useLegacyFlowControl = value;
            return this;
        }

        public Builder setMaxAckExtensionPeriod(Duration maxAckExtensionPeriod) {
            Preconditions.checkArgument((maxAckExtensionPeriod.toMillis() >= 0L ? 1 : 0) != 0);
            this.maxAckExtensionPeriod = maxAckExtensionPeriod;
            return this;
        }

        public Builder setMaxDurationPerAckExtension(Duration maxDurationPerAckExtension) {
            Preconditions.checkArgument((maxDurationPerAckExtension.toMillis() >= 0L ? 1 : 0) != 0);
            this.maxDurationPerAckExtension = maxDurationPerAckExtension;
            return this;
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = (ExecutorProvider)Preconditions.checkNotNull((Object)executorProvider);
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = (CredentialsProvider)Preconditions.checkNotNull((Object)credentialsProvider);
            return this;
        }

        public Builder setSystemExecutorProvider(ExecutorProvider executorProvider) {
            this.systemExecutorProvider = (ExecutorProvider)Preconditions.checkNotNull((Object)executorProvider);
            return this;
        }

        public Builder setParallelPullCount(int parallelPullCount) {
            this.parallelPullCount = parallelPullCount;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        Builder setClock(ApiClock clock) {
            this.clock = Optional.of((Object)clock);
            return this;
        }

        public static FlowControlSettings getDefaultFlowControlSettings() {
            return DEFAULT_FLOW_CONTROL_SETTINGS;
        }

        public Subscriber build() {
            if (this.systemExecutorProvider == null) {
                ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Subscriber-SE-" + SYSTEM_EXECUTOR_COUNTER.incrementAndGet() + "-%d").build();
                int threadCount = Math.max(6, 2 * this.parallelPullCount);
                final ScheduledExecutorService executor = Executors.newScheduledThreadPool(threadCount, threadFactory);
                this.systemExecutorProvider = new ExecutorProvider(){

                    public boolean shouldAutoClose() {
                        return true;
                    }

                    public ScheduledExecutorService getExecutor() {
                        return executor;
                    }
                };
            }
            return new Subscriber(this);
        }
    }
}

