package com.google.cloud.pubsub.v1;

import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SubscriberStats extends SubscriberStats {

  private final long receivedMessages;

  private final long ackedMessages;

  private final long totalReceivedMessages;

  private final long totalAckedMessages;

  private final SubscriberStats.Stats endToEndLatency;

  private final SubscriberStats.Stats ackLatency;

  private final long numberOfAutoExtendedAckDeadlines;

  private AutoValue_SubscriberStats(
      long receivedMessages,
      long ackedMessages,
      long totalReceivedMessages,
      long totalAckedMessages,
      SubscriberStats.Stats endToEndLatency,
      SubscriberStats.Stats ackLatency,
      long numberOfAutoExtendedAckDeadlines) {
    this.receivedMessages = receivedMessages;
    this.ackedMessages = ackedMessages;
    this.totalReceivedMessages = totalReceivedMessages;
    this.totalAckedMessages = totalAckedMessages;
    this.endToEndLatency = endToEndLatency;
    this.ackLatency = ackLatency;
    this.numberOfAutoExtendedAckDeadlines = numberOfAutoExtendedAckDeadlines;
  }

  @Override
  long getReceivedMessages() {
    return receivedMessages;
  }

  @Override
  long getAckedMessages() {
    return ackedMessages;
  }

  @Override
  long getTotalReceivedMessages() {
    return totalReceivedMessages;
  }

  @Override
  long getTotalAckedMessages() {
    return totalAckedMessages;
  }

  @Override
  SubscriberStats.Stats getEndToEndLatency() {
    return endToEndLatency;
  }

  @Override
  SubscriberStats.Stats getAckLatency() {
    return ackLatency;
  }

  @Override
  long getNumberOfAutoExtendedAckDeadlines() {
    return numberOfAutoExtendedAckDeadlines;
  }

  @Override
  public String toString() {
    return "SubscriberStats{"
        + "receivedMessages=" + receivedMessages + ", "
        + "ackedMessages=" + ackedMessages + ", "
        + "totalReceivedMessages=" + totalReceivedMessages + ", "
        + "totalAckedMessages=" + totalAckedMessages + ", "
        + "endToEndLatency=" + endToEndLatency + ", "
        + "ackLatency=" + ackLatency + ", "
        + "numberOfAutoExtendedAckDeadlines=" + numberOfAutoExtendedAckDeadlines
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SubscriberStats) {
      SubscriberStats that = (SubscriberStats) o;
      return this.receivedMessages == that.getReceivedMessages()
          && this.ackedMessages == that.getAckedMessages()
          && this.totalReceivedMessages == that.getTotalReceivedMessages()
          && this.totalAckedMessages == that.getTotalAckedMessages()
          && this.endToEndLatency.equals(that.getEndToEndLatency())
          && this.ackLatency.equals(that.getAckLatency())
          && this.numberOfAutoExtendedAckDeadlines == that.getNumberOfAutoExtendedAckDeadlines();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (int) ((receivedMessages >>> 32) ^ receivedMessages);
    h$ *= 1000003;
    h$ ^= (int) ((ackedMessages >>> 32) ^ ackedMessages);
    h$ *= 1000003;
    h$ ^= (int) ((totalReceivedMessages >>> 32) ^ totalReceivedMessages);
    h$ *= 1000003;
    h$ ^= (int) ((totalAckedMessages >>> 32) ^ totalAckedMessages);
    h$ *= 1000003;
    h$ ^= endToEndLatency.hashCode();
    h$ *= 1000003;
    h$ ^= ackLatency.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((numberOfAutoExtendedAckDeadlines >>> 32) ^ numberOfAutoExtendedAckDeadlines);
    return h$;
  }

  static final class Builder extends SubscriberStats.Builder {
    private long receivedMessages;
    private long ackedMessages;
    private long totalReceivedMessages;
    private long totalAckedMessages;
    private SubscriberStats.Stats endToEndLatency;
    private SubscriberStats.Stats ackLatency;
    private long numberOfAutoExtendedAckDeadlines;
    private byte set$0;
    Builder() {
    }
    @Override
    SubscriberStats.Builder setReceivedMessages(long receivedMessages) {
      this.receivedMessages = receivedMessages;
      set$0 |= 1;
      return this;
    }
    @Override
    SubscriberStats.Builder setAckedMessages(long ackedMessages) {
      this.ackedMessages = ackedMessages;
      set$0 |= 2;
      return this;
    }
    @Override
    SubscriberStats.Builder setTotalReceivedMessages(long totalReceivedMessages) {
      this.totalReceivedMessages = totalReceivedMessages;
      set$0 |= 4;
      return this;
    }
    @Override
    SubscriberStats.Builder setTotalAckedMessages(long totalAckedMessages) {
      this.totalAckedMessages = totalAckedMessages;
      set$0 |= 8;
      return this;
    }
    @Override
    SubscriberStats.Builder setEndToEndLatency(SubscriberStats.Stats endToEndLatency) {
      if (endToEndLatency == null) {
        throw new NullPointerException("Null endToEndLatency");
      }
      this.endToEndLatency = endToEndLatency;
      return this;
    }
    @Override
    SubscriberStats.Builder setAckLatency(SubscriberStats.Stats ackLatency) {
      if (ackLatency == null) {
        throw new NullPointerException("Null ackLatency");
      }
      this.ackLatency = ackLatency;
      return this;
    }
    @Override
    SubscriberStats.Builder setNumberOfAutoExtendedAckDeadlines(long numberOfAutoExtendedAckDeadlines) {
      this.numberOfAutoExtendedAckDeadlines = numberOfAutoExtendedAckDeadlines;
      set$0 |= 0x10;
      return this;
    }
    @Override
    SubscriberStats build() {
      if (set$0 != 0x1f
          || this.endToEndLatency == null
          || this.ackLatency == null) {
        StringBuilder missing = new StringBuilder();
        if ((set$0 & 1) == 0) {
          missing.append(" receivedMessages");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" ackedMessages");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" totalReceivedMessages");
        }
        if ((set$0 & 8) == 0) {
          missing.append(" totalAckedMessages");
        }
        if (this.endToEndLatency == null) {
          missing.append(" endToEndLatency");
        }
        if (this.ackLatency == null) {
          missing.append(" ackLatency");
        }
        if ((set$0 & 0x10) == 0) {
          missing.append(" numberOfAutoExtendedAckDeadlines");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SubscriberStats(
          this.receivedMessages,
          this.ackedMessages,
          this.totalReceivedMessages,
          this.totalAckedMessages,
          this.endToEndLatency,
          this.ackLatency,
          this.numberOfAutoExtendedAckDeadlines);
    }
  }

}
