/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.it;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiService;
import com.google.api.gax.rpc.PermissionDeniedException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auto.value.AutoValue;
import com.google.cloud.ServiceOptions;
import com.google.cloud.pubsub.it.AutoValue_ITPubSubTest_MessageAndConsumer;
import com.google.cloud.pubsub.it.AutoValue_ITPubSubTest_MessageAndConsumerWithResponse;
import com.google.cloud.pubsub.v1.AckReplyConsumer;
import com.google.cloud.pubsub.v1.AckReplyConsumerWithResponse;
import com.google.cloud.pubsub.v1.AckResponse;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsub.v1.MessageReceiverWithAckResponse;
import com.google.cloud.pubsub.v1.Publisher;
import com.google.cloud.pubsub.v1.Subscriber;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.Binding;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.protobuf.ByteString;
import com.google.protobuf.ProtocolStringList;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.PushConfig;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.SubscriptionName;
import com.google.pubsub.v1.TopicName;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class ITPubSubTest {
    private static final String NAME_SUFFIX = UUID.randomUUID().toString();
    private static TopicAdminClient topicAdminClient;
    private static SubscriptionAdminClient subscriptionAdminClient;
    private static String projectId;
    private static final boolean IS_VPC_TEST;
    private static final int MAX_INBOUND_MESSAGE_SIZE = 0x1400000;
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)300L);

    @BeforeClass
    public static void setupClass() throws Exception {
        topicAdminClient = TopicAdminClient.create();
        subscriptionAdminClient = SubscriptionAdminClient.create();
        projectId = ServiceOptions.getDefaultProjectId();
    }

    @AfterClass
    public static void tearDownClass() {
        topicAdminClient.close();
        subscriptionAdminClient.close();
    }

    private String formatForTest(String resourceName) {
        return resourceName + "-" + NAME_SUFFIX;
    }

    private Subscription getSubscription(SubscriptionName subscriptionName, TopicName topicName, PushConfig pushConfig, int ackDeadline, boolean enableExactlyOnceDelivery) {
        return Subscription.newBuilder().setName(subscriptionName.toString()).setTopic(topicName.toString()).setPushConfig(pushConfig).setAckDeadlineSeconds(ackDeadline).setEnableExactlyOnceDelivery(enableExactlyOnceDelivery).build();
    }

    @Test
    public void testTopicPolicy() {
        TopicName topicName = TopicName.newBuilder().setProject(projectId).setTopic(this.formatForTest("testing-topic-policy")).build();
        topicAdminClient.createTopic(topicName);
        Policy policy = topicAdminClient.getIamPolicy(GetIamPolicyRequest.newBuilder().setResource(topicName.toString()).build());
        Binding binding = Binding.newBuilder().setRole("roles/viewer").addMembers("allAuthenticatedUsers").build();
        Policy newPolicy = topicAdminClient.setIamPolicy(SetIamPolicyRequest.newBuilder().setResource(topicName.toString()).setPolicy(policy.toBuilder().addBindings(binding).build()).build());
        Truth.assertThat((Iterable)newPolicy.getBindingsList()).contains((Object)binding);
        String permissionName = "pubsub.topics.get";
        ProtocolStringList permissions = topicAdminClient.testIamPermissions(TestIamPermissionsRequest.newBuilder().setResource(topicName.toString()).addAllPermissions(Collections.singletonList(permissionName)).build()).getPermissionsList();
        Truth.assertThat((Iterable)permissions).contains((Object)permissionName);
        topicAdminClient.deleteTopic(topicName);
    }

    @Test
    public void testVPCPushSubscriber() {
        Assume.assumeTrue((boolean)IS_VPC_TEST);
        TopicName topicName = TopicName.newBuilder().setProject(projectId).setTopic(this.formatForTest("testing-vpc-push-subscriber-topic")).build();
        SubscriptionName subscriptionName = SubscriptionName.of((String)projectId, (String)this.formatForTest("testing-vpc-push-subscriber-subscription"));
        topicAdminClient.createTopic(topicName);
        try {
            subscriptionAdminClient.createSubscription(this.getSubscription(subscriptionName, topicName, PushConfig.newBuilder().setPushEndpoint("https://random_point").build(), 10, false));
            subscriptionAdminClient.deleteSubscription(subscriptionName);
            Assert.fail((String)"No exception raised");
        }
        catch (PermissionDeniedException permissionDeniedException) {
            // empty catch block
        }
        topicAdminClient.deleteTopic(topicName);
    }

    @Test
    public void testPublishSubscribe() throws Exception {
        TopicName topicName = TopicName.newBuilder().setProject(projectId).setTopic(this.formatForTest("testing-publish-subscribe-topic")).build();
        SubscriptionName subscriptionName = SubscriptionName.of((String)projectId, (String)this.formatForTest("testing-publish-subscribe-subscription"));
        topicAdminClient.createTopic(topicName);
        subscriptionAdminClient.createSubscription(this.getSubscription(subscriptionName, topicName, PushConfig.newBuilder().build(), 10, false));
        final LinkedBlockingQueue<Object> receiveQueue = new LinkedBlockingQueue<Object>();
        Subscriber subscriber = Subscriber.newBuilder((String)subscriptionName.toString(), (MessageReceiver)new MessageReceiver(){

            public void receiveMessage(PubsubMessage message, AckReplyConsumer consumer) {
                receiveQueue.offer(MessageAndConsumer.create(message, consumer));
            }
        }).build();
        subscriber.addListener(new ApiService.Listener(){

            public void failed(ApiService.State from, Throwable failure) {
                receiveQueue.offer(failure);
            }
        }, MoreExecutors.directExecutor());
        subscriber.startAsync();
        Publisher publisher = Publisher.newBuilder((TopicName)topicName).build();
        publisher.publish(PubsubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)"msg1")).build()).get();
        publisher.publish(PubsubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)"msg2")).build()).get();
        publisher.shutdown();
        publisher.awaitTermination(1L, TimeUnit.MINUTES);
        MessageAndConsumer toAck = this.pollQueueMessageAndConsumer(receiveQueue);
        toAck.consumer().ack();
        MessageAndConsumer toNack = this.pollQueueMessageAndConsumer(receiveQueue);
        Assert.assertNotEquals((Object)toNack.message().getData(), (Object)toAck.message().getData());
        toNack.consumer().nack();
        MessageAndConsumer redeliveredToAck = this.pollQueueMessageAndConsumer(receiveQueue);
        Assert.assertEquals((Object)toNack.message().getData(), (Object)redeliveredToAck.message().getData());
        redeliveredToAck.consumer().ack();
        subscriber.stopAsync().awaitTerminated();
        subscriptionAdminClient.deleteSubscription(subscriptionName);
        topicAdminClient.deleteTopic(topicName);
    }

    @Test
    public void testPublishSubscribeMessageFutures() throws Exception {
        TopicName topicName = TopicName.newBuilder().setProject(projectId).setTopic(this.formatForTest("testing-publish-subscribe-message-futures")).build();
        SubscriptionName subscriptionName = SubscriptionName.of((String)projectId, (String)this.formatForTest("testing-publish-subscribe-message-futures"));
        topicAdminClient.createTopic(topicName);
        subscriptionAdminClient.createSubscription(this.getSubscription(subscriptionName, topicName, PushConfig.newBuilder().build(), 10, false));
        final LinkedBlockingQueue<Object> receiveQueue = new LinkedBlockingQueue<Object>();
        Subscriber subscriber = Subscriber.newBuilder((String)subscriptionName.toString(), (MessageReceiverWithAckResponse)new MessageReceiverWithAckResponse(){

            public void receiveMessage(PubsubMessage message, AckReplyConsumerWithResponse consumerWithResponse) {
                receiveQueue.offer(MessageAndConsumerWithResponse.create(message, consumerWithResponse));
            }
        }).setChannelProvider((TransportChannelProvider)SubscriptionAdminSettings.defaultGrpcTransportProviderBuilder().setMaxInboundMessageSize(Integer.valueOf(0x1400000)).build()).build();
        subscriber.addListener(new ApiService.Listener(){

            public void failed(ApiService.State from, Throwable failure) {
                receiveQueue.offer(failure);
            }
        }, MoreExecutors.directExecutor());
        subscriber.startAsync();
        Publisher publisher = Publisher.newBuilder((TopicName)topicName).build();
        publisher.publish(PubsubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)"msg1")).build()).get();
        publisher.publish(PubsubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)"msg2")).build()).get();
        publisher.shutdown();
        publisher.awaitTermination(1L, TimeUnit.MINUTES);
        MessageAndConsumerWithResponse toAck = this.pollQueueMessageAndConsumerWithResponse(receiveQueue);
        ApiFuture ackResponseFuture = toAck.consumerWithResponse().ack();
        Assert.assertEquals((Object)AckResponse.SUCCESSFUL, ackResponseFuture.get());
        MessageAndConsumerWithResponse toNack = this.pollQueueMessageAndConsumerWithResponse(receiveQueue);
        Assert.assertNotEquals((Object)toNack.message().getData(), (Object)toAck.message().getData());
        ApiFuture nackResponseFuture = toNack.consumerWithResponse().nack();
        Assert.assertEquals((Object)AckResponse.SUCCESSFUL, nackResponseFuture.get());
        MessageAndConsumerWithResponse redeliveredToAck = this.pollQueueMessageAndConsumerWithResponse(receiveQueue);
        ApiFuture redeliveredToAckResponse = redeliveredToAck.consumerWithResponse().ack();
        Assert.assertEquals((Object)toNack.message().getData(), (Object)redeliveredToAck.message().getData());
        Assert.assertEquals((Object)AckResponse.SUCCESSFUL, redeliveredToAckResponse.get());
        subscriber.stopAsync().awaitTerminated();
        subscriptionAdminClient.deleteSubscription(subscriptionName);
        topicAdminClient.deleteTopic(topicName);
    }

    @Test
    public void testPublishSubscribeExactlyOnce() throws Exception {
        TopicName topicName = TopicName.newBuilder().setProject(projectId).setTopic(this.formatForTest("testing-publish-subscribe-exactly-once-topic")).build();
        SubscriptionName subscriptionName = SubscriptionName.of((String)projectId, (String)this.formatForTest("testing-publish-subscribe-exactly-once-subscription"));
        topicAdminClient.createTopic(topicName);
        subscriptionAdminClient.createSubscription(this.getSubscription(subscriptionName, topicName, PushConfig.newBuilder().build(), 60, true));
        final LinkedBlockingQueue<Object> receiveQueue = new LinkedBlockingQueue<Object>();
        Subscriber subscriber = Subscriber.newBuilder((String)subscriptionName.toString(), (MessageReceiverWithAckResponse)new MessageReceiverWithAckResponse(){

            public void receiveMessage(PubsubMessage message, AckReplyConsumerWithResponse consumerWithResponse) {
                receiveQueue.offer(MessageAndConsumerWithResponse.create(message, consumerWithResponse));
            }
        }).setChannelProvider((TransportChannelProvider)SubscriptionAdminSettings.defaultGrpcTransportProviderBuilder().setMaxInboundMessageSize(Integer.valueOf(0x1400000)).build()).build();
        subscriber.addListener(new ApiService.Listener(){

            public void failed(ApiService.State from, Throwable failure) {
                receiveQueue.offer(failure);
            }
        }, MoreExecutors.directExecutor());
        subscriber.startAsync();
        Publisher publisher = Publisher.newBuilder((TopicName)topicName).build();
        publisher.publish(PubsubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)"msg1")).build()).get();
        publisher.publish(PubsubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)"msg2")).build()).get();
        publisher.shutdown();
        publisher.awaitTermination(1L, TimeUnit.MINUTES);
        MessageAndConsumerWithResponse toAck = this.pollQueueMessageAndConsumerWithResponse(receiveQueue);
        ApiFuture ackResponseFuture = toAck.consumerWithResponse().ack();
        Assert.assertEquals((Object)AckResponse.SUCCESSFUL, ackResponseFuture.get());
        MessageAndConsumerWithResponse toNack = this.pollQueueMessageAndConsumerWithResponse(receiveQueue);
        Assert.assertNotEquals((Object)toNack.message().getData(), (Object)toAck.message().getData());
        ApiFuture nackResponseFuture = toNack.consumerWithResponse().nack();
        Assert.assertEquals((Object)AckResponse.SUCCESSFUL, nackResponseFuture.get());
        MessageAndConsumerWithResponse redeliveredToAck = this.pollQueueMessageAndConsumerWithResponse(receiveQueue);
        ApiFuture redeliveredToAckResponse = redeliveredToAck.consumerWithResponse().ack();
        Assert.assertEquals((Object)toNack.message().getData(), (Object)redeliveredToAck.message().getData());
        Assert.assertEquals((Object)AckResponse.SUCCESSFUL, redeliveredToAckResponse.get());
        subscriber.stopAsync().awaitTerminated();
        subscriptionAdminClient.deleteSubscription(subscriptionName);
        topicAdminClient.deleteTopic(topicName);
    }

    @Test
    public void testPublishSubscribeWithCompression() throws Exception {
        TopicName topicName = TopicName.newBuilder().setProject(projectId).setTopic(this.formatForTest("testing-compression-topic")).build();
        SubscriptionName subscriptionName = SubscriptionName.of((String)projectId, (String)this.formatForTest("testing-compression-subscription"));
        topicAdminClient.createTopic(topicName);
        subscriptionAdminClient.createSubscription(this.getSubscription(subscriptionName, topicName, PushConfig.newBuilder().build(), 10, false));
        final LinkedBlockingQueue<Object> receiveQueue = new LinkedBlockingQueue<Object>();
        Subscriber subscriber = Subscriber.newBuilder((String)subscriptionName.toString(), (MessageReceiver)new MessageReceiver(){

            public void receiveMessage(PubsubMessage message, AckReplyConsumer consumer) {
                receiveQueue.offer(MessageAndConsumer.create(message, consumer));
            }
        }).build();
        subscriber.addListener(new ApiService.Listener(){

            public void failed(ApiService.State from, Throwable failure) {
                receiveQueue.offer(failure);
            }
        }, MoreExecutors.directExecutor());
        subscriber.startAsync();
        Publisher publisher = Publisher.newBuilder((TopicName)topicName).setEnableCompression(true).build();
        String msg1 = this.generateMessage("msg1", 1000);
        String msg2 = this.generateMessage("msg2", 1500);
        publisher.publish(PubsubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)msg1)).build()).get();
        publisher.publish(PubsubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)msg2)).build()).get();
        publisher.shutdown();
        publisher.awaitTermination(1L, TimeUnit.MINUTES);
        MessageAndConsumer toAck1 = this.pollQueueMessageAndConsumer(receiveQueue);
        toAck1.consumer().ack();
        MessageAndConsumer toAck2 = this.pollQueueMessageAndConsumer(receiveQueue);
        toAck2.consumer().ack();
        Assert.assertNotEquals((Object)toAck1.message().getData(), (Object)toAck2.message().getData());
        subscriber.stopAsync().awaitTerminated();
        subscriptionAdminClient.deleteSubscription(subscriptionName);
        topicAdminClient.deleteTopic(topicName);
    }

    private MessageAndConsumer pollQueueMessageAndConsumer(BlockingQueue<Object> queue) throws InterruptedException {
        Object obj = this.pollQueue(queue);
        if (obj instanceof MessageAndConsumer) {
            return (MessageAndConsumer)obj;
        }
        throw new IllegalStateException("expected either MessageAndConsumer or Throwable, found: " + obj);
    }

    private MessageAndConsumerWithResponse pollQueueMessageAndConsumerWithResponse(BlockingQueue<Object> queue) throws InterruptedException {
        Object obj = this.pollQueue(queue);
        if (obj instanceof MessageAndConsumerWithResponse) {
            return (MessageAndConsumerWithResponse)obj;
        }
        throw new IllegalStateException("expected either MessageAndConsumerWithResponse or Throwable, found: " + obj);
    }

    private Object pollQueue(BlockingQueue<Object> queue) throws InterruptedException {
        Object obj = queue.poll(10L, TimeUnit.MINUTES);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Throwable) {
            throw new IllegalStateException("unexpected error", (Throwable)obj);
        }
        return obj;
    }

    private String generateMessage(String token, int bytes) {
        String result = "";
        int tokenBytes = token.length();
        int i = 0;
        while ((double)i < Math.floor(bytes / tokenBytes) + 1.0) {
            result = result.concat(token);
            ++i;
        }
        return result;
    }

    static {
        IS_VPC_TEST = System.getenv("GOOGLE_CLOUD_TESTS_IN_VPCSC") != null && System.getenv("GOOGLE_CLOUD_TESTS_IN_VPCSC").equalsIgnoreCase("true");
    }

    @AutoValue
    static abstract class MessageAndConsumer {
        MessageAndConsumer() {
        }

        abstract PubsubMessage message();

        abstract AckReplyConsumer consumer();

        static MessageAndConsumer create(PubsubMessage message, AckReplyConsumer consumer) {
            return new AutoValue_ITPubSubTest_MessageAndConsumer(message, consumer);
        }
    }

    @AutoValue
    static abstract class MessageAndConsumerWithResponse {
        MessageAndConsumerWithResponse() {
        }

        abstract PubsubMessage message();

        abstract AckReplyConsumerWithResponse consumerWithResponse();

        static MessageAndConsumerWithResponse create(PubsubMessage message, AckReplyConsumerWithResponse consumerWithResponse) {
            return new AutoValue_ITPubSubTest_MessageAndConsumerWithResponse(message, consumerWithResponse);
        }
    }
}

