/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.cloud.pubsub.v1.AckRequestData;
import com.google.cloud.pubsub.v1.ModackRequestData;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.mockito.ArgumentMatcher;

public class CustomArgumentMatchers {

    public static class ModackRequestDataListMatcher
    implements ArgumentMatcher<List<ModackRequestData>> {
        private List<ModackRequestData> left;

        ModackRequestDataListMatcher(List<ModackRequestData> modackRequestDataList) {
            this.left = modackRequestDataList;
        }

        public boolean matches(List<ModackRequestData> right) {
            if (this.left.size() != right.size()) {
                return false;
            }
            this.left.sort(ModackRequestDataMatcher.comparator);
            right.sort(ModackRequestDataMatcher.comparator);
            Iterator<ModackRequestData> iteratorLeft = this.left.iterator();
            Iterator<ModackRequestData> iteratorRight = right.iterator();
            while (iteratorLeft.hasNext() && iteratorRight.hasNext()) {
                ModackRequestDataMatcher modackRequestDataMatcher = new ModackRequestDataMatcher(iteratorLeft.next());
                if (modackRequestDataMatcher.matches(iteratorRight.next())) continue;
                return false;
            }
            return true;
        }
    }

    public static class ModackRequestDataMatcher
    implements ArgumentMatcher<ModackRequestData> {
        private ModackRequestData left;
        private static Comparator<ModackRequestData> comparator = new Comparator<ModackRequestData>(){

            @Override
            public int compare(ModackRequestData left, ModackRequestData right) {
                int deadlineExtensionDifference = left.getDeadlineExtensionSeconds() - right.getDeadlineExtensionSeconds();
                if (deadlineExtensionDifference != 0) {
                    return deadlineExtensionDifference;
                }
                List ackRequestDataListLeft = left.getAckRequestData();
                List ackRequestDataListRight = right.getAckRequestData();
                ackRequestDataListLeft.sort(AckRequestDataMatcher.comparator);
                ackRequestDataListRight.sort(AckRequestDataMatcher.comparator);
                Iterator iteratorLeft = ackRequestDataListLeft.iterator();
                Iterator iteratorRight = ackRequestDataListRight.iterator();
                while (iteratorLeft.hasNext() && iteratorRight.hasNext()) {
                    String ackIdRight;
                    String ackIdLeft = ((AckRequestData)iteratorLeft.next()).getAckId();
                    int compareAcks = ackIdLeft.compareTo(ackIdRight = ((AckRequestData)iteratorRight.next()).getAckId());
                    if (compareAcks == 0) continue;
                    return compareAcks;
                }
                if (iteratorLeft.hasNext()) {
                    return 1;
                }
                if (iteratorRight.hasNext()) {
                    return -1;
                }
                return 0;
            }
        };

        ModackRequestDataMatcher(ModackRequestData left) {
            this.left = left;
        }

        public boolean matches(ModackRequestData right) {
            return comparator.compare(this.left, right) == 0;
        }
    }

    public static class AckRequestDataListMatcher
    implements ArgumentMatcher<List<AckRequestData>> {
        private List<AckRequestData> left;

        AckRequestDataListMatcher(List<AckRequestData> ackRequestDataList) {
            this.left = ackRequestDataList;
        }

        public boolean matches(List<AckRequestData> right) {
            if (this.left.size() != right.size()) {
                return false;
            }
            this.left.sort(AckRequestDataMatcher.comparator);
            right.sort(AckRequestDataMatcher.comparator);
            Iterator<AckRequestData> iteratorLeft = this.left.iterator();
            Iterator<AckRequestData> iteratorRight = right.iterator();
            while (iteratorLeft.hasNext() && iteratorRight.hasNext()) {
                if (iteratorLeft.next().getAckId() == iteratorRight.next().getAckId()) continue;
                return false;
            }
            return true;
        }
    }

    public static class AckRequestDataMatcher
    implements ArgumentMatcher<AckRequestData> {
        private AckRequestData left;
        private static Comparator<AckRequestData> comparator = new Comparator<AckRequestData>(){

            @Override
            public int compare(AckRequestData ackRequestData, AckRequestData t1) {
                return ackRequestData.getAckId().compareTo(t1.getAckId());
            }
        };

        AckRequestDataMatcher(AckRequestData left) {
            this.left = left;
        }

        public boolean matches(AckRequestData right) {
            return this.left.getAckId() == right.getAckId();
        }
    }

    public static class ModifyAckDeadlineRequestMatcher
    implements ArgumentMatcher<ModifyAckDeadlineRequest> {
        private ModifyAckDeadlineRequest left;

        ModifyAckDeadlineRequestMatcher(ModifyAckDeadlineRequest modifyAckDeadlineRequest) {
            this.left = modifyAckDeadlineRequest;
        }

        public boolean matches(ModifyAckDeadlineRequest right) {
            HashSet leftAckIdSet = new HashSet(this.left.getAckIdsList());
            HashSet rightAckIdSet = new HashSet(right.getAckIdsList());
            return this.left.getSubscription().equals(right.getSubscription()) && this.left.getAckDeadlineSeconds() == right.getAckDeadlineSeconds() && leftAckIdSet.equals(rightAckIdSet);
        }
    }

    public static class AcknowledgeRequestMatcher
    implements ArgumentMatcher<AcknowledgeRequest> {
        private AcknowledgeRequest left;

        AcknowledgeRequestMatcher(AcknowledgeRequest acknowledgeRequest) {
            this.left = acknowledgeRequest;
        }

        public boolean matches(AcknowledgeRequest right) {
            HashSet leftAckIdSet = new HashSet(this.left.getAckIdsList());
            HashSet rightAckIdSet = new HashSet(right.getAckIdsList());
            return this.left.getSubscription().equals(right.getSubscription()) && leftAckIdSet.equals(rightAckIdSet);
        }
    }
}

