/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.MockIAMPolicy;
import com.google.cloud.pubsub.v1.MockSchemaService;
import com.google.cloud.pubsub.v1.SchemaServiceClient;
import com.google.cloud.pubsub.v1.SchemaServiceSettings;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.GetPolicyOptions;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Timestamp;
import com.google.pubsub.v1.CommitSchemaRequest;
import com.google.pubsub.v1.CreateSchemaRequest;
import com.google.pubsub.v1.DeleteSchemaRequest;
import com.google.pubsub.v1.DeleteSchemaRevisionRequest;
import com.google.pubsub.v1.Encoding;
import com.google.pubsub.v1.GetSchemaRequest;
import com.google.pubsub.v1.ListSchemaRevisionsRequest;
import com.google.pubsub.v1.ListSchemaRevisionsResponse;
import com.google.pubsub.v1.ListSchemasRequest;
import com.google.pubsub.v1.ListSchemasResponse;
import com.google.pubsub.v1.ProjectName;
import com.google.pubsub.v1.RollbackSchemaRequest;
import com.google.pubsub.v1.Schema;
import com.google.pubsub.v1.SchemaName;
import com.google.pubsub.v1.ValidateMessageRequest;
import com.google.pubsub.v1.ValidateMessageResponse;
import com.google.pubsub.v1.ValidateSchemaRequest;
import com.google.pubsub.v1.ValidateSchemaResponse;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SchemaServiceClientTest {
    private static MockIAMPolicy mockIAMPolicy;
    private static MockSchemaService mockSchemaService;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private SchemaServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockSchemaService = new MockSchemaService();
        mockIAMPolicy = new MockIAMPolicy();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockSchemaService, mockIAMPolicy));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        SchemaServiceSettings settings = ((SchemaServiceSettings.Builder)((SchemaServiceSettings.Builder)SchemaServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = SchemaServiceClient.create((SchemaServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createSchemaTest() throws Exception {
        Schema expectedResponse = Schema.newBuilder().setName(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setDefinition("definition-1014418093").setRevisionId("revisionId-1507445162").setRevisionCreateTime(Timestamp.newBuilder().build()).build();
        mockSchemaService.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        Schema schema = Schema.newBuilder().build();
        String schemaId = "schemaId-697673060";
        Schema actualResponse = this.client.createSchema(parent, schema, schemaId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSchemaService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSchemaRequest actualRequest = (CreateSchemaRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)schema, (Object)actualRequest.getSchema());
        Assert.assertEquals((Object)schemaId, (Object)actualRequest.getSchemaId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSchemaExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSchemaService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            Schema schema = Schema.newBuilder().build();
            String schemaId = "schemaId-697673060";
            this.client.createSchema(parent, schema, schemaId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSchemaTest2() throws Exception {
        Schema expectedResponse = Schema.newBuilder().setName(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setDefinition("definition-1014418093").setRevisionId("revisionId-1507445162").setRevisionCreateTime(Timestamp.newBuilder().build()).build();
        mockSchemaService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Schema schema = Schema.newBuilder().build();
        String schemaId = "schemaId-697673060";
        Schema actualResponse = this.client.createSchema(parent, schema, schemaId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSchemaService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSchemaRequest actualRequest = (CreateSchemaRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)schema, (Object)actualRequest.getSchema());
        Assert.assertEquals((Object)schemaId, (Object)actualRequest.getSchemaId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSchemaExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSchemaService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Schema schema = Schema.newBuilder().build();
            String schemaId = "schemaId-697673060";
            this.client.createSchema(parent, schema, schemaId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSchemaTest() throws Exception {
        Schema expectedResponse = Schema.newBuilder().setName(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setDefinition("definition-1014418093").setRevisionId("revisionId-1507445162").setRevisionCreateTime(Timestamp.newBuilder().build()).build();
        mockSchemaService.addResponse((AbstractMessage)expectedResponse);
        SchemaName name = SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]");
        Schema actualResponse = this.client.getSchema(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSchemaService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSchemaRequest actualRequest = (GetSchemaRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSchemaExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSchemaService.addException((Exception)exception);
        try {
            SchemaName name = SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]");
            this.client.getSchema(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSchemaTest2() throws Exception {
        Schema expectedResponse = Schema.newBuilder().setName(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setDefinition("definition-1014418093").setRevisionId("revisionId-1507445162").setRevisionCreateTime(Timestamp.newBuilder().build()).build();
        mockSchemaService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Schema actualResponse = this.client.getSchema(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSchemaService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSchemaRequest actualRequest = (GetSchemaRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSchemaExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSchemaService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getSchema(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSchemasTest() throws Exception {
        Schema responsesElement = Schema.newBuilder().build();
        ListSchemasResponse expectedResponse = ListSchemasResponse.newBuilder().setNextPageToken("").addAllSchemas(Arrays.asList(responsesElement)).build();
        mockSchemaService.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        SchemaServiceClient.ListSchemasPagedResponse pagedListResponse = this.client.listSchemas(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSchemasList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSchemaService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSchemasRequest actualRequest = (ListSchemasRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSchemasExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSchemaService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            this.client.listSchemas(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSchemasTest2() throws Exception {
        Schema responsesElement = Schema.newBuilder().build();
        ListSchemasResponse expectedResponse = ListSchemasResponse.newBuilder().setNextPageToken("").addAllSchemas(Arrays.asList(responsesElement)).build();
        mockSchemaService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        SchemaServiceClient.ListSchemasPagedResponse pagedListResponse = this.client.listSchemas(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSchemasList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSchemaService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSchemasRequest actualRequest = (ListSchemasRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSchemasExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSchemaService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listSchemas(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSchemaRevisionsTest() throws Exception {
        Schema responsesElement = Schema.newBuilder().build();
        ListSchemaRevisionsResponse expectedResponse = ListSchemaRevisionsResponse.newBuilder().setNextPageToken("").addAllSchemas(Arrays.asList(responsesElement)).build();
        mockSchemaService.addResponse((AbstractMessage)expectedResponse);
        SchemaName name = SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]");
        SchemaServiceClient.ListSchemaRevisionsPagedResponse pagedListResponse = this.client.listSchemaRevisions(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSchemasList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSchemaService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSchemaRevisionsRequest actualRequest = (ListSchemaRevisionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSchemaRevisionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSchemaService.addException((Exception)exception);
        try {
            SchemaName name = SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]");
            this.client.listSchemaRevisions(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSchemaRevisionsTest2() throws Exception {
        Schema responsesElement = Schema.newBuilder().build();
        ListSchemaRevisionsResponse expectedResponse = ListSchemaRevisionsResponse.newBuilder().setNextPageToken("").addAllSchemas(Arrays.asList(responsesElement)).build();
        mockSchemaService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        SchemaServiceClient.ListSchemaRevisionsPagedResponse pagedListResponse = this.client.listSchemaRevisions(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSchemasList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSchemaService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSchemaRevisionsRequest actualRequest = (ListSchemaRevisionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSchemaRevisionsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSchemaService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.listSchemaRevisions(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void commitSchemaTest() throws Exception {
        Schema expectedResponse = Schema.newBuilder().setName(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setDefinition("definition-1014418093").setRevisionId("revisionId-1507445162").setRevisionCreateTime(Timestamp.newBuilder().build()).build();
        mockSchemaService.addResponse((AbstractMessage)expectedResponse);
        SchemaName name = SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]");
        Schema schema = Schema.newBuilder().build();
        Schema actualResponse = this.client.commitSchema(name, schema);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSchemaService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CommitSchemaRequest actualRequest = (CommitSchemaRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)schema, (Object)actualRequest.getSchema());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void commitSchemaExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSchemaService.addException((Exception)exception);
        try {
            SchemaName name = SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]");
            Schema schema = Schema.newBuilder().build();
            this.client.commitSchema(name, schema);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void commitSchemaTest2() throws Exception {
        Schema expectedResponse = Schema.newBuilder().setName(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setDefinition("definition-1014418093").setRevisionId("revisionId-1507445162").setRevisionCreateTime(Timestamp.newBuilder().build()).build();
        mockSchemaService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Schema schema = Schema.newBuilder().build();
        Schema actualResponse = this.client.commitSchema(name, schema);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSchemaService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CommitSchemaRequest actualRequest = (CommitSchemaRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)schema, (Object)actualRequest.getSchema());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void commitSchemaExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSchemaService.addException((Exception)exception);
        try {
            String name = "name3373707";
            Schema schema = Schema.newBuilder().build();
            this.client.commitSchema(name, schema);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void rollbackSchemaTest() throws Exception {
        Schema expectedResponse = Schema.newBuilder().setName(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setDefinition("definition-1014418093").setRevisionId("revisionId-1507445162").setRevisionCreateTime(Timestamp.newBuilder().build()).build();
        mockSchemaService.addResponse((AbstractMessage)expectedResponse);
        SchemaName name = SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]");
        String revisionId = "revisionId-1507445162";
        Schema actualResponse = this.client.rollbackSchema(name, revisionId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSchemaService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RollbackSchemaRequest actualRequest = (RollbackSchemaRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)revisionId, (Object)actualRequest.getRevisionId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void rollbackSchemaExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSchemaService.addException((Exception)exception);
        try {
            SchemaName name = SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]");
            String revisionId = "revisionId-1507445162";
            this.client.rollbackSchema(name, revisionId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void rollbackSchemaTest2() throws Exception {
        Schema expectedResponse = Schema.newBuilder().setName(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setDefinition("definition-1014418093").setRevisionId("revisionId-1507445162").setRevisionCreateTime(Timestamp.newBuilder().build()).build();
        mockSchemaService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        String revisionId = "revisionId-1507445162";
        Schema actualResponse = this.client.rollbackSchema(name, revisionId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSchemaService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RollbackSchemaRequest actualRequest = (RollbackSchemaRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)revisionId, (Object)actualRequest.getRevisionId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void rollbackSchemaExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSchemaService.addException((Exception)exception);
        try {
            String name = "name3373707";
            String revisionId = "revisionId-1507445162";
            this.client.rollbackSchema(name, revisionId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSchemaRevisionTest() throws Exception {
        Schema expectedResponse = Schema.newBuilder().setName(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setDefinition("definition-1014418093").setRevisionId("revisionId-1507445162").setRevisionCreateTime(Timestamp.newBuilder().build()).build();
        mockSchemaService.addResponse((AbstractMessage)expectedResponse);
        SchemaName name = SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]");
        String revisionId = "revisionId-1507445162";
        Schema actualResponse = this.client.deleteSchemaRevision(name, revisionId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSchemaService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSchemaRevisionRequest actualRequest = (DeleteSchemaRevisionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)revisionId, (Object)actualRequest.getRevisionId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSchemaRevisionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSchemaService.addException((Exception)exception);
        try {
            SchemaName name = SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]");
            String revisionId = "revisionId-1507445162";
            this.client.deleteSchemaRevision(name, revisionId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSchemaRevisionTest2() throws Exception {
        Schema expectedResponse = Schema.newBuilder().setName(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setDefinition("definition-1014418093").setRevisionId("revisionId-1507445162").setRevisionCreateTime(Timestamp.newBuilder().build()).build();
        mockSchemaService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        String revisionId = "revisionId-1507445162";
        Schema actualResponse = this.client.deleteSchemaRevision(name, revisionId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSchemaService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSchemaRevisionRequest actualRequest = (DeleteSchemaRevisionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)revisionId, (Object)actualRequest.getRevisionId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSchemaRevisionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSchemaService.addException((Exception)exception);
        try {
            String name = "name3373707";
            String revisionId = "revisionId-1507445162";
            this.client.deleteSchemaRevision(name, revisionId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSchemaTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSchemaService.addResponse((AbstractMessage)expectedResponse);
        SchemaName name = SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]");
        this.client.deleteSchema(name);
        List<AbstractMessage> actualRequests = mockSchemaService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSchemaRequest actualRequest = (DeleteSchemaRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSchemaExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSchemaService.addException((Exception)exception);
        try {
            SchemaName name = SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]");
            this.client.deleteSchema(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSchemaTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSchemaService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteSchema(name);
        List<AbstractMessage> actualRequests = mockSchemaService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSchemaRequest actualRequest = (DeleteSchemaRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSchemaExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSchemaService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteSchema(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void validateSchemaTest() throws Exception {
        ValidateSchemaResponse expectedResponse = ValidateSchemaResponse.newBuilder().build();
        mockSchemaService.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        Schema schema = Schema.newBuilder().build();
        ValidateSchemaResponse actualResponse = this.client.validateSchema(parent, schema);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSchemaService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ValidateSchemaRequest actualRequest = (ValidateSchemaRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)schema, (Object)actualRequest.getSchema());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void validateSchemaExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSchemaService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            Schema schema = Schema.newBuilder().build();
            this.client.validateSchema(parent, schema);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void validateSchemaTest2() throws Exception {
        ValidateSchemaResponse expectedResponse = ValidateSchemaResponse.newBuilder().build();
        mockSchemaService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Schema schema = Schema.newBuilder().build();
        ValidateSchemaResponse actualResponse = this.client.validateSchema(parent, schema);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSchemaService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ValidateSchemaRequest actualRequest = (ValidateSchemaRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)schema, (Object)actualRequest.getSchema());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void validateSchemaExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSchemaService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Schema schema = Schema.newBuilder().build();
            this.client.validateSchema(parent, schema);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void validateMessageTest() throws Exception {
        ValidateMessageResponse expectedResponse = ValidateMessageResponse.newBuilder().build();
        mockSchemaService.addResponse((AbstractMessage)expectedResponse);
        ValidateMessageRequest request = ValidateMessageRequest.newBuilder().setParent(ProjectName.of((String)"[PROJECT]").toString()).setMessage(ByteString.EMPTY).setEncoding(Encoding.forNumber((int)0)).build();
        ValidateMessageResponse actualResponse = this.client.validateMessage(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSchemaService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ValidateMessageRequest actualRequest = (ValidateMessageRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getSchema(), (Object)actualRequest.getSchema());
        Assert.assertEquals((Object)request.getMessage(), (Object)actualRequest.getMessage());
        Assert.assertEquals((Object)request.getEncoding(), (Object)actualRequest.getEncoding());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void validateMessageExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSchemaService.addException((Exception)exception);
        try {
            ValidateMessageRequest request = ValidateMessageRequest.newBuilder().setParent(ProjectName.of((String)"[PROJECT]").toString()).setMessage(ByteString.EMPTY).setEncoding(Encoding.forNumber((int)0)).build();
            this.client.validateMessage(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockIAMPolicy.addResponse((AbstractMessage)expectedResponse);
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setPolicy(Policy.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).build();
        Policy actualResponse = this.client.setIamPolicy(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockIAMPolicy.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetIamPolicyRequest actualRequest = (SetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getResource(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)request.getPolicy(), (Object)actualRequest.getPolicy());
        Assert.assertEquals((Object)request.getUpdateMask(), (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockIAMPolicy.addException((Exception)exception);
        try {
            SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setPolicy(Policy.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).build();
            this.client.setIamPolicy(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockIAMPolicy.addResponse((AbstractMessage)expectedResponse);
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setOptions(GetPolicyOptions.newBuilder().build()).build();
        Policy actualResponse = this.client.getIamPolicy(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockIAMPolicy.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIamPolicyRequest actualRequest = (GetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getResource(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)request.getOptions(), (Object)actualRequest.getOptions());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockIAMPolicy.addException((Exception)exception);
        try {
            GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setOptions(GetPolicyOptions.newBuilder().build()).build();
            this.client.getIamPolicy(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockIAMPolicy.addResponse((AbstractMessage)expectedResponse);
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).addAllPermissions(new ArrayList()).build();
        TestIamPermissionsResponse actualResponse = this.client.testIamPermissions(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockIAMPolicy.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TestIamPermissionsRequest actualRequest = (TestIamPermissionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getResource(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)request.getPermissionsList(), (Object)actualRequest.getPermissionsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockIAMPolicy.addException((Exception)exception);
        try {
            TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).addAllPermissions(new ArrayList()).build();
            this.client.testIamPermissions(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

