/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.MockIAMPolicy;
import com.google.cloud.pubsub.v1.MockPublisher;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.GetPolicyOptions;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.pubsub.v1.DeleteTopicRequest;
import com.google.pubsub.v1.DetachSubscriptionRequest;
import com.google.pubsub.v1.DetachSubscriptionResponse;
import com.google.pubsub.v1.GetTopicRequest;
import com.google.pubsub.v1.IngestionDataSourceSettings;
import com.google.pubsub.v1.ListTopicSnapshotsRequest;
import com.google.pubsub.v1.ListTopicSnapshotsResponse;
import com.google.pubsub.v1.ListTopicSubscriptionsRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicsRequest;
import com.google.pubsub.v1.ListTopicsResponse;
import com.google.pubsub.v1.MessageStoragePolicy;
import com.google.pubsub.v1.ProjectName;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.SchemaName;
import com.google.pubsub.v1.SchemaSettings;
import com.google.pubsub.v1.SubscriptionName;
import com.google.pubsub.v1.Topic;
import com.google.pubsub.v1.TopicName;
import com.google.pubsub.v1.UpdateTopicRequest;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TopicAdminClientTest {
    private static MockIAMPolicy mockIAMPolicy;
    private static MockPublisher mockPublisher;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private TopicAdminClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockPublisher = new MockPublisher();
        mockIAMPolicy = new MockIAMPolicy();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockPublisher, mockIAMPolicy));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        TopicAdminSettings settings = ((TopicAdminSettings.Builder)((TopicAdminSettings.Builder)TopicAdminSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = TopicAdminClient.create((TopicAdminSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createTopicTest() throws Exception {
        Topic expectedResponse = Topic.newBuilder().setName(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).putAllLabels(new HashMap()).setMessageStoragePolicy(MessageStoragePolicy.newBuilder().build()).setKmsKeyName("kmsKeyName412586233").setSchemaSettings(SchemaSettings.newBuilder().build()).setSatisfiesPzs(true).setMessageRetentionDuration(Duration.newBuilder().build()).setIngestionDataSourceSettings(IngestionDataSourceSettings.newBuilder().build()).build();
        mockPublisher.addResponse((AbstractMessage)expectedResponse);
        TopicName name = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
        Topic actualResponse = this.client.createTopic(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockPublisher.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        Topic actualRequest = (Topic)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createTopicExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPublisher.addException((Exception)exception);
        try {
            TopicName name = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
            this.client.createTopic(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createTopicTest2() throws Exception {
        Topic expectedResponse = Topic.newBuilder().setName(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).putAllLabels(new HashMap()).setMessageStoragePolicy(MessageStoragePolicy.newBuilder().build()).setKmsKeyName("kmsKeyName412586233").setSchemaSettings(SchemaSettings.newBuilder().build()).setSatisfiesPzs(true).setMessageRetentionDuration(Duration.newBuilder().build()).setIngestionDataSourceSettings(IngestionDataSourceSettings.newBuilder().build()).build();
        mockPublisher.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Topic actualResponse = this.client.createTopic(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockPublisher.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        Topic actualRequest = (Topic)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createTopicExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPublisher.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.createTopic(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateTopicTest() throws Exception {
        Topic expectedResponse = Topic.newBuilder().setName(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).putAllLabels(new HashMap()).setMessageStoragePolicy(MessageStoragePolicy.newBuilder().build()).setKmsKeyName("kmsKeyName412586233").setSchemaSettings(SchemaSettings.newBuilder().build()).setSatisfiesPzs(true).setMessageRetentionDuration(Duration.newBuilder().build()).setIngestionDataSourceSettings(IngestionDataSourceSettings.newBuilder().build()).build();
        mockPublisher.addResponse((AbstractMessage)expectedResponse);
        Topic topic = Topic.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Topic actualResponse = this.client.updateTopic(topic, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockPublisher.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateTopicRequest actualRequest = (UpdateTopicRequest)actualRequests.get(0);
        Assert.assertEquals((Object)topic, (Object)actualRequest.getTopic());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateTopicExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPublisher.addException((Exception)exception);
        try {
            Topic topic = Topic.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateTopic(topic, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void publishTest() throws Exception {
        PublishResponse expectedResponse = PublishResponse.newBuilder().addAllMessageIds(new ArrayList()).build();
        mockPublisher.addResponse((AbstractMessage)expectedResponse);
        TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
        ArrayList messages = new ArrayList();
        PublishResponse actualResponse = this.client.publish(topic, messages);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockPublisher.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        PublishRequest actualRequest = (PublishRequest)actualRequests.get(0);
        Assert.assertEquals((Object)topic.toString(), (Object)actualRequest.getTopic());
        Assert.assertEquals(messages, (Object)actualRequest.getMessagesList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void publishExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPublisher.addException((Exception)exception);
        try {
            TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
            ArrayList messages = new ArrayList();
            this.client.publish(topic, messages);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void publishTest2() throws Exception {
        PublishResponse expectedResponse = PublishResponse.newBuilder().addAllMessageIds(new ArrayList()).build();
        mockPublisher.addResponse((AbstractMessage)expectedResponse);
        String topic = "topic110546223";
        ArrayList messages = new ArrayList();
        PublishResponse actualResponse = this.client.publish(topic, messages);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockPublisher.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        PublishRequest actualRequest = (PublishRequest)actualRequests.get(0);
        Assert.assertEquals((Object)topic, (Object)actualRequest.getTopic());
        Assert.assertEquals(messages, (Object)actualRequest.getMessagesList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void publishExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPublisher.addException((Exception)exception);
        try {
            String topic = "topic110546223";
            ArrayList messages = new ArrayList();
            this.client.publish(topic, messages);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getTopicTest() throws Exception {
        Topic expectedResponse = Topic.newBuilder().setName(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).putAllLabels(new HashMap()).setMessageStoragePolicy(MessageStoragePolicy.newBuilder().build()).setKmsKeyName("kmsKeyName412586233").setSchemaSettings(SchemaSettings.newBuilder().build()).setSatisfiesPzs(true).setMessageRetentionDuration(Duration.newBuilder().build()).setIngestionDataSourceSettings(IngestionDataSourceSettings.newBuilder().build()).build();
        mockPublisher.addResponse((AbstractMessage)expectedResponse);
        TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
        Topic actualResponse = this.client.getTopic(topic);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockPublisher.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetTopicRequest actualRequest = (GetTopicRequest)actualRequests.get(0);
        Assert.assertEquals((Object)topic.toString(), (Object)actualRequest.getTopic());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getTopicExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPublisher.addException((Exception)exception);
        try {
            TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
            this.client.getTopic(topic);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getTopicTest2() throws Exception {
        Topic expectedResponse = Topic.newBuilder().setName(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).putAllLabels(new HashMap()).setMessageStoragePolicy(MessageStoragePolicy.newBuilder().build()).setKmsKeyName("kmsKeyName412586233").setSchemaSettings(SchemaSettings.newBuilder().build()).setSatisfiesPzs(true).setMessageRetentionDuration(Duration.newBuilder().build()).setIngestionDataSourceSettings(IngestionDataSourceSettings.newBuilder().build()).build();
        mockPublisher.addResponse((AbstractMessage)expectedResponse);
        String topic = "topic110546223";
        Topic actualResponse = this.client.getTopic(topic);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockPublisher.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetTopicRequest actualRequest = (GetTopicRequest)actualRequests.get(0);
        Assert.assertEquals((Object)topic, (Object)actualRequest.getTopic());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getTopicExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPublisher.addException((Exception)exception);
        try {
            String topic = "topic110546223";
            this.client.getTopic(topic);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTopicsTest() throws Exception {
        Topic responsesElement = Topic.newBuilder().build();
        ListTopicsResponse expectedResponse = ListTopicsResponse.newBuilder().setNextPageToken("").addAllTopics(Arrays.asList(responsesElement)).build();
        mockPublisher.addResponse((AbstractMessage)expectedResponse);
        ProjectName project = ProjectName.of((String)"[PROJECT]");
        TopicAdminClient.ListTopicsPagedResponse pagedListResponse = this.client.listTopics(project);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getTopicsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockPublisher.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListTopicsRequest actualRequest = (ListTopicsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)project.toString(), (Object)actualRequest.getProject());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listTopicsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPublisher.addException((Exception)exception);
        try {
            ProjectName project = ProjectName.of((String)"[PROJECT]");
            this.client.listTopics(project);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTopicsTest2() throws Exception {
        Topic responsesElement = Topic.newBuilder().build();
        ListTopicsResponse expectedResponse = ListTopicsResponse.newBuilder().setNextPageToken("").addAllTopics(Arrays.asList(responsesElement)).build();
        mockPublisher.addResponse((AbstractMessage)expectedResponse);
        String project = "project-309310695";
        TopicAdminClient.ListTopicsPagedResponse pagedListResponse = this.client.listTopics(project);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getTopicsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockPublisher.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListTopicsRequest actualRequest = (ListTopicsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)project, (Object)actualRequest.getProject());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listTopicsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPublisher.addException((Exception)exception);
        try {
            String project = "project-309310695";
            this.client.listTopics(project);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTopicSubscriptionsTest() throws Exception {
        String responsesElement = "responsesElement-318365110";
        ListTopicSubscriptionsResponse expectedResponse = ListTopicSubscriptionsResponse.newBuilder().setNextPageToken("").addAllSubscriptions(Arrays.asList(responsesElement)).build();
        mockPublisher.addResponse((AbstractMessage)expectedResponse);
        TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
        TopicAdminClient.ListTopicSubscriptionsPagedResponse pagedListResponse = this.client.listTopicSubscriptions(topic);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)expectedResponse.getSubscriptionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockPublisher.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListTopicSubscriptionsRequest actualRequest = (ListTopicSubscriptionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)topic.toString(), (Object)actualRequest.getTopic());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listTopicSubscriptionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPublisher.addException((Exception)exception);
        try {
            TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
            this.client.listTopicSubscriptions(topic);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTopicSubscriptionsTest2() throws Exception {
        String responsesElement = "responsesElement-318365110";
        ListTopicSubscriptionsResponse expectedResponse = ListTopicSubscriptionsResponse.newBuilder().setNextPageToken("").addAllSubscriptions(Arrays.asList(responsesElement)).build();
        mockPublisher.addResponse((AbstractMessage)expectedResponse);
        String topic = "topic110546223";
        TopicAdminClient.ListTopicSubscriptionsPagedResponse pagedListResponse = this.client.listTopicSubscriptions(topic);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)expectedResponse.getSubscriptionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockPublisher.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListTopicSubscriptionsRequest actualRequest = (ListTopicSubscriptionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)topic, (Object)actualRequest.getTopic());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listTopicSubscriptionsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPublisher.addException((Exception)exception);
        try {
            String topic = "topic110546223";
            this.client.listTopicSubscriptions(topic);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTopicSnapshotsTest() throws Exception {
        String responsesElement = "responsesElement-318365110";
        ListTopicSnapshotsResponse expectedResponse = ListTopicSnapshotsResponse.newBuilder().setNextPageToken("").addAllSnapshots(Arrays.asList(responsesElement)).build();
        mockPublisher.addResponse((AbstractMessage)expectedResponse);
        TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
        TopicAdminClient.ListTopicSnapshotsPagedResponse pagedListResponse = this.client.listTopicSnapshots(topic);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)expectedResponse.getSnapshotsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockPublisher.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListTopicSnapshotsRequest actualRequest = (ListTopicSnapshotsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)topic.toString(), (Object)actualRequest.getTopic());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listTopicSnapshotsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPublisher.addException((Exception)exception);
        try {
            TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
            this.client.listTopicSnapshots(topic);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTopicSnapshotsTest2() throws Exception {
        String responsesElement = "responsesElement-318365110";
        ListTopicSnapshotsResponse expectedResponse = ListTopicSnapshotsResponse.newBuilder().setNextPageToken("").addAllSnapshots(Arrays.asList(responsesElement)).build();
        mockPublisher.addResponse((AbstractMessage)expectedResponse);
        String topic = "topic110546223";
        TopicAdminClient.ListTopicSnapshotsPagedResponse pagedListResponse = this.client.listTopicSnapshots(topic);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)expectedResponse.getSnapshotsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockPublisher.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListTopicSnapshotsRequest actualRequest = (ListTopicSnapshotsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)topic, (Object)actualRequest.getTopic());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listTopicSnapshotsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPublisher.addException((Exception)exception);
        try {
            String topic = "topic110546223";
            this.client.listTopicSnapshots(topic);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteTopicTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockPublisher.addResponse((AbstractMessage)expectedResponse);
        TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
        this.client.deleteTopic(topic);
        List<AbstractMessage> actualRequests = mockPublisher.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteTopicRequest actualRequest = (DeleteTopicRequest)actualRequests.get(0);
        Assert.assertEquals((Object)topic.toString(), (Object)actualRequest.getTopic());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteTopicExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPublisher.addException((Exception)exception);
        try {
            TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
            this.client.deleteTopic(topic);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteTopicTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockPublisher.addResponse((AbstractMessage)expectedResponse);
        String topic = "topic110546223";
        this.client.deleteTopic(topic);
        List<AbstractMessage> actualRequests = mockPublisher.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteTopicRequest actualRequest = (DeleteTopicRequest)actualRequests.get(0);
        Assert.assertEquals((Object)topic, (Object)actualRequest.getTopic());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteTopicExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPublisher.addException((Exception)exception);
        try {
            String topic = "topic110546223";
            this.client.deleteTopic(topic);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void detachSubscriptionTest() throws Exception {
        DetachSubscriptionResponse expectedResponse = DetachSubscriptionResponse.newBuilder().build();
        mockPublisher.addResponse((AbstractMessage)expectedResponse);
        DetachSubscriptionRequest request = DetachSubscriptionRequest.newBuilder().setSubscription(SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]").toString()).build();
        DetachSubscriptionResponse actualResponse = this.client.detachSubscription(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockPublisher.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DetachSubscriptionRequest actualRequest = (DetachSubscriptionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getSubscription(), (Object)actualRequest.getSubscription());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void detachSubscriptionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockPublisher.addException((Exception)exception);
        try {
            DetachSubscriptionRequest request = DetachSubscriptionRequest.newBuilder().setSubscription(SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]").toString()).build();
            this.client.detachSubscription(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockIAMPolicy.addResponse((AbstractMessage)expectedResponse);
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setPolicy(Policy.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).build();
        Policy actualResponse = this.client.setIamPolicy(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockIAMPolicy.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetIamPolicyRequest actualRequest = (SetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getResource(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)request.getPolicy(), (Object)actualRequest.getPolicy());
        Assert.assertEquals((Object)request.getUpdateMask(), (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockIAMPolicy.addException((Exception)exception);
        try {
            SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setPolicy(Policy.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).build();
            this.client.setIamPolicy(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockIAMPolicy.addResponse((AbstractMessage)expectedResponse);
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setOptions(GetPolicyOptions.newBuilder().build()).build();
        Policy actualResponse = this.client.getIamPolicy(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockIAMPolicy.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIamPolicyRequest actualRequest = (GetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getResource(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)request.getOptions(), (Object)actualRequest.getOptions());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockIAMPolicy.addException((Exception)exception);
        try {
            GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setOptions(GetPolicyOptions.newBuilder().build()).build();
            this.client.getIamPolicy(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockIAMPolicy.addResponse((AbstractMessage)expectedResponse);
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).addAllPermissions(new ArrayList()).build();
        TestIamPermissionsResponse actualResponse = this.client.testIamPermissions(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockIAMPolicy.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TestIamPermissionsRequest actualRequest = (TestIamPermissionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getResource(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)request.getPermissionsList(), (Object)actualRequest.getPermissionsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockIAMPolicy.addException((Exception)exception);
        try {
            TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).addAllPermissions(new ArrayList()).build();
            this.client.testIamPermissions(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

