/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import io.grpc.StatusRuntimeException;

final class StatusUtil {
    private StatusUtil() {
    }

    public static boolean isRetryable(Throwable error) {
        if (!(error instanceof StatusRuntimeException)) {
            return true;
        }
        StatusRuntimeException statusRuntimeException = (StatusRuntimeException)error;
        switch (statusRuntimeException.getStatus().getCode()) {
            case DEADLINE_EXCEEDED: 
            case INTERNAL: 
            case CANCELLED: 
            case RESOURCE_EXHAUSTED: 
            case ABORTED: {
                return true;
            }
            case UNAVAILABLE: {
                return !statusRuntimeException.getMessage().contains("Server shutdownNow invoked");
            }
        }
        return false;
    }
}

