package com.google.cloud.pubsublite.cloudpubsub;

import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsublite.MessageTransformer;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SequencedMessage;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.proto.CursorServiceGrpc;
import com.google.cloud.pubsublite.proto.SubscriberServiceGrpc;
import com.google.common.collect.ImmutableList;
import com.google.pubsub.v1.PubsubMessage;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SubscriberSettings extends SubscriberSettings {

  private final MessageReceiver receiver;

  private final SubscriptionPath subscriptionPath;

  private final ImmutableList<Partition> partitions;

  private final FlowControlSettings perPartitionFlowControlSettings;

  private final Optional<MessageTransformer<SequencedMessage, PubsubMessage>> transformer;

  private final Optional<SubscriberServiceGrpc.SubscriberServiceStub> subscriberServiceStub;

  private final Optional<CursorServiceGrpc.CursorServiceStub> cursorServiceStub;

  private final Optional<NackHandler> nackHandler;

  private AutoValue_SubscriberSettings(
      MessageReceiver receiver,
      SubscriptionPath subscriptionPath,
      ImmutableList<Partition> partitions,
      FlowControlSettings perPartitionFlowControlSettings,
      Optional<MessageTransformer<SequencedMessage, PubsubMessage>> transformer,
      Optional<SubscriberServiceGrpc.SubscriberServiceStub> subscriberServiceStub,
      Optional<CursorServiceGrpc.CursorServiceStub> cursorServiceStub,
      Optional<NackHandler> nackHandler) {
    this.receiver = receiver;
    this.subscriptionPath = subscriptionPath;
    this.partitions = partitions;
    this.perPartitionFlowControlSettings = perPartitionFlowControlSettings;
    this.transformer = transformer;
    this.subscriberServiceStub = subscriberServiceStub;
    this.cursorServiceStub = cursorServiceStub;
    this.nackHandler = nackHandler;
  }

  @Override
  MessageReceiver receiver() {
    return receiver;
  }

  @Override
  SubscriptionPath subscriptionPath() {
    return subscriptionPath;
  }

  @Override
  ImmutableList<Partition> partitions() {
    return partitions;
  }

  @Override
  FlowControlSettings perPartitionFlowControlSettings() {
    return perPartitionFlowControlSettings;
  }

  @Override
  Optional<MessageTransformer<SequencedMessage, PubsubMessage>> transformer() {
    return transformer;
  }

  @Override
  Optional<SubscriberServiceGrpc.SubscriberServiceStub> subscriberServiceStub() {
    return subscriberServiceStub;
  }

  @Override
  Optional<CursorServiceGrpc.CursorServiceStub> cursorServiceStub() {
    return cursorServiceStub;
  }

  @Override
  Optional<NackHandler> nackHandler() {
    return nackHandler;
  }

  @Override
  public String toString() {
    return "SubscriberSettings{"
         + "receiver=" + receiver + ", "
         + "subscriptionPath=" + subscriptionPath + ", "
         + "partitions=" + partitions + ", "
         + "perPartitionFlowControlSettings=" + perPartitionFlowControlSettings + ", "
         + "transformer=" + transformer + ", "
         + "subscriberServiceStub=" + subscriberServiceStub + ", "
         + "cursorServiceStub=" + cursorServiceStub + ", "
         + "nackHandler=" + nackHandler
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SubscriberSettings) {
      SubscriberSettings that = (SubscriberSettings) o;
      return this.receiver.equals(that.receiver())
          && this.subscriptionPath.equals(that.subscriptionPath())
          && this.partitions.equals(that.partitions())
          && this.perPartitionFlowControlSettings.equals(that.perPartitionFlowControlSettings())
          && this.transformer.equals(that.transformer())
          && this.subscriberServiceStub.equals(that.subscriberServiceStub())
          && this.cursorServiceStub.equals(that.cursorServiceStub())
          && this.nackHandler.equals(that.nackHandler());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= receiver.hashCode();
    h$ *= 1000003;
    h$ ^= subscriptionPath.hashCode();
    h$ *= 1000003;
    h$ ^= partitions.hashCode();
    h$ *= 1000003;
    h$ ^= perPartitionFlowControlSettings.hashCode();
    h$ *= 1000003;
    h$ ^= transformer.hashCode();
    h$ *= 1000003;
    h$ ^= subscriberServiceStub.hashCode();
    h$ *= 1000003;
    h$ ^= cursorServiceStub.hashCode();
    h$ *= 1000003;
    h$ ^= nackHandler.hashCode();
    return h$;
  }

  static final class Builder extends SubscriberSettings.Builder {
    private MessageReceiver receiver;
    private SubscriptionPath subscriptionPath;
    private ImmutableList<Partition> partitions;
    private FlowControlSettings perPartitionFlowControlSettings;
    private Optional<MessageTransformer<SequencedMessage, PubsubMessage>> transformer = Optional.empty();
    private Optional<SubscriberServiceGrpc.SubscriberServiceStub> subscriberServiceStub = Optional.empty();
    private Optional<CursorServiceGrpc.CursorServiceStub> cursorServiceStub = Optional.empty();
    private Optional<NackHandler> nackHandler = Optional.empty();
    Builder() {
    }
    @Override
    public SubscriberSettings.Builder setReceiver(MessageReceiver receiver) {
      if (receiver == null) {
        throw new NullPointerException("Null receiver");
      }
      this.receiver = receiver;
      return this;
    }
    @Override
    public SubscriberSettings.Builder setSubscriptionPath(SubscriptionPath subscriptionPath) {
      if (subscriptionPath == null) {
        throw new NullPointerException("Null subscriptionPath");
      }
      this.subscriptionPath = subscriptionPath;
      return this;
    }
    @Override
    public SubscriberSettings.Builder setPartitions(List<Partition> partitions) {
      this.partitions = ImmutableList.copyOf(partitions);
      return this;
    }
    @Override
    public SubscriberSettings.Builder setPerPartitionFlowControlSettings(FlowControlSettings perPartitionFlowControlSettings) {
      if (perPartitionFlowControlSettings == null) {
        throw new NullPointerException("Null perPartitionFlowControlSettings");
      }
      this.perPartitionFlowControlSettings = perPartitionFlowControlSettings;
      return this;
    }
    @Override
    public SubscriberSettings.Builder setTransformer(MessageTransformer<SequencedMessage, PubsubMessage> transformer) {
      this.transformer = Optional.of(transformer);
      return this;
    }
    @Override
    public SubscriberSettings.Builder setSubscriberServiceStub(SubscriberServiceGrpc.SubscriberServiceStub subscriberServiceStub) {
      this.subscriberServiceStub = Optional.of(subscriberServiceStub);
      return this;
    }
    @Override
    public SubscriberSettings.Builder setCursorServiceStub(CursorServiceGrpc.CursorServiceStub cursorServiceStub) {
      this.cursorServiceStub = Optional.of(cursorServiceStub);
      return this;
    }
    @Override
    public SubscriberSettings.Builder setNackHandler(NackHandler nackHandler) {
      this.nackHandler = Optional.of(nackHandler);
      return this;
    }
    @Override
    SubscriberSettings autoBuild() {
      String missing = "";
      if (this.receiver == null) {
        missing += " receiver";
      }
      if (this.subscriptionPath == null) {
        missing += " subscriptionPath";
      }
      if (this.partitions == null) {
        missing += " partitions";
      }
      if (this.perPartitionFlowControlSettings == null) {
        missing += " perPartitionFlowControlSettings";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SubscriberSettings(
          this.receiver,
          this.subscriptionPath,
          this.partitions,
          this.perPartitionFlowControlSettings,
          this.transformer,
          this.subscriberServiceStub,
          this.cursorServiceStub,
          this.nackHandler);
    }
  }

}
