/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SequencedMessage;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.SubscriberBuilder;
import com.google.cloud.pubsublite.proto.SubscriberServiceGrpc;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import java.util.function.Consumer;

final class AutoValue_SubscriberBuilder
extends SubscriberBuilder {
    private final Consumer<ImmutableList<SequencedMessage>> messageConsumer;
    private final SubscriptionPath subscriptionPath;
    private final Partition partition;
    private final Optional<SubscriberServiceGrpc.SubscriberServiceStub> subscriberServiceStub;
    private final PubsubContext context;

    private AutoValue_SubscriberBuilder(Consumer<ImmutableList<SequencedMessage>> messageConsumer, SubscriptionPath subscriptionPath, Partition partition, Optional<SubscriberServiceGrpc.SubscriberServiceStub> subscriberServiceStub, PubsubContext context) {
        this.messageConsumer = messageConsumer;
        this.subscriptionPath = subscriptionPath;
        this.partition = partition;
        this.subscriberServiceStub = subscriberServiceStub;
        this.context = context;
    }

    @Override
    Consumer<ImmutableList<SequencedMessage>> messageConsumer() {
        return this.messageConsumer;
    }

    @Override
    SubscriptionPath subscriptionPath() {
        return this.subscriptionPath;
    }

    @Override
    Partition partition() {
        return this.partition;
    }

    @Override
    Optional<SubscriberServiceGrpc.SubscriberServiceStub> subscriberServiceStub() {
        return this.subscriberServiceStub;
    }

    @Override
    PubsubContext context() {
        return this.context;
    }

    public String toString() {
        return "SubscriberBuilder{messageConsumer=" + this.messageConsumer + ", subscriptionPath=" + this.subscriptionPath + ", partition=" + this.partition + ", subscriberServiceStub=" + this.subscriberServiceStub + ", context=" + this.context + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SubscriberBuilder) {
            SubscriberBuilder that = (SubscriberBuilder)o;
            return this.messageConsumer.equals(that.messageConsumer()) && this.subscriptionPath.equals(that.subscriptionPath()) && this.partition.equals(that.partition()) && this.subscriberServiceStub.equals(that.subscriberServiceStub()) && this.context.equals(that.context());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.messageConsumer.hashCode();
        h$ *= 1000003;
        h$ ^= this.subscriptionPath.hashCode();
        h$ *= 1000003;
        h$ ^= this.partition.hashCode();
        h$ *= 1000003;
        h$ ^= this.subscriberServiceStub.hashCode();
        h$ *= 1000003;
        return h$ ^= this.context.hashCode();
    }

    static final class Builder
    extends SubscriberBuilder.Builder {
        private Consumer<ImmutableList<SequencedMessage>> messageConsumer;
        private SubscriptionPath subscriptionPath;
        private Partition partition;
        private Optional<SubscriberServiceGrpc.SubscriberServiceStub> subscriberServiceStub = Optional.empty();
        private PubsubContext context;

        Builder() {
        }

        @Override
        public SubscriberBuilder.Builder setMessageConsumer(Consumer<ImmutableList<SequencedMessage>> messageConsumer) {
            if (messageConsumer == null) {
                throw new NullPointerException("Null messageConsumer");
            }
            this.messageConsumer = messageConsumer;
            return this;
        }

        @Override
        public SubscriberBuilder.Builder setSubscriptionPath(SubscriptionPath subscriptionPath) {
            if (subscriptionPath == null) {
                throw new NullPointerException("Null subscriptionPath");
            }
            this.subscriptionPath = subscriptionPath;
            return this;
        }

        @Override
        public SubscriberBuilder.Builder setPartition(Partition partition) {
            if (partition == null) {
                throw new NullPointerException("Null partition");
            }
            this.partition = partition;
            return this;
        }

        @Override
        public SubscriberBuilder.Builder setSubscriberServiceStub(SubscriberServiceGrpc.SubscriberServiceStub subscriberServiceStub) {
            this.subscriberServiceStub = Optional.of(subscriberServiceStub);
            return this;
        }

        @Override
        public SubscriberBuilder.Builder setContext(PubsubContext context) {
            if (context == null) {
                throw new NullPointerException("Null context");
            }
            this.context = context;
            return this;
        }

        @Override
        SubscriberBuilder autoBuild() {
            String missing = "";
            if (this.messageConsumer == null) {
                missing = missing + " messageConsumer";
            }
            if (this.subscriptionPath == null) {
                missing = missing + " subscriptionPath";
            }
            if (this.partition == null) {
                missing = missing + " partition";
            }
            if (this.context == null) {
                missing = missing + " context";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SubscriberBuilder(this.messageConsumer, this.subscriptionPath, this.partition, this.subscriberServiceStub, this.context);
        }
    }
}

