package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SequencedMessage;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.proto.SubscriberServiceGrpc;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SubscriberBuilder extends SubscriberBuilder {

  private final Consumer<ImmutableList<SequencedMessage>> messageConsumer;

  private final SubscriptionPath subscriptionPath;

  private final Partition partition;

  private final Optional<SubscriberServiceGrpc.SubscriberServiceStub> subscriberServiceStub;

  private final PubsubContext context;

  private AutoValue_SubscriberBuilder(
      Consumer<ImmutableList<SequencedMessage>> messageConsumer,
      SubscriptionPath subscriptionPath,
      Partition partition,
      Optional<SubscriberServiceGrpc.SubscriberServiceStub> subscriberServiceStub,
      PubsubContext context) {
    this.messageConsumer = messageConsumer;
    this.subscriptionPath = subscriptionPath;
    this.partition = partition;
    this.subscriberServiceStub = subscriberServiceStub;
    this.context = context;
  }

  @Override
  Consumer<ImmutableList<SequencedMessage>> messageConsumer() {
    return messageConsumer;
  }

  @Override
  SubscriptionPath subscriptionPath() {
    return subscriptionPath;
  }

  @Override
  Partition partition() {
    return partition;
  }

  @Override
  Optional<SubscriberServiceGrpc.SubscriberServiceStub> subscriberServiceStub() {
    return subscriberServiceStub;
  }

  @Override
  PubsubContext context() {
    return context;
  }

  @Override
  public String toString() {
    return "SubscriberBuilder{"
         + "messageConsumer=" + messageConsumer + ", "
         + "subscriptionPath=" + subscriptionPath + ", "
         + "partition=" + partition + ", "
         + "subscriberServiceStub=" + subscriberServiceStub + ", "
         + "context=" + context
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SubscriberBuilder) {
      SubscriberBuilder that = (SubscriberBuilder) o;
      return this.messageConsumer.equals(that.messageConsumer())
          && this.subscriptionPath.equals(that.subscriptionPath())
          && this.partition.equals(that.partition())
          && this.subscriberServiceStub.equals(that.subscriberServiceStub())
          && this.context.equals(that.context());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= messageConsumer.hashCode();
    h$ *= 1000003;
    h$ ^= subscriptionPath.hashCode();
    h$ *= 1000003;
    h$ ^= partition.hashCode();
    h$ *= 1000003;
    h$ ^= subscriberServiceStub.hashCode();
    h$ *= 1000003;
    h$ ^= context.hashCode();
    return h$;
  }

  static final class Builder extends SubscriberBuilder.Builder {
    private Consumer<ImmutableList<SequencedMessage>> messageConsumer;
    private SubscriptionPath subscriptionPath;
    private Partition partition;
    private Optional<SubscriberServiceGrpc.SubscriberServiceStub> subscriberServiceStub = Optional.empty();
    private PubsubContext context;
    Builder() {
    }
    @Override
    public SubscriberBuilder.Builder setMessageConsumer(Consumer<ImmutableList<SequencedMessage>> messageConsumer) {
      if (messageConsumer == null) {
        throw new NullPointerException("Null messageConsumer");
      }
      this.messageConsumer = messageConsumer;
      return this;
    }
    @Override
    public SubscriberBuilder.Builder setSubscriptionPath(SubscriptionPath subscriptionPath) {
      if (subscriptionPath == null) {
        throw new NullPointerException("Null subscriptionPath");
      }
      this.subscriptionPath = subscriptionPath;
      return this;
    }
    @Override
    public SubscriberBuilder.Builder setPartition(Partition partition) {
      if (partition == null) {
        throw new NullPointerException("Null partition");
      }
      this.partition = partition;
      return this;
    }
    @Override
    public SubscriberBuilder.Builder setSubscriberServiceStub(SubscriberServiceGrpc.SubscriberServiceStub subscriberServiceStub) {
      this.subscriberServiceStub = Optional.of(subscriberServiceStub);
      return this;
    }
    @Override
    public SubscriberBuilder.Builder setContext(PubsubContext context) {
      if (context == null) {
        throw new NullPointerException("Null context");
      }
      this.context = context;
      return this;
    }
    @Override
    SubscriberBuilder autoBuild() {
      String missing = "";
      if (this.messageConsumer == null) {
        missing += " messageConsumer";
      }
      if (this.subscriptionPath == null) {
        missing += " subscriptionPath";
      }
      if (this.partition == null) {
        missing += " partition";
      }
      if (this.context == null) {
        missing += " context";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SubscriberBuilder(
          this.messageConsumer,
          this.subscriptionPath,
          this.partition,
          this.subscriberServiceStub,
          this.context);
    }
  }

}
