/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.api.gax.retrying.RetrySettings;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.AutoValue_AdminClientSettings;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.Endpoints;
import com.google.cloud.pubsublite.Stubs;
import com.google.cloud.pubsublite.internal.AdminClientImpl;
import com.google.cloud.pubsublite.proto.AdminServiceGrpc;
import io.grpc.Status;
import io.grpc.StatusException;
import java.io.IOException;
import java.util.Optional;
import org.threeten.bp.Duration;

@AutoValue
public abstract class AdminClientSettings {
    public static final RetrySettings DEFAULT_RETRY_SETTINGS = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofSeconds((long)60L)).setJittered(true).setTotalTimeout(Duration.ofMinutes((long)10L)).build();

    abstract CloudRegion region();

    abstract Optional<RetrySettings> retrySettings();

    abstract Optional<AdminServiceGrpc.AdminServiceBlockingStub> stub();

    public static Builder newBuilder() {
        return new AutoValue_AdminClientSettings.Builder();
    }

    AdminClient instantiate() throws StatusException {
        AdminServiceGrpc.AdminServiceBlockingStub stub;
        if (this.stub().isPresent()) {
            stub = this.stub().get();
        } else {
            try {
                stub = Stubs.defaultStub(Endpoints.regionalEndpoint(this.region()), AdminServiceGrpc::newBlockingStub);
            }
            catch (IOException e) {
                throw Status.INTERNAL.withCause((Throwable)e).withDescription("Creating admin stub failed.").asException();
            }
        }
        return new AdminClientImpl(this.region(), stub, this.retrySettings().orElse(DEFAULT_RETRY_SETTINGS));
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setRegion(CloudRegion var1);

        public abstract Builder setRetrySettings(RetrySettings var1);

        public abstract Builder setStub(AdminServiceGrpc.AdminServiceBlockingStub var1);

        public abstract AdminClientSettings build();
    }
}

