/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.AutoValue_LocationPaths;
import com.google.cloud.pubsublite.CloudZone;
import com.google.cloud.pubsublite.LocationPath;
import com.google.cloud.pubsublite.ProjectNumber;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.Preconditions;
import io.grpc.StatusException;

@AutoValue
public abstract class LocationPaths {
    abstract ProjectNumber projectNumber();

    abstract CloudZone zone();

    public static Builder newBuilder() {
        return new AutoValue_LocationPaths.Builder();
    }

    private static void checkSplits(String[] splits) throws StatusException {
        Preconditions.checkArgument(splits.length == 4);
        Preconditions.checkArgument(splits[0].equals("projects"));
        Preconditions.checkArgument(splits[2].equals("locations"));
    }

    public static void check(LocationPath path) throws StatusException {
        ProjectNumber unusedProjectNumber = LocationPaths.getProjectNumber(path);
        CloudZone unusedZone = LocationPaths.getZone(path);
    }

    public static ProjectNumber getProjectNumber(LocationPath path) throws StatusException {
        String[] splits = path.value().split("/");
        LocationPaths.checkSplits(splits);
        try {
            return ProjectNumber.of(Long.parseLong(splits[1]));
        }
        catch (NumberFormatException e) {
            throw ExtractStatus.toCanonical(e);
        }
    }

    public static CloudZone getZone(LocationPath path) throws StatusException {
        String[] splits = path.value().split("/");
        LocationPaths.checkSplits(splits);
        return CloudZone.parse(splits[3]);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setProjectNumber(ProjectNumber var1);

        public abstract Builder setZone(CloudZone var1);

        abstract LocationPaths autoBuild();

        public LocationPath build() {
            LocationPaths built = this.autoBuild();
            return LocationPath.of(String.format("projects/%s/locations/%s", built.projectNumber().value(), built.zone()));
        }
    }
}

