/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.api.core.ApiFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;

public final class ExtractStatus {
    public static Optional<Status> extract(Throwable t) {
        if (t instanceof StatusException) {
            return Optional.of(((StatusException)t).getStatus());
        }
        if (t instanceof StatusRuntimeException) {
            return Optional.of(((StatusRuntimeException)t).getStatus());
        }
        return Optional.empty();
    }

    public static StatusException toCanonical(Throwable t) {
        Optional<Status> statusOr = ExtractStatus.extract(t);
        if (statusOr.isPresent()) {
            return statusOr.get().asException();
        }
        return Status.INTERNAL.withCause(t).asException();
    }

    public static void addFailureHandler(ApiFuture<?> future, Consumer<StatusException> consumer) {
        future.addListener(() -> {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                consumer.accept(ExtractStatus.toCanonical(e.getCause()));
            }
            catch (InterruptedException e) {
                consumer.accept(ExtractStatus.toCanonical(e));
            }
        }, MoreExecutors.directExecutor());
    }

    private ExtractStatus() {
    }
}

