/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.pubsublite.Message;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.PublishMetadata;
import com.google.cloud.pubsublite.internal.ProxyService;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.StatusException;
import java.io.IOException;
import java.util.concurrent.Executor;

public class SinglePartitionPublisher
extends ProxyService
implements Publisher<PublishMetadata> {
    private final Publisher<Offset> publisher;
    private final Partition partition;

    SinglePartitionPublisher(Publisher<Offset> publisher, Partition partition) throws StatusException {
        this.publisher = publisher;
        this.partition = partition;
        this.addServices(publisher);
    }

    @Override
    protected void start() {
    }

    @Override
    protected void stop() {
    }

    @Override
    protected void handlePermanentError(StatusException error) {
    }

    @Override
    public ApiFuture<PublishMetadata> publish(Message message) {
        return ApiFutures.transform(this.publisher.publish(message), offset -> PublishMetadata.of(this.partition, offset), (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public void flush() throws IOException {
        this.publisher.flush();
    }
}

