/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.SequencedMessage;
import com.google.cloud.pubsublite.internal.Preconditions;
import com.google.cloud.pubsublite.proto.FlowControlRequest;
import com.google.common.math.LongMath;
import io.grpc.StatusException;
import java.util.Collection;
import java.util.Optional;

class TokenCounter {
    private long bytes = 0L;
    private long messages = 0L;

    TokenCounter() {
    }

    void onClientFlowRequest(FlowControlRequest request) throws StatusException {
        Preconditions.checkArgument(request.getAllowedMessages() >= 0L);
        Preconditions.checkArgument(request.getAllowedBytes() >= 0L);
        this.bytes = LongMath.saturatedAdd((long)this.bytes, (long)request.getAllowedBytes());
        this.messages = LongMath.saturatedAdd((long)this.messages, (long)request.getAllowedMessages());
    }

    void onMessages(Collection<SequencedMessage> received) throws StatusException {
        long byteSize = received.stream().mapToLong(SequencedMessage::byteSize).sum();
        Preconditions.checkState(byteSize <= this.bytes, "Received messages that account for more bytes than were requested.");
        Preconditions.checkState((long)received.size() <= this.messages, "Received more messages than were requested.");
        this.bytes -= byteSize;
        this.messages -= (long)received.size();
    }

    Optional<FlowControlRequest> requestForRestart() {
        if (this.bytes == 0L && this.messages == 0L) {
            return Optional.empty();
        }
        return Optional.of(FlowControlRequest.newBuilder().setAllowedBytes(this.bytes).setAllowedMessages(this.messages).build());
    }
}

