package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.batching.BatchingSettings;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.proto.PublisherServiceGrpc;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SinglePartitionPublisherBuilder extends SinglePartitionPublisherBuilder {

  private final TopicPath topic;

  private final Partition partition;

  private final Optional<PublisherServiceGrpc.PublisherServiceStub> stub;

  private final Optional<BatchingSettings> batchingSettings;

  private final PubsubContext context;

  private AutoValue_SinglePartitionPublisherBuilder(
      TopicPath topic,
      Partition partition,
      Optional<PublisherServiceGrpc.PublisherServiceStub> stub,
      Optional<BatchingSettings> batchingSettings,
      PubsubContext context) {
    this.topic = topic;
    this.partition = partition;
    this.stub = stub;
    this.batchingSettings = batchingSettings;
    this.context = context;
  }

  @Override
  TopicPath topic() {
    return topic;
  }

  @Override
  Partition partition() {
    return partition;
  }

  @Override
  Optional<PublisherServiceGrpc.PublisherServiceStub> stub() {
    return stub;
  }

  @Override
  Optional<BatchingSettings> batchingSettings() {
    return batchingSettings;
  }

  @Override
  PubsubContext context() {
    return context;
  }

  @Override
  public String toString() {
    return "SinglePartitionPublisherBuilder{"
         + "topic=" + topic + ", "
         + "partition=" + partition + ", "
         + "stub=" + stub + ", "
         + "batchingSettings=" + batchingSettings + ", "
         + "context=" + context
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SinglePartitionPublisherBuilder) {
      SinglePartitionPublisherBuilder that = (SinglePartitionPublisherBuilder) o;
      return this.topic.equals(that.topic())
          && this.partition.equals(that.partition())
          && this.stub.equals(that.stub())
          && this.batchingSettings.equals(that.batchingSettings())
          && this.context.equals(that.context());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= topic.hashCode();
    h$ *= 1000003;
    h$ ^= partition.hashCode();
    h$ *= 1000003;
    h$ ^= stub.hashCode();
    h$ *= 1000003;
    h$ ^= batchingSettings.hashCode();
    h$ *= 1000003;
    h$ ^= context.hashCode();
    return h$;
  }

  static final class Builder extends SinglePartitionPublisherBuilder.Builder {
    private TopicPath topic;
    private Partition partition;
    private Optional<PublisherServiceGrpc.PublisherServiceStub> stub = Optional.empty();
    private Optional<BatchingSettings> batchingSettings = Optional.empty();
    private PubsubContext context;
    Builder() {
    }
    @Override
    public SinglePartitionPublisherBuilder.Builder setTopic(TopicPath topic) {
      if (topic == null) {
        throw new NullPointerException("Null topic");
      }
      this.topic = topic;
      return this;
    }
    @Override
    public SinglePartitionPublisherBuilder.Builder setPartition(Partition partition) {
      if (partition == null) {
        throw new NullPointerException("Null partition");
      }
      this.partition = partition;
      return this;
    }
    @Override
    public SinglePartitionPublisherBuilder.Builder setStub(Optional<PublisherServiceGrpc.PublisherServiceStub> stub) {
      if (stub == null) {
        throw new NullPointerException("Null stub");
      }
      this.stub = stub;
      return this;
    }
    @Override
    public SinglePartitionPublisherBuilder.Builder setBatchingSettings(Optional<BatchingSettings> batchingSettings) {
      if (batchingSettings == null) {
        throw new NullPointerException("Null batchingSettings");
      }
      this.batchingSettings = batchingSettings;
      return this;
    }
    @Override
    public SinglePartitionPublisherBuilder.Builder setContext(PubsubContext context) {
      if (context == null) {
        throw new NullPointerException("Null context");
      }
      this.context = context;
      return this;
    }
    @Override
    SinglePartitionPublisherBuilder autoBuild() {
      String missing = "";
      if (this.topic == null) {
        missing += " topic";
      }
      if (this.partition == null) {
        missing += " partition";
      }
      if (this.context == null) {
        missing += " context";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SinglePartitionPublisherBuilder(
          this.topic,
          this.partition,
          this.stub,
          this.batchingSettings,
          this.context);
    }
  }

}
