/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.AutoValue_ProjectPaths;
import com.google.cloud.pubsublite.ProjectNumber;
import com.google.cloud.pubsublite.ProjectPath;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.Preconditions;
import io.grpc.StatusException;

@AutoValue
public abstract class ProjectPaths {
    abstract ProjectNumber projectNumber();

    public static Builder newBuilder() {
        return new AutoValue_ProjectPaths.Builder();
    }

    private static void checkSplits(String[] splits) throws StatusException {
        Preconditions.checkArgument(splits.length == 2);
        Preconditions.checkArgument(splits[0].equals("projects"));
    }

    public static void check(ProjectPath path) throws StatusException {
        ProjectNumber unusedProjectNumber = ProjectPaths.getProjectNumber(path);
    }

    public static ProjectNumber getProjectNumber(ProjectPath path) throws StatusException {
        String[] splits = path.value().split("/");
        ProjectPaths.checkSplits(splits);
        try {
            return ProjectNumber.of(Long.parseLong(splits[1]));
        }
        catch (NumberFormatException e) {
            throw ExtractStatus.toCanonical(e);
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setProjectNumber(ProjectNumber var1);

        abstract ProjectPaths autoBuild();

        public ProjectPath build() {
            ProjectPaths built = this.autoBuild();
            return ProjectPath.of(String.format("projects/%s", built.projectNumber().value()));
        }
    }
}

