/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class ChannelCache {
    private final ConcurrentHashMap<String, ManagedChannel> channels = new ConcurrentHashMap();

    public ChannelCache() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::onShutdown));
    }

    private void onShutdown() {
        this.channels.forEachValue(this.channels.size(), channel -> {
            try {
                channel.shutdownNow().awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
    }

    public Channel get(String target) {
        return (Channel)this.channels.computeIfAbsent(target, this::newChannel);
    }

    private ManagedChannel newChannel(String target) {
        return ManagedChannelBuilder.forTarget((String)target).build();
    }
}

