/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.MessageMetadata;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.DefaultRoutingPolicy;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.internal.wire.AutoValue_PartitionCountWatchingPublisherSettings;
import com.google.cloud.pubsublite.internal.wire.PartitionCountWatcherImpl;
import com.google.cloud.pubsublite.internal.wire.PartitionCountWatchingPublisher;
import com.google.cloud.pubsublite.internal.wire.PartitionPublisherFactory;
import java.time.Duration;

@AutoValue
public abstract class PartitionCountWatchingPublisherSettings {
    abstract TopicPath topic();

    abstract PartitionPublisherFactory publisherFactory();

    abstract AdminClient adminClient();

    abstract Duration configPollPeriod();

    public static Builder newBuilder() {
        return new AutoValue_PartitionCountWatchingPublisherSettings.Builder().setConfigPollPeriod(Duration.ofMinutes(10L));
    }

    public Publisher<MessageMetadata> instantiate() throws ApiException {
        return new PartitionCountWatchingPublisher(this.publisherFactory(), DefaultRoutingPolicy::new, new PartitionCountWatcherImpl.Factory(this.topic(), this.adminClient(), this.configPollPeriod()));
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setTopic(TopicPath var1);

        public abstract Builder setPublisherFactory(PartitionPublisherFactory var1);

        public abstract Builder setAdminClient(AdminClient var1);

        public abstract Builder setConfigPollPeriod(Duration var1);

        public abstract PartitionCountWatchingPublisherSettings build();
    }
}

