/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsublite.proto.CommitCursorRequest;
import com.google.cloud.pubsublite.proto.CommitCursorResponse;
import com.google.cloud.pubsublite.proto.ListPartitionCursorsRequest;
import com.google.cloud.pubsublite.proto.ListPartitionCursorsResponse;
import com.google.cloud.pubsublite.proto.PartitionCursor;
import com.google.cloud.pubsublite.proto.StreamingCommitCursorRequest;
import com.google.cloud.pubsublite.proto.StreamingCommitCursorResponse;
import com.google.cloud.pubsublite.proto.SubscriptionName;
import com.google.cloud.pubsublite.v1.CursorServiceSettings;
import com.google.cloud.pubsublite.v1.stub.CursorServiceStub;
import com.google.cloud.pubsublite.v1.stub.CursorServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CursorServiceClient
implements BackgroundResource {
    private final CursorServiceSettings settings;
    private final CursorServiceStub stub;

    public static final CursorServiceClient create() throws IOException {
        return CursorServiceClient.create(CursorServiceSettings.newBuilder().build());
    }

    public static final CursorServiceClient create(CursorServiceSettings settings) throws IOException {
        return new CursorServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CursorServiceClient create(CursorServiceStub stub) {
        return new CursorServiceClient(stub);
    }

    protected CursorServiceClient(CursorServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CursorServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CursorServiceClient(CursorServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CursorServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CursorServiceStub getStub() {
        return this.stub;
    }

    public final BidiStreamingCallable<StreamingCommitCursorRequest, StreamingCommitCursorResponse> streamingCommitCursorCallable() {
        return this.stub.streamingCommitCursorCallable();
    }

    public final CommitCursorResponse commitCursor(CommitCursorRequest request) {
        return (CommitCursorResponse)this.commitCursorCallable().call((Object)request);
    }

    public final UnaryCallable<CommitCursorRequest, CommitCursorResponse> commitCursorCallable() {
        return this.stub.commitCursorCallable();
    }

    public final ListPartitionCursorsPagedResponse listPartitionCursors(SubscriptionName parent) {
        ListPartitionCursorsRequest request = ListPartitionCursorsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPartitionCursors(request);
    }

    public final ListPartitionCursorsPagedResponse listPartitionCursors(String parent) {
        ListPartitionCursorsRequest request = ListPartitionCursorsRequest.newBuilder().setParent(parent).build();
        return this.listPartitionCursors(request);
    }

    public final ListPartitionCursorsPagedResponse listPartitionCursors(ListPartitionCursorsRequest request) {
        return (ListPartitionCursorsPagedResponse)((Object)this.listPartitionCursorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPartitionCursorsRequest, ListPartitionCursorsPagedResponse> listPartitionCursorsPagedCallable() {
        return this.stub.listPartitionCursorsPagedCallable();
    }

    public final UnaryCallable<ListPartitionCursorsRequest, ListPartitionCursorsResponse> listPartitionCursorsCallable() {
        return this.stub.listPartitionCursorsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListPartitionCursorsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPartitionCursorsRequest, ListPartitionCursorsResponse, PartitionCursor, ListPartitionCursorsPage, ListPartitionCursorsFixedSizeCollection> {
        private ListPartitionCursorsFixedSizeCollection(List<ListPartitionCursorsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPartitionCursorsFixedSizeCollection createEmptyCollection() {
            return new ListPartitionCursorsFixedSizeCollection(null, 0);
        }

        protected ListPartitionCursorsFixedSizeCollection createCollection(List<ListPartitionCursorsPage> pages, int collectionSize) {
            return new ListPartitionCursorsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPartitionCursorsPage
    extends AbstractPage<ListPartitionCursorsRequest, ListPartitionCursorsResponse, PartitionCursor, ListPartitionCursorsPage> {
        private ListPartitionCursorsPage(PageContext<ListPartitionCursorsRequest, ListPartitionCursorsResponse, PartitionCursor> context, ListPartitionCursorsResponse response) {
            super(context, (Object)response);
        }

        private static ListPartitionCursorsPage createEmptyPage() {
            return new ListPartitionCursorsPage(null, null);
        }

        protected ListPartitionCursorsPage createPage(PageContext<ListPartitionCursorsRequest, ListPartitionCursorsResponse, PartitionCursor> context, ListPartitionCursorsResponse response) {
            return new ListPartitionCursorsPage(context, response);
        }

        public ApiFuture<ListPartitionCursorsPage> createPageAsync(PageContext<ListPartitionCursorsRequest, ListPartitionCursorsResponse, PartitionCursor> context, ApiFuture<ListPartitionCursorsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPartitionCursorsPagedResponse
    extends AbstractPagedListResponse<ListPartitionCursorsRequest, ListPartitionCursorsResponse, PartitionCursor, ListPartitionCursorsPage, ListPartitionCursorsFixedSizeCollection> {
        public static ApiFuture<ListPartitionCursorsPagedResponse> createAsync(PageContext<ListPartitionCursorsRequest, ListPartitionCursorsResponse, PartitionCursor> context, ApiFuture<ListPartitionCursorsResponse> futureResponse) {
            ApiFuture<ListPartitionCursorsPage> futurePage = ListPartitionCursorsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPartitionCursorsPage, ListPartitionCursorsPagedResponse>(){

                public ListPartitionCursorsPagedResponse apply(ListPartitionCursorsPage input) {
                    return new ListPartitionCursorsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPartitionCursorsPagedResponse(ListPartitionCursorsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPartitionCursorsFixedSizeCollection.createEmptyCollection());
        }
    }
}

