package com.google.cloud.pubsublite;

import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ReservationPath extends ReservationPath {

  private final ProjectIdOrNumber project;

  private final CloudRegion location;

  private final ReservationName name;

  private AutoValue_ReservationPath(
      ProjectIdOrNumber project,
      CloudRegion location,
      ReservationName name) {
    this.project = project;
    this.location = location;
    this.name = name;
  }

  @Override
  public ProjectIdOrNumber project() {
    return project;
  }

  @Override
  public CloudRegion location() {
    return location;
  }

  @Override
  public ReservationName name() {
    return name;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ReservationPath) {
      ReservationPath that = (ReservationPath) o;
      return this.project.equals(that.project())
          && this.location.equals(that.location())
          && this.name.equals(that.name());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= project.hashCode();
    h$ *= 1000003;
    h$ ^= location.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    return h$;
  }

  @Override
  public ReservationPath.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends ReservationPath.Builder {
    private ProjectIdOrNumber project;
    private CloudRegion location;
    private ReservationName name;
    Builder() {
    }
    private Builder(ReservationPath source) {
      this.project = source.project();
      this.location = source.location();
      this.name = source.name();
    }
    @Override
    public ReservationPath.Builder setProject(ProjectIdOrNumber project) {
      if (project == null) {
        throw new NullPointerException("Null project");
      }
      this.project = project;
      return this;
    }
    @Override
    public ReservationPath.Builder setLocation(CloudRegion location) {
      if (location == null) {
        throw new NullPointerException("Null location");
      }
      this.location = location;
      return this;
    }
    @Override
    public ReservationPath.Builder setName(ReservationName name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public ReservationPath build() {
      String missing = "";
      if (this.project == null) {
        missing += " project";
      }
      if (this.location == null) {
        missing += " location";
      }
      if (this.name == null) {
        missing += " name";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ReservationPath(
          this.project,
          this.location,
          this.name);
    }
  }

}
