package com.google.cloud.pubsublite.internal;

import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.v1.TopicStatsServiceClient;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_TopicStatsClientSettings extends TopicStatsClientSettings {

  private final CloudRegion region;

  private final Optional<TopicStatsServiceClient> serviceClient;

  private AutoValue_TopicStatsClientSettings(
      CloudRegion region,
      Optional<TopicStatsServiceClient> serviceClient) {
    this.region = region;
    this.serviceClient = serviceClient;
  }

  @Override
  CloudRegion region() {
    return region;
  }

  @Override
  Optional<TopicStatsServiceClient> serviceClient() {
    return serviceClient;
  }

  @Override
  public String toString() {
    return "TopicStatsClientSettings{"
        + "region=" + region + ", "
        + "serviceClient=" + serviceClient
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof TopicStatsClientSettings) {
      TopicStatsClientSettings that = (TopicStatsClientSettings) o;
      return this.region.equals(that.region())
          && this.serviceClient.equals(that.serviceClient());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= region.hashCode();
    h$ *= 1000003;
    h$ ^= serviceClient.hashCode();
    return h$;
  }

  static final class Builder extends TopicStatsClientSettings.Builder {
    private CloudRegion region;
    private Optional<TopicStatsServiceClient> serviceClient = Optional.empty();
    Builder() {
    }
    @Override
    public TopicStatsClientSettings.Builder setRegion(CloudRegion region) {
      if (region == null) {
        throw new NullPointerException("Null region");
      }
      this.region = region;
      return this;
    }
    @Override
    public TopicStatsClientSettings.Builder setServiceClient(TopicStatsServiceClient serviceClient) {
      this.serviceClient = Optional.of(serviceClient);
      return this;
    }
    @Override
    public TopicStatsClientSettings build() {
      String missing = "";
      if (this.region == null) {
        missing += " region";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_TopicStatsClientSettings(
          this.region,
          this.serviceClient);
    }
  }

}
