package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SequencedMessage;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.proto.SeekRequest;
import com.google.cloud.pubsublite.v1.SubscriberServiceClient;
import com.google.common.collect.ImmutableList;
import java.util.function.Consumer;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SubscriberBuilder extends SubscriberBuilder {

  private final Consumer<ImmutableList<SequencedMessage>> messageConsumer;

  private final SubscriptionPath subscriptionPath;

  private final Partition partition;

  private final SubscriberServiceClient serviceClient;

  private final SeekRequest initialLocation;

  private final SubscriberResetHandler resetHandler;

  private AutoValue_SubscriberBuilder(
      Consumer<ImmutableList<SequencedMessage>> messageConsumer,
      SubscriptionPath subscriptionPath,
      Partition partition,
      SubscriberServiceClient serviceClient,
      SeekRequest initialLocation,
      SubscriberResetHandler resetHandler) {
    this.messageConsumer = messageConsumer;
    this.subscriptionPath = subscriptionPath;
    this.partition = partition;
    this.serviceClient = serviceClient;
    this.initialLocation = initialLocation;
    this.resetHandler = resetHandler;
  }

  @Override
  Consumer<ImmutableList<SequencedMessage>> messageConsumer() {
    return messageConsumer;
  }

  @Override
  SubscriptionPath subscriptionPath() {
    return subscriptionPath;
  }

  @Override
  Partition partition() {
    return partition;
  }

  @Override
  SubscriberServiceClient serviceClient() {
    return serviceClient;
  }

  @Override
  SeekRequest initialLocation() {
    return initialLocation;
  }

  @Override
  SubscriberResetHandler resetHandler() {
    return resetHandler;
  }

  @Override
  public String toString() {
    return "SubscriberBuilder{"
        + "messageConsumer=" + messageConsumer + ", "
        + "subscriptionPath=" + subscriptionPath + ", "
        + "partition=" + partition + ", "
        + "serviceClient=" + serviceClient + ", "
        + "initialLocation=" + initialLocation + ", "
        + "resetHandler=" + resetHandler
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SubscriberBuilder) {
      SubscriberBuilder that = (SubscriberBuilder) o;
      return this.messageConsumer.equals(that.messageConsumer())
          && this.subscriptionPath.equals(that.subscriptionPath())
          && this.partition.equals(that.partition())
          && this.serviceClient.equals(that.serviceClient())
          && this.initialLocation.equals(that.initialLocation())
          && this.resetHandler.equals(that.resetHandler());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= messageConsumer.hashCode();
    h$ *= 1000003;
    h$ ^= subscriptionPath.hashCode();
    h$ *= 1000003;
    h$ ^= partition.hashCode();
    h$ *= 1000003;
    h$ ^= serviceClient.hashCode();
    h$ *= 1000003;
    h$ ^= initialLocation.hashCode();
    h$ *= 1000003;
    h$ ^= resetHandler.hashCode();
    return h$;
  }

  static final class Builder extends SubscriberBuilder.Builder {
    private Consumer<ImmutableList<SequencedMessage>> messageConsumer;
    private SubscriptionPath subscriptionPath;
    private Partition partition;
    private SubscriberServiceClient serviceClient;
    private SeekRequest initialLocation;
    private SubscriberResetHandler resetHandler;
    Builder() {
    }
    @Override
    public SubscriberBuilder.Builder setMessageConsumer(Consumer<ImmutableList<SequencedMessage>> messageConsumer) {
      if (messageConsumer == null) {
        throw new NullPointerException("Null messageConsumer");
      }
      this.messageConsumer = messageConsumer;
      return this;
    }
    @Override
    public SubscriberBuilder.Builder setSubscriptionPath(SubscriptionPath subscriptionPath) {
      if (subscriptionPath == null) {
        throw new NullPointerException("Null subscriptionPath");
      }
      this.subscriptionPath = subscriptionPath;
      return this;
    }
    @Override
    public SubscriberBuilder.Builder setPartition(Partition partition) {
      if (partition == null) {
        throw new NullPointerException("Null partition");
      }
      this.partition = partition;
      return this;
    }
    @Override
    public SubscriberBuilder.Builder setServiceClient(SubscriberServiceClient serviceClient) {
      if (serviceClient == null) {
        throw new NullPointerException("Null serviceClient");
      }
      this.serviceClient = serviceClient;
      return this;
    }
    @Override
    public SubscriberBuilder.Builder setInitialLocation(SeekRequest initialLocation) {
      if (initialLocation == null) {
        throw new NullPointerException("Null initialLocation");
      }
      this.initialLocation = initialLocation;
      return this;
    }
    @Override
    public SubscriberBuilder.Builder setResetHandler(SubscriberResetHandler resetHandler) {
      if (resetHandler == null) {
        throw new NullPointerException("Null resetHandler");
      }
      this.resetHandler = resetHandler;
      return this;
    }
    @Override
    SubscriberBuilder autoBuild() {
      String missing = "";
      if (this.messageConsumer == null) {
        missing += " messageConsumer";
      }
      if (this.subscriptionPath == null) {
        missing += " subscriptionPath";
      }
      if (this.partition == null) {
        missing += " partition";
      }
      if (this.serviceClient == null) {
        missing += " serviceClient";
      }
      if (this.initialLocation == null) {
        missing += " initialLocation";
      }
      if (this.resetHandler == null) {
        missing += " resetHandler";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SubscriberBuilder(
          this.messageConsumer,
          this.subscriptionPath,
          this.partition,
          this.serviceClient,
          this.initialLocation,
          this.resetHandler);
    }
  }

}
