/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.AutoValue_SubscriptionPath;
import com.google.cloud.pubsublite.CloudRegionOrZone;
import com.google.cloud.pubsublite.CloudZone;
import com.google.cloud.pubsublite.LocationPath;
import com.google.cloud.pubsublite.ProjectBuilderHelper;
import com.google.cloud.pubsublite.ProjectIdOrNumber;
import com.google.cloud.pubsublite.SubscriptionName;
import com.google.cloud.pubsublite.internal.UncheckedApiPreconditions;
import java.io.Serializable;
import java.util.Arrays;

@AutoValue
public abstract class SubscriptionPath
implements Serializable {
    public abstract ProjectIdOrNumber project();

    public abstract CloudZone location();

    public abstract SubscriptionName name();

    public LocationPath locationPath() {
        return ((LocationPath.Builder)((LocationPath.Builder)LocationPath.newBuilder().setProject(this.project())).setLocation(this.location())).build();
    }

    public String toString() {
        return this.locationPath() + "/subscriptions/" + this.name();
    }

    public static Builder newBuilder() {
        return new AutoValue_SubscriptionPath.Builder();
    }

    public abstract Builder toBuilder();

    public static SubscriptionPath parse(String path) throws ApiException {
        String[] splits = path.split("/");
        UncheckedApiPreconditions.checkArgument(splits.length == 6);
        UncheckedApiPreconditions.checkArgument(splits[4].equals("subscriptions"));
        LocationPath location = LocationPath.parse(String.join((CharSequence)"/", Arrays.copyOf(splits, 4)));
        UncheckedApiPreconditions.checkArgument(location.location().getKind() == CloudRegionOrZone.Kind.ZONE, "Subscription location must be a valid cloud zone.");
        return ((Builder)SubscriptionPath.newBuilder().setProject(location.project())).setLocation(location.location().zone()).setName(SubscriptionName.of(splits[5])).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends ProjectBuilderHelper<Builder> {
        public abstract Builder setLocation(CloudZone var1);

        public abstract Builder setName(SubscriptionName var1);

        public abstract SubscriptionPath build();
    }
}

