/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.LocationPath;
import com.google.cloud.pubsublite.ReservationPath;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.ApiResourceAggregation;
import com.google.cloud.pubsublite.proto.CreateReservationRequest;
import com.google.cloud.pubsublite.proto.CreateSubscriptionRequest;
import com.google.cloud.pubsublite.proto.CreateTopicRequest;
import com.google.cloud.pubsublite.proto.DeleteReservationRequest;
import com.google.cloud.pubsublite.proto.DeleteSubscriptionRequest;
import com.google.cloud.pubsublite.proto.DeleteTopicRequest;
import com.google.cloud.pubsublite.proto.GetReservationRequest;
import com.google.cloud.pubsublite.proto.GetSubscriptionRequest;
import com.google.cloud.pubsublite.proto.GetTopicPartitionsRequest;
import com.google.cloud.pubsublite.proto.GetTopicRequest;
import com.google.cloud.pubsublite.proto.ListReservationTopicsRequest;
import com.google.cloud.pubsublite.proto.ListReservationsRequest;
import com.google.cloud.pubsublite.proto.ListReservationsResponse;
import com.google.cloud.pubsublite.proto.ListSubscriptionsRequest;
import com.google.cloud.pubsublite.proto.ListSubscriptionsResponse;
import com.google.cloud.pubsublite.proto.ListTopicSubscriptionsRequest;
import com.google.cloud.pubsublite.proto.ListTopicsRequest;
import com.google.cloud.pubsublite.proto.ListTopicsResponse;
import com.google.cloud.pubsublite.proto.Reservation;
import com.google.cloud.pubsublite.proto.Subscription;
import com.google.cloud.pubsublite.proto.Topic;
import com.google.cloud.pubsublite.proto.TopicPartitions;
import com.google.cloud.pubsublite.proto.UpdateReservationRequest;
import com.google.cloud.pubsublite.proto.UpdateSubscriptionRequest;
import com.google.cloud.pubsublite.proto.UpdateTopicRequest;
import com.google.cloud.pubsublite.v1.AdminServiceClient;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.FieldMask;
import java.util.List;
import java.util.concurrent.Executor;

public class AdminClientImpl
extends ApiResourceAggregation
implements AdminClient {
    private final CloudRegion region;
    AdminServiceClient serviceClient;

    public AdminClientImpl(CloudRegion region, AdminServiceClient serviceClient) {
        super(serviceClient);
        this.region = region;
        this.serviceClient = serviceClient;
    }

    @Override
    public CloudRegion region() {
        return this.region;
    }

    @Override
    public ApiFuture<Topic> createTopic(Topic topic) {
        TopicPath path = TopicPath.parse(topic.getName());
        return this.serviceClient.createTopicCallable().futureCall((Object)CreateTopicRequest.newBuilder().setParent(path.locationPath().toString()).setTopic(topic).setTopicId(path.name().value()).build());
    }

    @Override
    public ApiFuture<Topic> getTopic(TopicPath path) {
        return this.serviceClient.getTopicCallable().futureCall((Object)GetTopicRequest.newBuilder().setName(path.toString()).build());
    }

    @Override
    public ApiFuture<Long> getTopicPartitionCount(TopicPath path) {
        return ApiFutures.transform((ApiFuture)this.serviceClient.getTopicPartitionsCallable().futureCall((Object)GetTopicPartitionsRequest.newBuilder().setName(path.toString()).build()), TopicPartitions::getPartitionCount, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public ApiFuture<List<Topic>> listTopics(LocationPath path) {
        return ApiFutures.transform((ApiFuture)this.serviceClient.listTopicsCallable().futureCall((Object)ListTopicsRequest.newBuilder().setParent(path.toString()).build()), ListTopicsResponse::getTopicsList, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public ApiFuture<Topic> updateTopic(Topic topic, FieldMask mask) {
        return this.serviceClient.updateTopicCallable().futureCall((Object)UpdateTopicRequest.newBuilder().setTopic(topic).setUpdateMask(mask).build());
    }

    @Override
    public ApiFuture<Void> deleteTopic(TopicPath path) {
        return ApiFutures.transform((ApiFuture)this.serviceClient.deleteTopicCallable().futureCall((Object)DeleteTopicRequest.newBuilder().setName(path.toString()).build()), x -> null, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public ApiFuture<List<SubscriptionPath>> listTopicSubscriptions(TopicPath path) {
        return ApiFutures.transform((ApiFuture)this.serviceClient.listTopicSubscriptionsCallable().futureCall((Object)ListTopicSubscriptionsRequest.newBuilder().setName(path.toString()).build()), result -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String subscription : result.getSubscriptionsList()) {
                builder.add((Object)SubscriptionPath.parse(subscription));
            }
            return builder.build();
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public ApiFuture<Subscription> createSubscription(Subscription subscription, AdminClient.BacklogLocation startingOffset) {
        SubscriptionPath path = SubscriptionPath.parse(subscription.getName());
        return this.serviceClient.createSubscriptionCallable().futureCall((Object)CreateSubscriptionRequest.newBuilder().setParent(path.locationPath().toString()).setSubscription(subscription).setSubscriptionId(path.name().toString()).setSkipBacklog(startingOffset == AdminClient.BacklogLocation.END).build());
    }

    @Override
    public ApiFuture<Subscription> getSubscription(SubscriptionPath path) {
        return this.serviceClient.getSubscriptionCallable().futureCall((Object)GetSubscriptionRequest.newBuilder().setName(path.toString()).build());
    }

    @Override
    public ApiFuture<List<Subscription>> listSubscriptions(LocationPath path) {
        return ApiFutures.transform((ApiFuture)this.serviceClient.listSubscriptionsCallable().futureCall((Object)ListSubscriptionsRequest.newBuilder().setParent(path.toString()).build()), ListSubscriptionsResponse::getSubscriptionsList, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public ApiFuture<Subscription> updateSubscription(Subscription subscription, FieldMask mask) {
        return this.serviceClient.updateSubscriptionCallable().futureCall((Object)UpdateSubscriptionRequest.newBuilder().setSubscription(subscription).setUpdateMask(mask).build());
    }

    @Override
    public ApiFuture<Void> deleteSubscription(SubscriptionPath path) {
        return ApiFutures.transform((ApiFuture)this.serviceClient.deleteSubscriptionCallable().futureCall((Object)DeleteSubscriptionRequest.newBuilder().setName(path.toString()).build()), x -> null, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public ApiFuture<Reservation> createReservation(Reservation reservation) {
        ReservationPath path = ReservationPath.parse(reservation.getName());
        return this.serviceClient.createReservationCallable().futureCall((Object)CreateReservationRequest.newBuilder().setParent(path.locationPath().toString()).setReservation(reservation).setReservationId(path.name().value()).build());
    }

    @Override
    public ApiFuture<Reservation> getReservation(ReservationPath path) {
        return this.serviceClient.getReservationCallable().futureCall((Object)GetReservationRequest.newBuilder().setName(path.toString()).build());
    }

    @Override
    public ApiFuture<List<Reservation>> listReservations(LocationPath path) {
        return ApiFutures.transform((ApiFuture)this.serviceClient.listReservationsCallable().futureCall((Object)ListReservationsRequest.newBuilder().setParent(path.toString()).build()), ListReservationsResponse::getReservationsList, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public ApiFuture<Reservation> updateReservation(Reservation reservation, FieldMask mask) {
        return this.serviceClient.updateReservationCallable().futureCall((Object)UpdateReservationRequest.newBuilder().setReservation(reservation).setUpdateMask(mask).build());
    }

    @Override
    public ApiFuture<Void> deleteReservation(ReservationPath path) {
        return ApiFutures.transform((ApiFuture)this.serviceClient.deleteReservationCallable().futureCall((Object)DeleteReservationRequest.newBuilder().setName(path.toString()).build()), x -> null, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public ApiFuture<List<TopicPath>> listReservationTopics(ReservationPath path) {
        return ApiFutures.transform((ApiFuture)this.serviceClient.listReservationTopicsCallable().futureCall((Object)ListReservationTopicsRequest.newBuilder().setName(path.toString()).build()), result -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String subscription : result.getTopicsList()) {
                builder.add((Object)TopicPath.parse(subscription));
            }
            return builder.build();
        }, (Executor)MoreExecutors.directExecutor());
    }
}

