/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SequencedMessage;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.internal.wire.SubscriberBuilder;
import com.google.cloud.pubsublite.internal.wire.SubscriberResetHandler;
import com.google.cloud.pubsublite.proto.SeekRequest;
import com.google.cloud.pubsublite.v1.SubscriberServiceClient;
import com.google.common.collect.ImmutableList;
import java.util.function.Consumer;

final class AutoValue_SubscriberBuilder
extends SubscriberBuilder {
    private final Consumer<ImmutableList<SequencedMessage>> messageConsumer;
    private final SubscriptionPath subscriptionPath;
    private final Partition partition;
    private final SubscriberServiceClient serviceClient;
    private final SeekRequest initialLocation;
    private final SubscriberResetHandler resetHandler;

    private AutoValue_SubscriberBuilder(Consumer<ImmutableList<SequencedMessage>> messageConsumer, SubscriptionPath subscriptionPath, Partition partition, SubscriberServiceClient serviceClient, SeekRequest initialLocation, SubscriberResetHandler resetHandler) {
        this.messageConsumer = messageConsumer;
        this.subscriptionPath = subscriptionPath;
        this.partition = partition;
        this.serviceClient = serviceClient;
        this.initialLocation = initialLocation;
        this.resetHandler = resetHandler;
    }

    @Override
    Consumer<ImmutableList<SequencedMessage>> messageConsumer() {
        return this.messageConsumer;
    }

    @Override
    SubscriptionPath subscriptionPath() {
        return this.subscriptionPath;
    }

    @Override
    Partition partition() {
        return this.partition;
    }

    @Override
    SubscriberServiceClient serviceClient() {
        return this.serviceClient;
    }

    @Override
    SeekRequest initialLocation() {
        return this.initialLocation;
    }

    @Override
    SubscriberResetHandler resetHandler() {
        return this.resetHandler;
    }

    public String toString() {
        return "SubscriberBuilder{messageConsumer=" + this.messageConsumer + ", subscriptionPath=" + this.subscriptionPath + ", partition=" + this.partition + ", serviceClient=" + this.serviceClient + ", initialLocation=" + this.initialLocation + ", resetHandler=" + this.resetHandler + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SubscriberBuilder) {
            SubscriberBuilder that = (SubscriberBuilder)o;
            return this.messageConsumer.equals(that.messageConsumer()) && this.subscriptionPath.equals(that.subscriptionPath()) && this.partition.equals(that.partition()) && this.serviceClient.equals(that.serviceClient()) && this.initialLocation.equals((Object)that.initialLocation()) && this.resetHandler.equals(that.resetHandler());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.messageConsumer.hashCode();
        h$ *= 1000003;
        h$ ^= this.subscriptionPath.hashCode();
        h$ *= 1000003;
        h$ ^= this.partition.hashCode();
        h$ *= 1000003;
        h$ ^= this.serviceClient.hashCode();
        h$ *= 1000003;
        h$ ^= this.initialLocation.hashCode();
        h$ *= 1000003;
        return h$ ^= this.resetHandler.hashCode();
    }

    static final class Builder
    extends SubscriberBuilder.Builder {
        private Consumer<ImmutableList<SequencedMessage>> messageConsumer;
        private SubscriptionPath subscriptionPath;
        private Partition partition;
        private SubscriberServiceClient serviceClient;
        private SeekRequest initialLocation;
        private SubscriberResetHandler resetHandler;

        Builder() {
        }

        @Override
        public SubscriberBuilder.Builder setMessageConsumer(Consumer<ImmutableList<SequencedMessage>> messageConsumer) {
            if (messageConsumer == null) {
                throw new NullPointerException("Null messageConsumer");
            }
            this.messageConsumer = messageConsumer;
            return this;
        }

        @Override
        public SubscriberBuilder.Builder setSubscriptionPath(SubscriptionPath subscriptionPath) {
            if (subscriptionPath == null) {
                throw new NullPointerException("Null subscriptionPath");
            }
            this.subscriptionPath = subscriptionPath;
            return this;
        }

        @Override
        public SubscriberBuilder.Builder setPartition(Partition partition) {
            if (partition == null) {
                throw new NullPointerException("Null partition");
            }
            this.partition = partition;
            return this;
        }

        @Override
        public SubscriberBuilder.Builder setServiceClient(SubscriberServiceClient serviceClient) {
            if (serviceClient == null) {
                throw new NullPointerException("Null serviceClient");
            }
            this.serviceClient = serviceClient;
            return this;
        }

        @Override
        public SubscriberBuilder.Builder setInitialLocation(SeekRequest initialLocation) {
            if (initialLocation == null) {
                throw new NullPointerException("Null initialLocation");
            }
            this.initialLocation = initialLocation;
            return this;
        }

        @Override
        public SubscriberBuilder.Builder setResetHandler(SubscriberResetHandler resetHandler) {
            if (resetHandler == null) {
                throw new NullPointerException("Null resetHandler");
            }
            this.resetHandler = resetHandler;
            return this;
        }

        @Override
        SubscriberBuilder autoBuild() {
            String missing = "";
            if (this.messageConsumer == null) {
                missing = missing + " messageConsumer";
            }
            if (this.subscriptionPath == null) {
                missing = missing + " subscriptionPath";
            }
            if (this.partition == null) {
                missing = missing + " partition";
            }
            if (this.serviceClient == null) {
                missing = missing + " serviceClient";
            }
            if (this.initialLocation == null) {
                missing = missing + " initialLocation";
            }
            if (this.resetHandler == null) {
                missing = missing + " resetHandler";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SubscriberBuilder(this.messageConsumer, this.subscriptionPath, this.partition, this.serviceClient, this.initialLocation, this.resetHandler);
        }
    }
}

