/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SequencedMessage;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.internal.wire.ApiExceptionSubscriber;
import com.google.cloud.pubsublite.internal.wire.AutoValue_SubscriberBuilder;
import com.google.cloud.pubsublite.internal.wire.Subscriber;
import com.google.cloud.pubsublite.internal.wire.SubscriberImpl;
import com.google.cloud.pubsublite.internal.wire.SubscriberResetHandler;
import com.google.cloud.pubsublite.proto.InitialSubscribeRequest;
import com.google.cloud.pubsublite.proto.SeekRequest;
import com.google.cloud.pubsublite.v1.SubscriberServiceClient;
import com.google.common.collect.ImmutableList;
import java.util.function.Consumer;

@AutoValue
public abstract class SubscriberBuilder {
    abstract Consumer<ImmutableList<SequencedMessage>> messageConsumer();

    abstract SubscriptionPath subscriptionPath();

    abstract Partition partition();

    abstract SubscriberServiceClient serviceClient();

    abstract SeekRequest initialLocation();

    abstract SubscriberResetHandler resetHandler();

    public static Builder newBuilder() {
        return new AutoValue_SubscriberBuilder.Builder().setResetHandler(SubscriberResetHandler::unhandled);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setMessageConsumer(Consumer<ImmutableList<SequencedMessage>> var1);

        public abstract Builder setSubscriptionPath(SubscriptionPath var1);

        public abstract Builder setPartition(Partition var1);

        public abstract Builder setServiceClient(SubscriberServiceClient var1);

        public abstract Builder setInitialLocation(SeekRequest var1);

        public abstract Builder setResetHandler(SubscriberResetHandler var1);

        abstract SubscriberBuilder autoBuild();

        public Subscriber build() throws ApiException {
            SubscriberBuilder autoBuilt = this.autoBuild();
            InitialSubscribeRequest initialSubscribeRequest = InitialSubscribeRequest.newBuilder().setSubscription(autoBuilt.subscriptionPath().toString()).setPartition(autoBuilt.partition().value()).build();
            return new ApiExceptionSubscriber(new SubscriberImpl(autoBuilt.serviceClient(), initialSubscribeRequest, autoBuilt.initialLocation(), autoBuilt.messageConsumer(), autoBuilt.resetHandler()));
        }
    }
}

