/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.AdminClientSettings;
import com.google.cloud.pubsublite.BacklogLocation;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.LocationPath;
import com.google.cloud.pubsublite.ReservationPath;
import com.google.cloud.pubsublite.SeekTarget;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.ApiBackgroundResource;
import com.google.cloud.pubsublite.proto.OperationMetadata;
import com.google.cloud.pubsublite.proto.Reservation;
import com.google.cloud.pubsublite.proto.SeekSubscriptionResponse;
import com.google.cloud.pubsublite.proto.Subscription;
import com.google.cloud.pubsublite.proto.Topic;
import com.google.protobuf.FieldMask;
import java.util.List;

public interface AdminClient
extends ApiBackgroundResource {
    public static AdminClient create(AdminClientSettings settings) throws ApiException {
        return settings.instantiate();
    }

    public CloudRegion region();

    public ApiFuture<Topic> createTopic(Topic var1);

    public ApiFuture<Topic> getTopic(TopicPath var1);

    public ApiFuture<Long> getTopicPartitionCount(TopicPath var1);

    public ApiFuture<List<Topic>> listTopics(LocationPath var1);

    public ApiFuture<Topic> updateTopic(Topic var1, FieldMask var2);

    public ApiFuture<Void> deleteTopic(TopicPath var1);

    public ApiFuture<List<SubscriptionPath>> listTopicSubscriptions(TopicPath var1);

    default public ApiFuture<Subscription> createSubscription(Subscription subscription) {
        return this.createSubscription(subscription, BacklogLocation.END);
    }

    public ApiFuture<Subscription> createSubscription(Subscription var1, BacklogLocation var2);

    public ApiFuture<Subscription> getSubscription(SubscriptionPath var1);

    public ApiFuture<List<Subscription>> listSubscriptions(LocationPath var1);

    public ApiFuture<Subscription> updateSubscription(Subscription var1, FieldMask var2);

    @BetaApi(value="This may not be implemented in the backend, it is a pre-release feature.")
    public OperationFuture<SeekSubscriptionResponse, OperationMetadata> seekSubscription(SubscriptionPath var1, SeekTarget var2);

    public ApiFuture<Void> deleteSubscription(SubscriptionPath var1);

    @BetaApi(value="This may not be implemented in the backend, it is a pre-release feature.")
    public ApiFuture<Reservation> createReservation(Reservation var1);

    @BetaApi(value="This may not be implemented in the backend, it is a pre-release feature.")
    public ApiFuture<Reservation> getReservation(ReservationPath var1);

    @BetaApi(value="This may not be implemented in the backend, it is a pre-release feature.")
    public ApiFuture<List<Reservation>> listReservations(LocationPath var1);

    @BetaApi(value="This may not be implemented in the backend, it is a pre-release feature.")
    public ApiFuture<Reservation> updateReservation(Reservation var1, FieldMask var2);

    @BetaApi(value="This may not be implemented in the backend, it is a pre-release feature.")
    public ApiFuture<Void> deleteReservation(ReservationPath var1);

    @BetaApi(value="This may not be implemented in the backend, it is a pre-release feature.")
    public ApiFuture<List<TopicPath>> listReservationTopics(ReservationPath var1);
}

