package com.google.cloud.pubsublite.cloudpubsub;

import com.google.api.gax.batching.BatchingSettings;
import com.google.cloud.pubsublite.Message;
import com.google.cloud.pubsublite.MessageTransformer;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.wire.SinglePartitionPublisherBuilder;
import com.google.cloud.pubsublite.proto.PublisherServiceGrpc;
import com.google.pubsub.v1.PubsubMessage;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_PublisherSettings extends PublisherSettings {

  private final TopicPath topicPath;

  private final Optional<KeyExtractor> keyExtractor;

  private final Optional<MessageTransformer<PubsubMessage, Message>> messageTransformer;

  private final Optional<BatchingSettings> batchingSettings;

  private final Optional<PublisherServiceGrpc.PublisherServiceStub> stub;

  private final SinglePartitionPublisherBuilder.Builder underlyingBuilder;

  private final Optional<Integer> numPartitions;

  private AutoValue_PublisherSettings(
      TopicPath topicPath,
      Optional<KeyExtractor> keyExtractor,
      Optional<MessageTransformer<PubsubMessage, Message>> messageTransformer,
      Optional<BatchingSettings> batchingSettings,
      Optional<PublisherServiceGrpc.PublisherServiceStub> stub,
      SinglePartitionPublisherBuilder.Builder underlyingBuilder,
      Optional<Integer> numPartitions) {
    this.topicPath = topicPath;
    this.keyExtractor = keyExtractor;
    this.messageTransformer = messageTransformer;
    this.batchingSettings = batchingSettings;
    this.stub = stub;
    this.underlyingBuilder = underlyingBuilder;
    this.numPartitions = numPartitions;
  }

  @Override
  TopicPath topicPath() {
    return topicPath;
  }

  @Override
  Optional<KeyExtractor> keyExtractor() {
    return keyExtractor;
  }

  @Override
  Optional<MessageTransformer<PubsubMessage, Message>> messageTransformer() {
    return messageTransformer;
  }

  @Override
  Optional<BatchingSettings> batchingSettings() {
    return batchingSettings;
  }

  @Override
  Optional<PublisherServiceGrpc.PublisherServiceStub> stub() {
    return stub;
  }

  @Override
  SinglePartitionPublisherBuilder.Builder underlyingBuilder() {
    return underlyingBuilder;
  }

  @Override
  Optional<Integer> numPartitions() {
    return numPartitions;
  }

  @Override
  public String toString() {
    return "PublisherSettings{"
        + "topicPath=" + topicPath + ", "
        + "keyExtractor=" + keyExtractor + ", "
        + "messageTransformer=" + messageTransformer + ", "
        + "batchingSettings=" + batchingSettings + ", "
        + "stub=" + stub + ", "
        + "underlyingBuilder=" + underlyingBuilder + ", "
        + "numPartitions=" + numPartitions
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PublisherSettings) {
      PublisherSettings that = (PublisherSettings) o;
      return this.topicPath.equals(that.topicPath())
          && this.keyExtractor.equals(that.keyExtractor())
          && this.messageTransformer.equals(that.messageTransformer())
          && this.batchingSettings.equals(that.batchingSettings())
          && this.stub.equals(that.stub())
          && this.underlyingBuilder.equals(that.underlyingBuilder())
          && this.numPartitions.equals(that.numPartitions());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= topicPath.hashCode();
    h$ *= 1000003;
    h$ ^= keyExtractor.hashCode();
    h$ *= 1000003;
    h$ ^= messageTransformer.hashCode();
    h$ *= 1000003;
    h$ ^= batchingSettings.hashCode();
    h$ *= 1000003;
    h$ ^= stub.hashCode();
    h$ *= 1000003;
    h$ ^= underlyingBuilder.hashCode();
    h$ *= 1000003;
    h$ ^= numPartitions.hashCode();
    return h$;
  }

  static final class Builder extends PublisherSettings.Builder {
    private TopicPath topicPath;
    private Optional<KeyExtractor> keyExtractor = Optional.empty();
    private Optional<MessageTransformer<PubsubMessage, Message>> messageTransformer = Optional.empty();
    private Optional<BatchingSettings> batchingSettings = Optional.empty();
    private Optional<PublisherServiceGrpc.PublisherServiceStub> stub = Optional.empty();
    private SinglePartitionPublisherBuilder.Builder underlyingBuilder;
    private Optional<Integer> numPartitions = Optional.empty();
    Builder() {
    }
    @Override
    public PublisherSettings.Builder setTopicPath(TopicPath topicPath) {
      if (topicPath == null) {
        throw new NullPointerException("Null topicPath");
      }
      this.topicPath = topicPath;
      return this;
    }
    @Override
    public PublisherSettings.Builder setKeyExtractor(KeyExtractor keyExtractor) {
      this.keyExtractor = Optional.of(keyExtractor);
      return this;
    }
    @Override
    public PublisherSettings.Builder setMessageTransformer(MessageTransformer<PubsubMessage, Message> messageTransformer) {
      this.messageTransformer = Optional.of(messageTransformer);
      return this;
    }
    @Override
    public PublisherSettings.Builder setBatchingSettings(BatchingSettings batchingSettings) {
      this.batchingSettings = Optional.of(batchingSettings);
      return this;
    }
    @Override
    public PublisherSettings.Builder setStub(PublisherServiceGrpc.PublisherServiceStub stub) {
      this.stub = Optional.of(stub);
      return this;
    }
    @Override
    PublisherSettings.Builder setUnderlyingBuilder(SinglePartitionPublisherBuilder.Builder underlyingBuilder) {
      if (underlyingBuilder == null) {
        throw new NullPointerException("Null underlyingBuilder");
      }
      this.underlyingBuilder = underlyingBuilder;
      return this;
    }
    @Override
    PublisherSettings.Builder setNumPartitions(int numPartitions) {
      this.numPartitions = Optional.of(numPartitions);
      return this;
    }
    @Override
    public PublisherSettings build() {
      String missing = "";
      if (this.topicPath == null) {
        missing += " topicPath";
      }
      if (this.underlyingBuilder == null) {
        missing += " underlyingBuilder";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_PublisherSettings(
          this.topicPath,
          this.keyExtractor,
          this.messageTransformer,
          this.batchingSettings,
          this.stub,
          this.underlyingBuilder,
          this.numPartitions);
    }
  }

}
